// Windows-Timer zum bertrag von Debug-Meldungen
// in ein Steuerelement. Fr Meldungen reicht dann
// ein einfaches Lock anstelle von Control.Invoke.
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace TimerDebug
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button bStart;
		private System.Windows.Forms.ListBox listBox1;
		private System.Timers.Timer timer1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.bStart = new System.Windows.Forms.Button();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.timer1 = new System.Timers.Timer();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
			this.SuspendLayout();
			// 
			// bStart
			// 
			this.bStart.Location = new System.Drawing.Point(24, 32);
			this.bStart.Name = "bStart";
			this.bStart.Size = new System.Drawing.Size(224, 23);
			this.bStart.TabIndex = 0;
			this.bStart.Text = "Poolthread starten";
			this.toolTip1.SetToolTip(this.bStart, "Rckmeldungen generieren, die ein Timer en bloc in die Listbox kopiert");
			this.bStart.Click += new System.EventHandler(this.bStart_Click);
			// 
			// listBox1
			// 
			this.listBox1.Location = new System.Drawing.Point(24, 88);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(224, 160);
			this.listBox1.TabIndex = 1;
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.SynchronizingObject = this;
			this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 273);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.bStart);
			this.Name = "Form1";
			this.Text = "TimerDebug";
			((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		// Start eines (weiteren) PoolThreads, der Meldungen generiert
		int PoolThreadID = 0;

		private void bStart_Click(object sender, System.EventArgs e)
		{
		  ThreadPool.QueueUserWorkItem(new WaitCallback(BGThread), PoolThreadID++);
		}

    // Zwischenspeicherung der Meldungen der einzelnen Threads. Die Liste
		// wird per Timer en bloc in eine ListBox kopiert
		ArrayList DebugMsgs = new ArrayList();

		void BGThread(object Info)
		{
			for (int x = 0; x < 10; x++)
			{
        // synchronisierter Zugriff (ginge auch mit einem Synchronized-Wrapper)
				lock(DebugMsgs.SyncRoot)
					DebugMsgs.Add(String.Format("BG-Thread {0}, Iteration {1}", (int) Info, x));
        // "Arbeit" des Threads
				Thread.Sleep(300);
			}
		}

		// Auslesen und Darstellen von DebugMsgs im Vordergrund
		private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			lock(DebugMsgs.SyncRoot)
			{
				foreach(object DebugItem in DebugMsgs)
					listBox1.Items.Add(DebugItem);

				DebugMsgs.Clear();
			}
		}


	}
}
