	.module ct03.c
	.area text
	.dbfile F:\hwb\ct\0405\ct03\ct03.c
	.dbfunc e vClockInit _vClockInit fV
;              w -> R4
	.even
_vClockInit::
	push R4
	.dbline -1
	.dbline 75
; /***************************************************************************
; * Titel        : CT03.C
; *
; * Description  : Beispiel zur Ansteuerung eines Schrittmotors
; *
; * Environment  :
; *
; * Responsible  : J. Altenburg
; *
; * Guidelines   :
; *
; * Revision List:
;   --------------------------------------------------------------------------
;   Date     | Author          | Change
;   --------------------------------------------------------------------------
;   13.12.03 |J. Altenburg     | Ersterstellung
;   --------------------------------------------------------------------------
;            |                 |
;   --------------------------------------------------------------------------
; ****************************************************************************/
; 
; /***************************************************************************
; * HEADER-FILES (Only those that are needed in this file)                   *
; ****************************************************************************/
; /* System-headerfiles */
; #include "cdef.h"                      /* General definitions and types */
; 
; #include "msp430x14x.h"
; #include "msp430def.h"
; 
; /* Own headerfiles */
; 
; 
; /* Foreign headerfiles */
; #include "smd.h"
; 
; /***************************************************************************
; * Defines und Makros Zugriff                                               *
; ****************************************************************************/
; 
; /* Prototyp fr Funktionspointer */
; typedef void (* fLocalFunc)( void ); /* Funktionspointer */
; 
; 
; 
; /***************************************************************************
; *    Variablen                                                             *
; ****************************************************************************/
; 
; byte bClick; /*
; * Description : wird von der Timer-ISR gesetzt
; */
; 
; word wAdc0; /*
; * Description : beinhaltet Analogwert
; */
; 
; word wAdc1; /*
; * Description : 
; */
; 
; byte bJA;
; 
; /***************************************************************************
; *    lokale Funktionsprototypen fr Funktionspointerliste                  *
; ****************************************************************************/
; void vMessage( void );
; 
; 
; /***************************************************************************
; *    Funktion: Hardware-Initialisierung (Application Builder)              *
; *                                                                          *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void vClockInit( void ){
	.dbline 78
;      word w;
;      // DCOCTL  = 0x00;
;      WDTCTL = WDTPW + WDTHOLD;     /* Watchdog deaktivieren */
	mov #23168,&0x120
	.dbline 80
; #if 1
;      P5DIR |= 0x10;                /* 8MHz-CLK am Pin 48 */
	or.b #16,&0x32
	.dbline 81
;      P5SEL |= 0x10;
	or.b #16,&0x33
	.dbline 82
;      P5DIR |= 0x20;                /* SMCLK an Pin 49 */
	or.b #32,&0x32
	.dbline 83
;      P5SEL |= 0x20;
	or.b #32,&0x33
	.dbline 85
; #endif
;      BCSCTL1 &= ~XT2OFF;           /* Oszillator on */
	and.b #-129,&0x57
L2:
	.dbline 86
;      do  {
	.dbline 87
;           IFG1 &= ~OFIFG;
	and.b #-3,&0x2
	.dbline 88
	mov #255,R4
	jmp L8
L5:
	.dbline 88
L6:
	.dbline 88
	sub #1,R4
L8:
	.dbline 88
;           for(w = 0xff; w > 0; w--);
	cmp #0,R4
	jne L5
	.dbline 89
;           }
L3:
	.dbline 90
;      while((IFG1 & OFIFG) != 0);
	bit.b #2,&0x2
	jne L2
	.dbline 91
;      BCSCTL2 = 0x88;
	mov.b #136,&0x58
	.dbline -2
	.dbline 93
; //     BCSCTL2 |= SELM1 + SELS + DIVS0;   /* nun los */
;      }
L1:
	pop R4
	.dbline 0 ; func end
	ret
	.dbsym r w 4 i
	.dbend
	.dbfunc e vPortInit _vPortInit fV
	.even
_vPortInit::
	.dbline -1
	.dbline 95
; 
; void vPortInit( void ){
	.dbline 96
;      P1OUT   = 0x00;               /* Schrittmotor 1 */
	mov.b #0,&0x21
	.dbline 97
;      P1DIR   = 0x7F;
	mov.b #127,&0x22
	.dbline 98
;      P1IES   = 0x00;
	mov.b #0,&0x24
	.dbline 99
;      P1IE    = 0x00;
	mov.b #0,&0x25
	.dbline 100
;      P1SEL   = 0x00;
	mov.b #0,&0x26
	.dbline 102
; 
;      P2OUT   = 0xFF;               /* LEDs */
	mov.b #255,&0x29
	.dbline 103
;      P2DIR   = 0xFF;
	mov.b #255,&0x2a
	.dbline 104
;      P2IES   = 0x00;
	mov.b #0,&0x2c
	.dbline 105
;      P2IE    = 0x00;
	mov.b #0,&0x2d
	.dbline 106
;      P2SEL   = 0x00;
	mov.b #0,&0x2e
	.dbline 108
; 
;      P3OUT   = 0x00;               /* UART0, P3.4 output */
	mov.b #0,&0x19
	.dbline 109
;      P3DIR   = 0x10;
	mov.b #16,&0x1a
	.dbline 110
;      P3SEL   = 0x30;
	mov.b #48,&0x1b
	.dbline 112
; 
;      P4OUT   = 0xFE;               /* CFG - Port */
	mov.b #254,&0x1d
	.dbline 113
;      P4DIR   = 0x7f;
	mov.b #127,&0x1e
	.dbline 114
;      P4SEL   = 0x00;
	mov.b #0,&0x1f
	.dbline 120
; #if 0
;      P5OUT   = 0x00;               /* not used */
;      P5DIR   = 0x00;
;      P5SEL   = 0x00;
; #endif
;      P6OUT   = 0x00;               /* not used */
	mov.b #0,&0x35
	.dbline 121
;      P6DIR   = 0x00;
	mov.b #0,&0x36
	.dbline 122
;      P6SEL   = 0x03;			   /* A/D-Wandler */
	mov.b #3,&0x37
	.dbline -2
	.dbline 123
;      }
L9:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e vTimeraInit _vTimeraInit fV
	.even
_vTimeraInit::
	.dbline -1
	.dbline 126
; 
; 
; void vTimeraInit( void ){
	.dbline 127
;      TACTL = TASSEL1 + TACLR;      /* SMCLK, clear TAR */
	mov #516,&0x160
	.dbline 128
;      CCTL0 = CCIE;                 /* CCR0 interrupt enable */
	mov #16,&0x162
	.dbline 129
;      CCR0 = 20000;                 /* 2,5 ms Timer Click */
	mov #20000,&0x172
	.dbline 130
;      TACTL |= MC0;                 /* Up-Mode */
	or #16,&0x160
	.dbline -2
	.dbline 131
;      }
L10:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e vAdc12Init _vAdc12Init fV
	.even
_vAdc12Init::
	.dbline -1
	.dbline 134
; 
; 
; void vAdc12Init( void ){
	.dbline 135
; 	 ADC12CTL0  = ADC12ON + MSC + SHT0_8;
	mov #2192,&0x1a0
	.dbline 136
; 	 ADC12CTL1  = SHP + CONSEQ_3;
	mov #518,&0x1a2
	.dbline 137
; 	 ADC12MCTL0 = INCH_0;
	mov.b #0,&0x80
	.dbline 138
; 	 ADC12MCTL1 = INCH_1 + EOS;
	mov.b #129,&0x81
	.dbline 139
; 	 ADC12IE    = 0x02;
	mov #2,&0x1a6
	.dbline 140
; 	 ADC12CTL0 |= ENC;
	or #2,&0x1a0
	.dbline -2
	.dbline 149
; #if 0
;  	 ADC12CTL0  = 0x00;
;  	 ADC12CTL1  = 0xF6;//ADC12DIV.2,ADC12DIV.1,ADC12DIV.0,ADC12SSEL.1,CONSEQ.1,CONSEQ.0
;  	 ADC12IE    = 0x00;
;  	 ADC12MCTL0 = 0x00;            /* A/D-Kanal 0 */
; 	 ADC12MCTL1 = 0x01;
; 	 ADC12CTL0  = 0x12;//ADC12ON,ADC12ENC
; #endif
; 	 }
L11:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e vInitDevices _vInitDevices fV
	.even
_vInitDevices::
	.dbline -1
	.dbline 153
; 
; 
; //call this routine to initialise all peripherals
; void vInitDevices( void ){
	.dbline 154
;      DINT();                       /* disable all interrupts */
	dint
	.dbline 162
; //   ME1     = 0x00;               /* disable sfr peripherals */
; //   ME2     = 0x00;               /* disable sfr peripherals */
; //   IE1     = 0x00;               /* disable sfr interrupts */
; //   IE2     = 0x00;               /* disable sfr interrupts */
; 
; //   WDTCTL  = 0x5A | 0x15;        /* watchdog initialisation including nmi function */
; 
;      vClockInit();                 /* initialise other peripherals */
	call #_vClockInit
	.dbline 163
;      vPortInit();
	call #_vPortInit
	.dbline 164
;      vTimeraInit();
	call #_vTimeraInit
	.dbline 165
; 	 vAdc12Init();
	call #_vAdc12Init
	.dbline -2
	.dbline 172
; 
; //   ME1     = 0xC0;               /* enable sfr peripherals */
; //   ME2     = 0x00;               /* enable sfr peripherals */
; //   IE1     = 0xC0;               /* enable sfr interrupts */
; //   IE2     = 0x03;               /* disable sfr interrupts */
; //   EINT();                       /* re-enable interrupts */
;      }
L12:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e vMessage _vMessage fV
	.even
_vMessage::
	.dbline -1
	.dbline 182
; 
; 
; 
; 
; 
; /***************************************************************************
; *    Funktion: Benachrichtigungsfunktion                                   *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void vMessage( void ){
	.dbline 183
; 	 bClick = 1;     
	mov.b #1,_bClick
	.dbline -2
	.dbline 184
; 	 }
L13:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e main _main fI
;              i -> <dead>
;         iSteps -> 6(SP)
;              w -> R4
	.even
_main::
	sub #10,R1
	.dbline -1
	.dbline 193
; 
; 
; /***************************************************************************
; *    Main-Loop                                                             *
; *    - initialisiert Module und Variable                                   *
; *    - die stndig gerufenen Funktionen stehen in der Auftragsliste        *
; *
; ****************************************************************************/
; int main(void){
	.dbline 195
;      byte i;
;      word w = 0;
	mov #0,R4
	.dbline 197
;      int32 iSteps;
; 	 bClick = 0;
	mov.b #0,_bClick
	.dbline 198
; 	 vInitDevices();
	call #_vInitDevices
	.dbline 199
;      SMD_vInit();
	call #_SMD_vInit
	.dbline 200
; 	 EINT();
	eint
	.dbline 201
; 	 ADC12CTL0 |= ADC12SC;            /* A/D-Wandler starten */ 
	or #1,&0x1a0
	.dbline 202
; 	 bClick = 1;
	mov.b #1,_bClick
	jmp L16
L15:
	.dbline 203
; 	 while(1){
	.dbline 204
; 	       if(bClick == 1){
	cmp.b #1,_bClick
	jne L18
	.dbline 204
	.dbline 205
;  		        bClick = 0;
	mov.b #0,_bClick
L20:
	.dbline 206
L21:
	.dbline 206
; 				while(P6IN & 0x80);   /* Taste abfragen */ 
	bit.b #128,&0x34
	jne L20
L23:
	.dbline 207
L24:
	.dbline 207
; 				while(!(P6IN & 0x80));
	bit.b #128,&0x34
	jeq L23
	.dbline 208
; 				w = wAdc0 * 14;	   	  /* Motorgeschwindigkeit */
	push SR
	dint
	nop
	mov #14,&0x130
	mov _wAdc0,&0x138
	mov &0x13A,R4
	pop SR
	.dbline 209
; 				iSteps = (int32)wAdc1 - 0x800; /* Drehrichtung, Schrittzahl */
	mov _wAdc1,R12
	clr R13
	sub #2048,R12
	subc #0,R13
	mov R12,6(R1)
	mov R13,8(R1)
	.dbline 210
; 				SMD_vStart ( vMessage, /* Benachrichtigung */
	mov 6(R1),2(R1)
	mov 8(R1),4(R1)
	mov R4,0(R1)
	mov.b #1,R15
	mov #_vMessage,R14
	call #_SMD_vStart
	.dbline 215
;                   		   1,          /* Halbschritt */
;                   		   w,          /* Maximalgeschwindigkeit */
;                   		   iSteps      /* Schrittzahl, Vorzeichen = Drehrichtung */
;                 		   );		         
; 				}
L18:
	.dbline 216
L16:
	.dbline 203
	jmp L15
X0:
	.dbline 217
; 		   }
; 	 return 1;                     	   /* unterdrckt Compilerwarnung */
	mov #1,R14
	.dbline -2
L14:
	add #10,R1
	.dbline 0 ; func end
	ret
	.dbsym l i 9 c
	.dbsym l iSteps 6 L
	.dbsym r w 4 i
	.dbend
	.area vector(abs)
	.org 0xffec
	.word _timera_0_isr
	.area text
	.dbfile F:\hwb\ct\0405\ct03\ct03.c
	.dbfunc e timera_0_isr _timera_0_isr fV
;              w -> R4
	.even
_timera_0_isr::
	push R10
	push R11
	push R12
	push R13
	push R4
	push R14
	push R15
	.dbline -1
	.dbline 222
;      }
; 
; 
; #pragma interrupt_handler timera_0_isr:TIMERA0_VECTOR
; void timera_0_isr(void){
	.dbline 224
; 	 word w;
; 	 w = SMD_wMove();
	call #_SMD_wMove
	mov R14,r13
	mov r13,R4
	.dbline 225
;      CCR0 = w;
	mov R4,&0x172
	.dbline 226
;      P2OUT ^= 0x80;	 	  /* P2.7 toggelt im Motortakt */
	xor.b #128,&0x29
	.dbline -2
	.dbline 227
; 	 }
L26:
	pop R15
	pop R14
	pop R4
	pop R13
	pop R12
	pop R11
	pop R10
	.dbline 0 ; func end
	reti
	.dbsym r w 4 i
	.dbend
	.area vector(abs)
	.org 0xffee
	.word _adc12_isr
	.area text
	.dbfile F:\hwb\ct\0405\ct03\ct03.c
	.dbfunc e adc12_isr _adc12_isr fV
	.even
_adc12_isr::
	.dbline -1
	.dbline 230
; 
; #pragma interrupt_handler adc12_isr:ADC_VECTOR
; void adc12_isr(void){
	.dbline 231
; 	 wAdc0 = ADC12MEM0;
	mov &0x140,_wAdc0
	.dbline 232
; 	 wAdc1 = ADC12MEM1;
	mov &0x142,_wAdc1
	.dbline -2
	.dbline 233
; 	 }
L27:
	.dbline 0 ; func end
	reti
	.dbend
	.area bss
	.dbfile F:\hwb\ct\0405\ct03\ct03.c
_bJA::
	.blkb 1
	.dbsym e bJA _bJA c
	.even
_wAdc1::
	.blkb 2
	.dbsym e wAdc1 _wAdc1 i
	.even
_wAdc0::
	.blkb 2
	.dbsym e wAdc0 _wAdc0 i
_bClick::
	.blkb 1
	.dbsym e bClick _bClick c
	.area lit
	.even
	.area idata
	.even
	.area data
	.even
	.area bss
	.even
