/*  msp430x14x.h     05/24/2002
                     05/28/2002

  Copyright (C) 2002 ImageCraft Creations Inc. All rights reserved

*/

#ifndef __msp430x14x
 #define __msp430x14x

#include "msp430def.h"

/************************************************************
* STANDARD BITS
************************************************************/

#define BIT0                0x0001
#define BIT1                0x0002
#define BIT2                0x0004
#define BIT3                0x0008
#define BIT4                0x0010
#define BIT5                0x0020
#define BIT6                0x0040
#define BIT7                0x0080
#define BIT8                0x0100
#define BIT9                0x0200
#define BITA                0x0400
#define BITB                0x0800
#define BITC                0x1000
#define BITD                0x2000
#define BITE                0x4000
#define BITF                0x8000

/************************************************************
* STATUS REGISTER BITS
************************************************************/

#define C                   0x0001
#define Z                   0x0002
#define N                   0x0004
#define V                   0x0100
#define GIE                 0x0008
#define CPUOFF              0x0010
#define OSCOFF              0x0020
#define SCG0                0x0040
#define SCG1                0x0080

/* Low Power Modes coded with Bits 4-7 in SR */

#define LPM0_bits           CPUOFF
 #define LPM1_bits (SCG0+CPUOFF)
 #define LPM2_bits (SCG1+CPUOFF)
 #define LPM3_bits (SCG1+SCG0+CPUOFF)
 #define LPM4_bits (SCG1+SCG0+OSCOFF+CPUOFF)

#define LPM0      _BIS_SR(LPM0_bits) /* Enter Low Power Mode 0 */
#define LPM0_EXIT _BIC_SR(LPM0_bits) /* Exit Low Power Mode 0 */
#define LPM1      _BIS_SR(LPM1_bits) /* Enter Low Power Mode 1 */
#define LPM1_EXIT _BIC_SR(LPM1_bits) /* Exit Low Power Mode 1 */
#define LPM2      _BIS_SR(LPM2_bits) /* Enter Low Power Mode 2 */
#define LPM2_EXIT _BIC_SR(LPM2_bits) /* Exit Low Power Mode 2 */
#define LPM3      _BIS_SR(LPM3_bits) /* Enter Low Power Mode 3 */
#define LPM3_EXIT _BIC_SR(LPM3_bits) /* Exit Low Power Mode 3 */
#define LPM4      _BIS_SR(LPM4_bits) /* Enter Low Power Mode 4 */
#define LPM4_EXIT _BIC_SR(LPM4_bits) /* Exit Low Power Mode 4 */

/************************************************************
* PERIPHERAL FILE MAP
************************************************************/

/************************************************************
* SPECIAL FUNCTION REGISTER ADDRESSES + CONTROL BITS
************************************************************/

#define IE1 (*(volatile unsigned char *) 0x0000)
  /* Interrupt Enable 1 */
#define WDTIE               0x01
#define OFIE                0x02
#define NMIIE               0x10
#define ACCVIE              0x20
#define URXIE0              0x40
#define UTXIE0              0x80

#define IFG1 (*(volatile unsigned char *) 0x0002)
  /* Interrupt Flag 1 */
#define WDTIFG              0x01
#define OFIFG               0x02
#define NMIIFG              0x10
#define URXIFG0             0x40
#define UTXIFG0             0x80

#define ME1 (*(volatile unsigned char *) 0x0004)
  /* Module Enable 1 */
#define URXE0               0x40
#define USPIE0              0x40
#define UTXE0               0x80

#define IE2 (*(volatile unsigned char *) 0x0001)
  /* Interrupt Enable 2 */
#define URXIE1              0x10
#define UTXIE1              0x20

#define IFG2 (*(volatile unsigned char *) 0x0003)
  /* Interrupt Flag 2 */
#define URXIFG1             0x10
#define UTXIFG1             0x20

#define ME2 (*(volatile unsigned char *) 0x0005)
  /* Module Enable 2 */
#define URXE1               0x10
#define USPIE1              0x10
#define UTXE1               0x20

/************************************************************
* WATCHDOG TIMER
************************************************************/

#define WDTCTL (*(volatile unsigned int *) 0x0120)
  /* Watchdog Timer Control */
/* The bit names have been prefixed with "WDT" */
#define WDTIS0              0x0001
#define WDTIS1              0x0002
#define WDTSSEL             0x0004
#define WDTCNTCL            0x0008
#define WDTTMSEL            0x0010
#define WDTNMI              0x0020
#define WDTNMIES            0x0040
#define WDTHOLD             0x0080

#define WDTPW               0x5A00

/* WDT-interval times [1ms] coded with Bits 0-2 */
/* WDT is clocked by fMCLK (assumed 1MHz) */
 #define WDT_MDLY_32 (WDTPW+WDTTMSEL+WDTCNTCL) /* 32ms interval (default) */
 #define WDT_MDLY_8 (WDTPW+WDTTMSEL+WDTCNTCL+WDTIS0) /* 8ms " */
 #define WDT_MDLY_0_5 (WDTPW+WDTTMSEL+WDTCNTCL+WDTIS1) /* 0.5ms " */
 #define WDT_MDLY_0_064 (WDTPW+WDTTMSEL+WDTCNTCL+WDTIS1+WDTIS0) /* 0.064ms " */
/* WDT is clocked by fACLK (assumed 32KHz) */
 #define WDT_ADLY_1000 (WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL) /* 1000ms " */
 #define WDT_ADLY_250 (WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS0) /* 250ms " */
 #define WDT_ADLY_16 (WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS1) /* 16ms " */
 #define WDT_ADLY_1_9 (WDTPW+WDTTMSEL+WDTCNTCL+WDTSSEL+WDTIS1+WDTIS0) /* 1.9ms " */
/* Watchdog mode -> reset after expired time */
/* WDT is clocked by fMCLK (assumed 1MHz) */
 #define WDT_MRST_32 (WDTPW+WDTCNTCL) /* 32ms interval (default) */
 #define WDT_MRST_8 (WDTPW+WDTCNTCL+WDTIS0) /* 8ms " */
 #define WDT_MRST_0_5 (WDTPW+WDTCNTCL+WDTIS1) /* 0.5ms " */
 #define WDT_MRST_0_064 (WDTPW+WDTCNTCL+WDTIS1+WDTIS0) /* 0.064ms " */
/* WDT is clocked by fACLK (assumed 32KHz) */
 #define WDT_ARST_1000 (WDTPW+WDTCNTCL+WDTSSEL) /* 1000ms " */
 #define WDT_ARST_250 (WDTPW+WDTCNTCL+WDTSSEL+WDTIS0) /* 250ms " */
 #define WDT_ARST_16 (WDTPW+WDTCNTCL+WDTSSEL+WDTIS1) /* 16ms " */
 #define WDT_ARST_1_9 (WDTPW+WDTCNTCL+WDTSSEL+WDTIS1+WDTIS0) /* 1.9ms " */

/* INTERRUPT CONTROL */
/* These two bits are defined in the Special Function Registers */
/* #define WDTIE               0x01 */
/* #define WDTIFG              0x01 */

/************************************************************
* HARDWARE MULTIPLIER
************************************************************/

#define MPY (*(volatile unsigned int *) 0x0130)
  /* Multiply Unsigned/Operand 1 */
#define MPYS (*(volatile unsigned int *) 0x0132)
  /* Multiply Signed/Operand 1 */
#define MAC (*(volatile unsigned int *) 0x0134)
  /* Multiply Unsigned and Accumulate/Operand 1 */
#define MACS (*(volatile unsigned int *) 0x0136)
  /* Multiply Signed and Accumulate/Operand 1 */
#define OP2 (*(volatile unsigned int *) 0x0138)
  /* Operand 2 */
#define RESLO (*(volatile unsigned int *) 0x013A)
  /* Result Low Word */
#define RESHI (*(volatile unsigned int *) 0x013C)
  /* Result High Word */
#define SUMEXT (*(volatile  /* const  */ unsigned int *) 0x013E)
  /* Sum Extend */

/************************************************************
* DIGITAL I/O Port1/2
************************************************************/

#define P1IN (*(volatile  /* const  */ unsigned char *) 0x0020)
  /* Port 1 Input */
#define P1OUT (*(volatile unsigned char *) 0x0021)
  /* Port 1 Output */
#define P1DIR (*(volatile unsigned char *) 0x0022)
  /* Port 1 Direction */
#define P1IFG (*(volatile unsigned char *) 0x0023)
  /* Port 1 Interrupt Flag */
#define P1IES (*(volatile unsigned char *) 0x0024)
  /* Port 1 Interrupt Edge Select */
#define P1IE (*(volatile unsigned char *) 0x0025)
  /* Port 1 Interrupt Enable */
#define P1SEL (*(volatile unsigned char *) 0x0026)
  /* Port 1 Selection */

#define P2IN (*(volatile  /* const  */ unsigned char *) 0x0028)
  /* Port 2 Input */
#define P2OUT (*(volatile unsigned char *) 0x0029)
  /* Port 2 Output */
#define P2DIR (*(volatile unsigned char *) 0x002A)
  /* Port 2 Direction */
#define P2IFG (*(volatile unsigned char *) 0x002B)
  /* Port 2 Interrupt Flag */
#define P2IES (*(volatile unsigned char *) 0x002C)
  /* Port 2 Interrupt Edge Select */
#define P2IE (*(volatile unsigned char *) 0x002D)
  /* Port 2 Interrupt Enable */
#define P2SEL (*(volatile unsigned char *) 0x002E)
  /* Port 2 Selection */

/************************************************************
* DIGITAL I/O Port3/4
************************************************************/

#define P3IN (*(volatile  /* const  */ unsigned char *) 0x0018)
  /* Port 3 Input */
#define P3OUT (*(volatile unsigned char *) 0x0019)
  /* Port 3 Output */
#define P3DIR (*(volatile unsigned char *) 0x001A)
  /* Port 3 Direction */
#define P3SEL (*(volatile unsigned char *) 0x001B)
  /* Port 3 Selection */

#define P4IN (*(volatile  /* const  */ unsigned char *) 0x001C)
  /* Port 4 Input */
#define P4OUT (*(volatile unsigned char *) 0x001D)
  /* Port 4 Output */
#define P4DIR (*(volatile unsigned char *) 0x001E)
  /* Port 4 Direction */
#define P4SEL (*(volatile unsigned char *) 0x001F)
  /* Port 4 Selection */

/************************************************************
* DIGITAL I/O Port5/6
************************************************************/

#define P5IN (*(volatile  /* const  */ unsigned char *) 0x0030)
  /* Port 5 Input */
#define P5OUT (*(volatile unsigned char *) 0x0031)
  /* Port 5 Output */
#define P5DIR (*(volatile unsigned char *) 0x0032)
  /* Port 5 Direction */
#define P5SEL (*(volatile unsigned char *) 0x0033)
  /* Port 5 Selection */

#define P6IN (*(volatile  /* const  */ unsigned char *) 0x0034)
  /* Port 6 Input */
#define P6OUT (*(volatile unsigned char *) 0x0035)
  /* Port 6 Output */
#define P6DIR (*(volatile unsigned char *) 0x0036)
  /* Port 6 Direction */
#define P6SEL (*(volatile unsigned char *) 0x0037)
  /* Port 6 Selection */

/************************************************************
* USART
************************************************************/

#define PENA                0x80        /* UCTL */
#define PEV                 0x40
#define SPB                 0x20        /* to distinguish from stackpointer SP */
#define CHAR                0x10
#define LISTEN              0x08
#define SYNC                0x04
#define MM                  0x02
#define SWRST               0x01

#define CKPH                0x80        /* UTCTL */
#define CKPL                0x40
#define SSEL1               0x20
#define SSEL0               0x10
#define URXSE               0x08
#define TXWAKE              0x04
#define STC                 0x02
#define TXEPT               0x01

#define FE                  0x80        /* URCTL */
#define PE                  0x40
#define OE                  0x20
#define BRK                 0x10
#define URXEIE              0x08
#define URXWIE              0x04
#define RXWAKE              0x02
#define RXERR               0x01

/************************************************************
* USART 0
************************************************************/

#define U0CTL (*(volatile unsigned char *) 0x0070)
  /* UART 0 Control */
#define U0TCTL (*(volatile unsigned char *) 0x0071)
  /* UART 0 Transmit Control */
#define U0RCTL (*(volatile unsigned char *) 0x0072)
  /* UART 0 Receive Control */
#define U0MCTL (*(volatile unsigned char *) 0x0073)
  /* UART 0 Modulation Control */
#define U0BR0 (*(volatile unsigned char *) 0x0074)
  /* UART 0 Baud Rate 0 */
#define U0BR1 (*(volatile unsigned char *) 0x0075)
  /* UART 0 Baud Rate 1 */
#define U0RXBUF (*(volatile  /* const  */ unsigned char *) 0x0076)
  /* UART 0 Receive Buffer */
#define U0TXBUF (*(volatile unsigned char *) 0x0077)
  /* UART 0 Transmit Buffer */

/* Alternate register names */

#define UCTL0 (*(volatile unsigned char *) 0x0070)
  /* UART 0 Control */
#define UTCTL0 (*(volatile unsigned char *) 0x0071)
  /* UART 0 Transmit Control */
#define URCTL0 (*(volatile unsigned char *) 0x0072)
  /* UART 0 Receive Control */
#define UMCTL0 (*(volatile unsigned char *) 0x0073)
  /* UART 0 Modulation Control */
#define UBR00 (*(volatile unsigned char *) 0x0074)
  /* UART 0 Baud Rate 0 */
#define UBR10 (*(volatile unsigned char *) 0x0075)
  /* UART 0 Baud Rate 1 */
#define RXBUF0 (*(volatile  /* const  */ unsigned char *) 0x0076)
  /* UART 0 Receive Buffer */
#define TXBUF0 (*(volatile unsigned char *) 0x0077)
  /* UART 0 Transmit Buffer */

#define UCTL_0 (*(volatile unsigned char *) 0x0070)
  /* UART 0 Control */
#define UTCTL_0 (*(volatile unsigned char *) 0x0071)
  /* UART 0 Transmit Control */
#define URCTL_0 (*(volatile unsigned char *) 0x0072)
  /* UART 0 Receive Control */
#define UMCTL_0 (*(volatile unsigned char *) 0x0073)
  /* UART 0 Modulation Control */
#define UBR0_0 (*(volatile unsigned char *) 0x0074)
  /* UART 0 Baud Rate 0 */
#define UBR1_0 (*(volatile unsigned char *) 0x0075)
  /* UART 0 Baud Rate 1 */
#define RXBUF_0 (*(volatile  /* const  */ unsigned char *) 0x0076)
  /* UART 0 Receive Buffer */
#define TXBUF_0 (*(volatile unsigned char *) 0x0077)
  /* UART 0 Transmit Buffer */

/************************************************************
* USART 1
************************************************************/

#define U1CTL (*(volatile unsigned char *) 0x0078)
  /* UART 1 Control */
#define U1TCTL (*(volatile unsigned char *) 0x0079)
  /* UART 1 Transmit Control */
#define U1RCTL (*(volatile unsigned char *) 0x007A)
  /* UART 1 Receive Control */
#define U1MCTL (*(volatile unsigned char *) 0x007B)
  /* UART 1 Modulation Control */
#define U1BR0 (*(volatile unsigned char *) 0x007C)
  /* UART 1 Baud Rate 0 */
#define U1BR1 (*(volatile unsigned char *) 0x007D)
  /* UART 1 Baud Rate 1 */
#define U1RXBUF (*(volatile  /* const  */ unsigned char *) 0x007E)
  /* UART 1 Receive Buffer */
#define U1TXBUF (*(volatile unsigned char *) 0x007F)
  /* UART 1 Transmit Buffer */

#define UCTL1 (*(volatile unsigned char *) 0x0078)
  /* UART 1 Control */
#define UTCTL1 (*(volatile unsigned char *) 0x0079)
  /* UART 1 Transmit Control */
#define URCTL1 (*(volatile unsigned char *) 0x007A)
  /* UART 1 Receive Control */
#define UMCTL1 (*(volatile unsigned char *) 0x007B)
  /* UART 1 Modulation Control */
#define UBR01 (*(volatile unsigned char *) 0x007C)
  /* UART 1 Baud Rate 0 */
#define UBR11 (*(volatile unsigned char *) 0x007D)
  /* UART 1 Baud Rate 1 */
#define RXBUF1 (*(volatile  /* const  */ unsigned char *) 0x007E)
  /* UART 1 Receive Buffer */
#define TXBUF1 (*(volatile unsigned char *) 0x007F)
  /* UART 1 Transmit Buffer */

#define UCTL_1 (*(volatile unsigned char *) 0x0078)
  /* UART 1 Control */
#define UTCTL_1 (*(volatile unsigned char *) 0x0079)
  /* UART 1 Transmit Control */
#define URCTL_1 (*(volatile unsigned char *) 0x007A)
  /* UART 1 Receive Control */
#define UMCTL_1 (*(volatile unsigned char *) 0x007B)
  /* UART 1 Modulation Control */
#define UBR0_1 (*(volatile unsigned char *) 0x007C)
  /* UART 1 Baud Rate 0 */
#define UBR1_1 (*(volatile unsigned char *) 0x007D)
  /* UART 1 Baud Rate 1 */
#define RXBUF_1 (*(volatile  /* const  */ unsigned char *) 0x007E)
  /* UART 1 Receive Buffer */
#define TXBUF_1 (*(volatile unsigned char *) 0x007F)
  /* UART 1 Transmit Buffer */

/************************************************************
* Timer A
************************************************************/

#define TAIV (*(volatile unsigned int *) 0x012E)
  /* Timer A Interrupt Vector Word */
#define TACTL (*(volatile unsigned int *) 0x0160)
  /* Timer A Control */
#define TACCTL0 (*(volatile unsigned int *) 0x0162)
  /* Timer A Capture/Compare Control 0 */
#define TACCTL1 (*(volatile unsigned int *) 0x0164)
  /* Timer A Capture/Compare Control 1 */
#define TACCTL2 (*(volatile unsigned int *) 0x0166)
  /* Timer A Capture/Compare Control 2 */
#define TAR (*(volatile unsigned int *) 0x0170)
  /* Timer A */
#define TACCR0 (*(volatile unsigned int *) 0x0172)
  /* Timer A Capture/Compare 0 */
#define TACCR1 (*(volatile unsigned int *) 0x0174)
  /* Timer A Capture/Compare 1 */
#define TACCR2 (*(volatile unsigned int *) 0x0176)
  /* Timer A Capture/Compare 2 */

/* Alternate register names */
#define CCTL0 (*(volatile unsigned int *) 0x0162)
  /* Timer A Capture/Compare Control 0 */
#define CCTL1 (*(volatile unsigned int *) 0x0164)
  /* Timer A Capture/Compare Control 1 */
#define CCTL2 (*(volatile unsigned int *) 0x0166)
  /* Timer A Capture/Compare Control 2 */
#define CCR0 (*(volatile unsigned int *) 0x0172)
  /* Timer A Capture/Compare 0 */
#define CCR1 (*(volatile unsigned int *) 0x0174)
  /* Timer A Capture/Compare 1 */
#define CCR2 (*(volatile unsigned int *) 0x0176)
  /* Timer A Capture/Compare 2 */

#define TASSEL2             0x0400  /* unused */        /* to distinguish from UART SSELx */
#define TASSEL1             0x0200  /* Timer A clock source select 0 */
#define TASSEL0             0x0100  /* Timer A clock source select 1 */
#define ID1                 0x0080  /* Timer A clock input devider 1 */
#define ID0                 0x0040  /* Timer A clock input devider 0 */
#define MC1                 0x0020  /* Timer A mode control 1 */
#define MC0                 0x0010  /* Timer A mode control 0 */
#define TACLR               0x0004  /* Timer A counter clear */
#define TAIE                0x0002  /* Timer A counter interrupt enable */
#define TAIFG               0x0001  /* Timer A counter interrupt flag */

 #define MC_0 (0*0x10) /* Timer A mode control: 0 - Stop */
 #define MC_1 (1*0x10) /* Timer A mode control: 1 - Up to CCR0 */
 #define MC_2 (2*0x10) /* Timer A mode control: 2 - Continous up */
 #define MC_3 (3*0x10) /* Timer A mode control: 3 - Up/Down */
 #define ID_0 (0*0x40) /* Timer A input divider: 0 - /1 */
 #define ID_1 (1*0x40) /* Timer A input divider: 1 - /2 */
 #define ID_2 (2*0x40) /* Timer A input divider: 2 - /4 */
 #define ID_3 (3*0x40) /* Timer A input divider: 3 - /8 */
 #define TASSEL_0 (0*0x100) /* Timer A clock source select: 0 - TACLK */
 #define TASSEL_1 (1*0x100) /* Timer A clock source select: 1 - ACLK */
 #define TASSEL_2 (2*0x100) /* Timer A clock source select: 2 - SMCLK */
 #define TASSEL_3 (3*0x100) /* Timer A clock source select: 3 - INCLK */

#define CM1                 0x8000  /* Capture mode 1 */
#define CM0                 0x4000  /* Capture mode 0 */
#define CCIS1               0x2000  /* Capture input select 1 */
#define CCIS0               0x1000  /* Capture input select 0 */
#define SCS                 0x0800  /* Capture sychronize */
#define SCCI                0x0400  /* Latched capture signal (read) */
#define CAP                 0x0100  /* Capture mode: 1 /Compare mode : 0 */
#define OUTMOD2             0x0080  /* Output mode 2 */
#define OUTMOD1             0x0040  /* Output mode 1 */
#define OUTMOD0             0x0020  /* Output mode 0 */
#define CCIE                0x0010  /* Capture/compare interrupt enable */
#define CCI                 0x0008  /* Capture input signal (read) */
#define OUT                 0x0004  /* PWM Output signal if output mode 0 */
#define COV                 0x0002  /* Capture/compare overflow flag */
#define CCIFG               0x0001  /* Capture/compare interrupt flag */

 #define OUTMOD_0 (0*0x20) /* PWM output mode: 0 - output only */
 #define OUTMOD_1 (1*0x20) /* PWM output mode: 1 - set */
 #define OUTMOD_2 (2*0x20) /* PWM output mode: 2 - PWM toggle/reset */
 #define OUTMOD_3 (3*0x20) /* PWM output mode: 3 - PWM set/reset */
 #define OUTMOD_4 (4*0x20) /* PWM output mode: 4 - toggle */
 #define OUTMOD_5 (5*0x20) /* PWM output mode: 5 - Reset */
 #define OUTMOD_6 (6*0x20) /* PWM output mode: 6 - PWM toggle/set */
 #define OUTMOD_7 (7*0x20) /* PWM output mode: 7 - PWM reset/set */
 #define CCIS_0 (0*0x1000) /* Capture input select: 0 - CCIxA */
 #define CCIS_1 (1*0x1000) /* Capture input select: 1 - CCIxB */
 #define CCIS_2 (2*0x1000) /* Capture input select: 2 - GND */
 #define CCIS_3 (3*0x1000) /* Capture input select: 3 - Vcc */
 #define CM_0 (0*0x4000) /* Capture mode: 0 - disabled */
 #define CM_1 (1*0x4000) /* Capture mode: 1 - pos. edge */
 #define CM_2 (2*0x4000) /* Capture mode: 1 - neg. edge */
 #define CM_3 (3*0x4000) /* Capture mode: 1 - both edges */

/************************************************************
* Timer B
************************************************************/

#define TBIV (*(volatile unsigned int *) 0x011E)
  /* Timer B Interrupt Vector Word */
#define TBCTL (*(volatile unsigned int *) 0x0180)
  /* Timer B Control */
#define TBCCTL0 (*(volatile unsigned int *) 0x0182)
  /* Timer B Capture/Compare Control 0 */
#define TBCCTL1 (*(volatile unsigned int *) 0x0184)
  /* Timer B Capture/Compare Control 1 */
#define TBCCTL2 (*(volatile unsigned int *) 0x0186)
  /* Timer B Capture/Compare Control 2 */
#define TBCCTL3 (*(volatile unsigned int *) 0x0188)
  /* Timer B Capture/Compare Control 3 */
#define TBCCTL4 (*(volatile unsigned int *) 0x018A)
  /* Timer B Capture/Compare Control 4 */
#define TBCCTL5 (*(volatile unsigned int *) 0x018C)
  /* Timer B Capture/Compare Control 5 */
#define TBCCTL6 (*(volatile unsigned int *) 0x018E)
  /* Timer B Capture/Compare Control 6 */
#define TBR (*(volatile unsigned int *) 0x0190)
  /* Timer B */
#define TBCCR0 (*(volatile unsigned int *) 0x0192)
  /* Timer B Capture/Compare 0 */
#define TBCCR1 (*(volatile unsigned int *) 0x0194)
  /* Timer B Capture/Compare 1 */
#define TBCCR2 (*(volatile unsigned int *) 0x0196)
  /* Timer B Capture/Compare 2 */
#define TBCCR3 (*(volatile unsigned int *) 0x0198)
  /* Timer B Capture/Compare 3 */
#define TBCCR4 (*(volatile unsigned int *) 0x019A)
  /* Timer B Capture/Compare 4 */
#define TBCCR5 (*(volatile unsigned int *) 0x019C)
  /* Timer B Capture/Compare 5 */
#define TBCCR6 (*(volatile unsigned int *) 0x019E)
  /* Timer B Capture/Compare 6 */

#define SHR1                0x4000  /* Timer B Compare latch load group 1 */
#define SHR0                0x2000  /* Timer B Compare latch load group 0 */
#define TBCLGRP1            0x4000  /* Timer B Compare latch load group 1 */
#define TBCLGRP0            0x2000  /* Timer B Compare latch load group 0 */
#define CNTL1               0x1000  /* Counter lenght 1 */
#define CNTL0               0x0800  /* Counter lenght 0 */
#define TBSSEL2             0x0400  /* unused */
#define TBSSEL1             0x0200  /* Clock source 1 */
#define TBSSEL0             0x0100  /* Clock source 0 */
#define TBCLR               0x0004  /* Timer B counter clear */
#define TBIE                0x0002  /* Timer B interrupt enable */
#define TBIFG               0x0001  /* Timer B interrupt flag */

 #define TBSSEL_0 (0*0x0100) /* Clock Source: TBCLK */
 #define TBSSEL_1 (1*0x0100) /* Clock Source: ACLK */
 #define TBSSEL_2 (2*0x0100) /* Clock Source: SMCLK */
 #define TBSSEL_3 (3*0x0100) /* Clock Source: INCLK */
 #define CNTL_0 (0*0x0800) /* Counter lenght: 16 bit */
 #define CNTL_1 (1*0x0800) /* Counter lenght: 12 bit */
 #define CNTL_2 (2*0x0800) /* Counter lenght: 10 bit */
 #define CNTL_3 (3*0x0800) /* Counter lenght: 8 bit */
 #define SHR_0 (0*0x2000) /* Timer B Group: 0 - individually */
 #define SHR_1 (1*0x2000) /* Timer B Group: 1 - 3 groups (1-2, 3-4, 5-6) */
 #define SHR_2 (2*0x2000) /* Timer B Group: 2 - 2 groups (1-3, 4-6)*/
 #define SHR_3 (3*0x2000) /* Timer B Group: 3 - 1 group (all) */
 #define TBCLGRP_0 (0*0x2000) /* Timer B Group: 0 - individually */
 #define TBCLGRP_1 (1*0x2000) /* Timer B Group: 1 - 3 groups (1-2, 3-4, 5-6) */
 #define TBCLGRP_2 (2*0x2000) /* Timer B Group: 2 - 2 groups (1-3, 4-6)*/
 #define TBCLGRP_3 (3*0x2000) /* Timer B Group: 3 - 1 group (all) */

/* Additional Timer B Control Register bits are defined in Timer A */

#define SLSHR1              0x0400  /* Compare latch load source 1 */
#define SLSHR0              0x0200  /* Compare latch load source 0 */
#define CLLD1               0x0400  /* Compare latch load source 1 */
#define CLLD0               0x0200  /* Compare latch load source 0 */

 #define SLSHR_0 (0*0x0200) /* Compare latch load sourec : 0 - immediate */
 #define SLSHR_1 (1*0x0200) /* Compare latch load sourec : 1 - TBR counts to 0 */
 #define SLSHR_2 (2*0x0200) /* Compare latch load sourec : 2 - up/down */
 #define SLSHR_3 (3*0x0200) /* Compare latch load sourec : 3 - TBR counts to TBCTL0 */

 #define CLLD_0 (0*0x0200) /* Compare latch load sourec : 0 - immediate */
 #define CLLD_1 (1*0x0200) /* Compare latch load sourec : 1 - TBR counts to 0 */
 #define CLLD_2 (2*0x0200) /* Compare latch load sourec : 2 - up/down */
 #define CLLD_3 (3*0x0200) /* Compare latch load sourec : 3 - TBR counts to TBCTL0 */
/************************************************************
* Basic Clock Module
************************************************************/

#define DCOCTL (*(volatile unsigned char *) 0x0056)
  /* DCO Clock Frequency Control */
#define BCSCTL1 (*(volatile unsigned char *) 0x0057)
  /* Basic Clock System Control 1 */
#define BCSCTL2 (*(volatile unsigned char *) 0x0058)
  /* Basic Clock System Control 2 */

#define MOD0                0x01   /* Modulation Bit 0 */
#define MOD1                0x02   /* Modulation Bit 1 */
#define MOD2                0x04   /* Modulation Bit 2 */
#define MOD3                0x08   /* Modulation Bit 3 */
#define MOD4                0x10   /* Modulation Bit 4 */
#define DCO0                0x20   /* DCO Select Bit 0 */
#define DCO1                0x40   /* DCO Select Bit 1 */
#define DCO2                0x80   /* DCO Select Bit 2 */

#define RSEL0               0x01   /* Resistor Select Bit 0 */
#define RSEL1               0x02   /* Resistor Select Bit 1 */
#define RSEL2               0x04   /* Resistor Select Bit 2 */
#define XT5V                0x08   /* XT5V should always be reset */
#define DIVA0               0x10   /* ACLK Divider 0 */
#define DIVA1               0x20   /* ACLK Divider 1 */
#define XTS                 0x40   /* LFXTCLK 0:Low Freq. / 1: High Freq. */
#define XT2OFF              0x80   /* Enable XT2CLK */

#define DIVA_0              0x00   /* ACLK Divider 0: /1 */
#define DIVA_1              0x10   /* ACLK Divider 1: /2 */
#define DIVA_2              0x20   /* ACLK Divider 2: /4 */
#define DIVA_3              0x30   /* ACLK Divider 3: /8 */

#define DCOR                0x01   /* Enable External Resistor : 1 */
#define DIVS0               0x02   /* SMCLK Divider 0 */
#define DIVS1               0x04   /* SMCLK Divider 1 */
#define SELS                0x08   /* MCLK Source Select 0:DCOCLK / 1:XT2CLK/LFXTCLK */
#define DIVM0               0x10   /* MCLK Divider 0 */
#define DIVM1               0x20   /* MCLK Divider 1 */
#define SELM0               0x40   /* SMCLK Source Select 0 */
#define SELM1               0x80   /* SMCLK Source Select 1 */

#define DIVS_0              0x00   /* SMCLK Divider 0: /1 */
#define DIVS_1              0x02   /* SMCLK Divider 1: /2 */
#define DIVS_2              0x04   /* SMCLK Divider 2: /4 */
#define DIVS_3              0x06   /* SMCLK Divider 3: /8 */

#define DIVM_0              0x00   /* MCLK Divider 0: /1 */
#define DIVM_1              0x10   /* MCLK Divider 1: /2 */
#define DIVM_2              0x20   /* MCLK Divider 2: /4 */
#define DIVM_3              0x30   /* MCLK Divider 3: /8 */

#define SELM_0              0x00   /* SMCLK Source Select 0: DCOCLK */
#define SELM_1              0x40   /* SMCLK Source Select 1: DCOCLK */
#define SELM_2              0x80   /* SMCLK Source Select 2: XT2CLK/LFXTCLK */
#define SELM_3              0xC0   /* SMCLK Source Select 3: LFXTCLK */

/*************************************************************
* Flash Memory
*************************************************************/

#define FCTL1 (*(volatile unsigned int *) 0x0128)
  /* FLASH Control 1 */
#define FCTL2 (*(volatile unsigned int *) 0x012A)
  /* FLASH Control 2 */
#define FCTL3 (*(volatile unsigned int *) 0x012C)
  /* FLASH Control 3 */

#define FRKEY               0x9600  /* Flash key returned by read */
#define FWKEY               0xA500  /* Flash key for write */
#define FXKEY               0x3300  /* for use with XOR instruction */

#define ERASE               0x0002  /* Enable bit for Flash segment erase */
#define MERAS               0x0004  /* Enable bit for Flash mass erase */
#define WRT                 0x0040  /* Enable bit for Flash write */
#define BLKWRT              0x0080  /* Enable bit for Flash segment write */
#define SEGWRT              0x0080  /* old definition */ /* Enable bit for Flash segment write */

#define FN0                 0x0001  /* Devide Flash clock by: 2^0 */
#define FN1                 0x0002  /* Devide Flash clock by: 2^1 */
#define FN2                 0x0004  /* Devide Flash clock by: 2^2 */
#define FN3                 0x0008  /* Devide Flash clock by: 2^3 */
#define FN4                 0x0010  /* Devide Flash clock by: 2^4 */
#define FN5                 0x0020  /* Devide Flash clock by: 2^5 */
#define FSSEL0              0x0040  /* Flash clock select 0 */        /* to distinguish from UART SSELx */
#define FSSEL1              0x0080  /* Flash clock select 1 */

#define FSSEL_0             0x0000  /* Flash clock select: 0 - ACLK */
#define FSSEL_1             0x0040  /* Flash clock select: 1 - MCLK */
#define FSSEL_2             0x0080  /* Flash clock select: 2 - SMCLK */
#define FSSEL_3             0x00C0  /* Flash clock select: 3 - SMCLK */

#define BUSY                0x0001  /* Flash busy: 1 */
#define KEYV                0x0002  /* Flash Key violation flag */
#define ACCVIFG             0x0004  /* Flash Access violation flag */
#define WAIT                0x0008  /* Wait flag for segment write */
#define LOCK                0x0010  /* Lock bit: 1 - Flash is locked (read only) */
#define EMEX                0x0020  /* Flash Emergency Exit */

/************************************************************
* Comparator A
************************************************************/

#define CACTL1 (*(volatile unsigned char *) 0x0059)
  /* Comparator A Control 1 */
#define CACTL2 (*(volatile unsigned char *) 0x005A)
  /* Comparator A Control 2 */
#define CAPD (*(volatile unsigned char *) 0x005B)
  /* Comparator A Port Disable */

#define CAIFG               0x01    /* Comp. A Interrupt Flag */
#define CAIE                0x02    /* Comp. A Interrupt Enable */
#define CAIES               0x04    /* Comp. A Int. Edge Select: 0:rising / 1:falling */
#define CAON                0x08    /* Comp. A enable */
#define CAREF0              0x10    /* Comp. A Internal Reference Select 0 */
#define CAREF1              0x20    /* Comp. A Internal Reference Select 1 */
#define CARSEL              0x40    /* Comp. A Internal Reference Enable */
#define CAEX                0x80    /* Comp. A Exchange Inputs */

#define CAREF_0             0x00    /* Comp. A Int. Ref. Select 0 : Off */
#define CAREF_1             0x10    /* Comp. A Int. Ref. Select 1 : 0.25*Vcc */
#define CAREF_2             0x20    /* Comp. A Int. Ref. Select 2 : 0.5*Vcc */
#define CAREF_3             0x30    /* Comp. A Int. Ref. Select 3 : Vt*/

#define CAOUT               0x01    /* Comp. A Output */
#define CAF                 0x02    /* Comp. A Enable Output Filter */
#define P2CA0               0x04    /* Comp. A Connect External Signal to CA0 : 1 */
#define P2CA1               0x08    /* Comp. A Connect External Signal to CA1 : 1 */
#define CACTL24             0x10
#define CACTL25             0x20
#define CACTL26             0x40
#define CACTL27             0x80

#define CAPD0               0x01    /* Comp. A Disable Input Buffer of Port Register .0 */
#define CAPD1               0x02    /* Comp. A Disable Input Buffer of Port Register .1 */
#define CAPD2               0x04    /* Comp. A Disable Input Buffer of Port Register .2 */
#define CAPD3               0x08    /* Comp. A Disable Input Buffer of Port Register .3 */
#define CAPD4               0x10    /* Comp. A Disable Input Buffer of Port Register .4 */
#define CAPD5               0x20    /* Comp. A Disable Input Buffer of Port Register .5 */
#define CAPD6               0x40    /* Comp. A Disable Input Buffer of Port Register .6 */
#define CAPD7               0x80    /* Comp. A Disable Input Buffer of Port Register .7 */

/************************************************************
* ADC12
************************************************************/

#define ADC12CTL0 (*(volatile unsigned int *) 0x01A0)
  /* ADC12 Control 0 */
#define ADC12CTL1 (*(volatile unsigned int *) 0x01A2)
  /* ADC12 Control 1 */
#define ADC12IFG (*(volatile unsigned int *) 0x01A4)
  /* ADC12 Interrupt Flag */
#define ADC12IE (*(volatile unsigned int *) 0x01A6)
  /* ADC12 Interrupt Enable */
#define ADC12IV (*(volatile unsigned int *) 0x01A8)
  /* ADC12 Interrupt Vector Word */

#define ADC12MEM_           0x0140  /* ADC12 Conversion Memory */
#define ADC12MEM            ((int*) ADC12MEM_) /* ADC12 Conversion Memory */

#define ADC12MEM0 (*(volatile unsigned int *) ADC12MEM_)
  /* ADC12 Conversion Memory 0 */
#define ADC12MEM1 (*(volatile unsigned int *) 0x0142)
  /* ADC12 Conversion Memory 1 */
#define ADC12MEM2 (*(volatile unsigned int *) 0x0144)
  /* ADC12 Conversion Memory 2 */
#define ADC12MEM3 (*(volatile unsigned int *) 0x0146)
  /* ADC12 Conversion Memory 3 */
#define ADC12MEM4 (*(volatile unsigned int *) 0x0148)
  /* ADC12 Conversion Memory 4 */
#define ADC12MEM5 (*(volatile unsigned int *) 0x014A)
  /* ADC12 Conversion Memory 5 */
#define ADC12MEM6 (*(volatile unsigned int *) 0x014C)
  /* ADC12 Conversion Memory 6 */
#define ADC12MEM7 (*(volatile unsigned int *) 0x014E)
  /* ADC12 Conversion Memory 7 */
#define ADC12MEM8 (*(volatile unsigned int *) 0x0150)
  /* ADC12 Conversion Memory 8 */
#define ADC12MEM9 (*(volatile unsigned int *) 0x0152)
  /* ADC12 Conversion Memory 9 */
#define ADC12MEM10 (*(volatile unsigned int *) 0x0154)
  /* ADC12 Conversion Memory 10 */
#define ADC12MEM11 (*(volatile unsigned int *) 0x0156)
  /* ADC12 Conversion Memory 11 */
#define ADC12MEM12 (*(volatile unsigned int *) 0x0158)
  /* ADC12 Conversion Memory 12 */
#define ADC12MEM13 (*(volatile unsigned int *) 0x015A)
  /* ADC12 Conversion Memory 13 */
#define ADC12MEM14 (*(volatile unsigned int *) 0x015C)
  /* ADC12 Conversion Memory 14 */
#define ADC12MEM15 (*(volatile unsigned int *) 0x015E)
  /* ADC12 Conversion Memory 15 */

#define ADC12MCTL_          0x0080  /* ADC12 Memory Control */
#define ADC12MCTL           ((char*) ADC12MCTL_) /* ADC12 Memory Control */

#define ADC12MCTL0 (*(volatile unsigned char *) ADC12MCTL_)
  /* ADC12 Memory Control 0 */
#define ADC12MCTL1 (*(volatile unsigned char *) 0x0081)
  /* ADC12 Memory Control 1 */
#define ADC12MCTL2 (*(volatile unsigned char *) 0x0082)
  /* ADC12 Memory Control 2 */
#define ADC12MCTL3 (*(volatile unsigned char *) 0x0083)
  /* ADC12 Memory Control 3 */
#define ADC12MCTL4 (*(volatile unsigned char *) 0x0084)
  /* ADC12 Memory Control 4 */
#define ADC12MCTL5 (*(volatile unsigned char *) 0x0085)
  /* ADC12 Memory Control 5 */
#define ADC12MCTL6 (*(volatile unsigned char *) 0x0086)
  /* ADC12 Memory Control 6 */
#define ADC12MCTL7 (*(volatile unsigned char *) 0x0087)
  /* ADC12 Memory Control 7 */
#define ADC12MCTL8 (*(volatile unsigned char *) 0x0088)
  /* ADC12 Memory Control 8 */
#define ADC12MCTL9 (*(volatile unsigned char *) 0x0089)
  /* ADC12 Memory Control 9 */
#define ADC12MCTL10 (*(volatile unsigned char *) 0x008A)
  /* ADC12 Memory Control 10 */
#define ADC12MCTL11 (*(volatile unsigned char *) 0x008B)
  /* ADC12 Memory Control 11 */
#define ADC12MCTL12 (*(volatile unsigned char *) 0x008C)
  /* ADC12 Memory Control 12 */
#define ADC12MCTL13 (*(volatile unsigned char *) 0x008D)
  /* ADC12 Memory Control 13 */
#define ADC12MCTL14 (*(volatile unsigned char *) 0x008E)
  /* ADC12 Memory Control 14 */
#define ADC12MCTL15 (*(volatile unsigned char *) 0x008F)
  /* ADC12 Memory Control 15 */

#define ADC12SC             0x001 /* ADC12CTL0 */
#define ENC                 0x002
#define ADC12TOVIE          0x004
#define ADC12OVIE           0x008
#define ADC12ON             0x010
#define REFON               0x020
#define REF2_5V             0x040
#define MSH                 0x080
#define MSC                 0x080

 #define SHT0_0 (0*0x100)
 #define SHT0_1 (1*0x100)
 #define SHT0_2 (2*0x100)
 #define SHT0_3 (3*0x100)
 #define SHT0_4 (4*0x100)
 #define SHT0_5 (5*0x100)
 #define SHT0_6 (6*0x100)
 #define SHT0_7 (7*0x100)
 #define SHT0_8 (8*0x100)
 #define SHT0_9 (9*0x100)
 #define SHT0_10 (10*0x100)
 #define SHT0_11 (11*0x100)
 #define SHT0_12 (12*0x100)
 #define SHT0_13 (13*0x100)
 #define SHT0_14 (14*0x100)
 #define SHT0_15 (15*0x100)

 #define SHT1_0 (0*0x1000)
 #define SHT1_1 (1*0x1000)
 #define SHT1_2 (2*0x1000)
 #define SHT1_3 (3*0x1000)
 #define SHT1_4 (4*0x1000)
 #define SHT1_5 (5*0x1000)
 #define SHT1_6 (6*0x1000)
 #define SHT1_7 (7*0x1000)
 #define SHT1_8 (8*0x1000)
 #define SHT1_9 (9*0x1000)
 #define SHT1_10 (10*0x1000)
 #define SHT1_11 (11*0x1000)
 #define SHT1_12 (12*0x1000)
 #define SHT1_13 (13*0x1000)
 #define SHT1_14 (14*0x1000)
 #define SHT1_15 (15*0x1000)

#define ADC12BUSY           0x0001 /* ADC12CTL1 */
 #define CONSEQ_0 (0*2)
 #define CONSEQ_1 (1*2)
 #define CONSEQ_2 (2*2)
 #define CONSEQ_3 (3*2)
 #define ADC12SSEL_0 (0*8)
 #define ADC12SSEL_1 (1*8)
 #define ADC12SSEL_2 (2*8)
 #define ADC12SSEL_3 (3*8)
 #define ADC12DIV_0 (0*0x20)
 #define ADC12DIV_1 (1*0x20)
 #define ADC12DIV_2 (2*0x20)
 #define ADC12DIV_3 (3*0x20)
 #define ADC12DIV_4 (4*0x20)
 #define ADC12DIV_5 (5*0x20)
 #define ADC12DIV_6 (6*0x20)
 #define ADC12DIV_7 (7*0x20)
#define ISSH                0x0100
#define SHP                 0x0200
 #define SHS_0 (0*0x400)
 #define SHS_1 (1*0x400)
 #define SHS_2 (2*0x400)
 #define SHS_3 (3*0x400)

 #define CSTARTADD_0 (0*0x1000)
 #define CSTARTADD_1 (1*0x1000)
 #define CSTARTADD_2 (2*0x1000)
 #define CSTARTADD_3 (3*0x1000)
 #define CSTARTADD_4 (4*0x1000)
 #define CSTARTADD_5 (5*0x1000)
 #define CSTARTADD_6 (6*0x1000)
 #define CSTARTADD_7 (7*0x1000)
 #define CSTARTADD_8 (8*0x1000)
 #define CSTARTADD_9 (9*0x1000)
 #define CSTARTADD_10 (10*0x1000)
 #define CSTARTADD_11 (11*0x1000)
 #define CSTARTADD_12 (12*0x1000)
 #define CSTARTADD_13 (13*0x1000)
 #define CSTARTADD_14 (14*0x1000)
 #define CSTARTADD_15 (15*0x1000)

#define INCH_0               0 /* ADC12CTLx */
#define INCH_1               1
#define INCH_2               2
#define INCH_3               3
#define INCH_4               4
#define INCH_5               5
#define INCH_6               6
#define INCH_7               7
#define INCH_8               8
#define INCH_9               9
#define INCH_10             10
#define INCH_11             11
#define INCH_12             12
#define INCH_13             13
#define INCH_14             14
#define INCH_15             15

 #define SREF_0 (0*0x10)
 #define SREF_1 (1*0x10)
 #define SREF_2 (2*0x10)
 #define SREF_3 (3*0x10)
 #define SREF_4 (4*0x10)
 #define SREF_5 (5*0x10)
 #define SREF_6 (6*0x10)
 #define SREF_7 (7*0x10)
#define EOS                 0x80

/* ADC10
 */
#define ADC10CTL0 (*(volatile unsigned int *) 0x01B0)
  /* ADC10 Control 0 */
#define ADC10CTL1 (*(volatile unsigned int *) 0x01B2)
  /* ADC10 Control 1 */
#define ADC10MEM0 (*(volatile unsigned int *) 0x01B4)
  /* ADC10 Conversion Memory 0 */

#define ADC10SA   (*(volatile unsigned int *) 0x01BC)

#define ADC10AE   (*(volatile unsigned char *) 0x4A)
#define ADC10DTC1 (*(volatile unsigned char *) 0x49)
#define ADC10DTC0 (*(volatile unsigned char *) 0x80)

/* ADC10CTL1 */
#define ADC10INCH_3 bit(15)
#define ADC10INCH_2 bit(14)
#define ADC10INCH_1 bit(13)
#define ADC10INCH_0 bit(12)
#define ADC10SHS_1  bit(11)
#define ADC10SHS_0  bit(10)
#define ADC10DF     bit(9)
#define ADC10ISSH   bit(8)
#define ADC10DIV_2  bit(7)
#define ADC10DIV_1  bit(6)
#define ADC10DIV_0  bit(5)
#define ADC10SSEL_1 bit(4)
#define ADC10SSEL_0 bit(3)
#define ADC10CONSEQ_1 bit(2)
#define ADC10CONSEQ_0 bit(1)
#define ADC10BUSY   bit(0)

/* ADC10CTL0 */
#define ADC10Sref_2 bit(15)
#define ADC10Sref_1 bit(14)
#define ADC10Sref_0 bit(13)
#define ADC10SHT_1  bit(12)
#define ADC10SHT_0  bit(11)
#define ADC10SR     bit(10)
#define REF_Out     bit(9)
#define REFBurst    bit(8)
#define ADC10MSC    bit(7)
#define ADC10ON     bit(4)
#define ADC10IE     bit(3)
#define ADC10IFG    bit(2)
#define ADC10ENC    bit(1)
#define ADC10SC     bit(0)

#define ADC10AE_7   bit(7)
#define ADC10AE_6   bit(6)
#define ADC10AE_5   bit(5)
#define ADC10AE_4   bit(4)
#define ADC10AE_3   bit(3)
#define ADC10AE_2   bit(2)
#define ADC10AE_1   bit(1)
#define ADC10AE_0   bit(0)

#define ADC10TB     bit(3)
#define ADC10CT     bit(2)
#define ADC10B1     bit(1)
#define ADC10FETCH  bit(0)
/* END ADC10 */

/************************************************************
* Interrupt Vectors (offset from 0xFFE0)
************************************************************/

#define PORT2_VECTOR        2   /* 0xFFE2 Port 2 */
#define UART1TX_VECTOR      4   /* 0xFFE4 UART 1 Transmit */
#define UART1RX_VECTOR      6   /* 0xFFE6 UART 1 Receive */
#define PORT1_VECTOR        8   /* 0xFFE8 Port 1 */
#define TIMERA1_VECTOR      10   /* 0xFFEA Timer A CC1-2, TA */
#define TIMERA0_VECTOR      12   /* 0xFFEC Timer A CC0 */
#define ADC_VECTOR          14   /* 0xFFEE ADC */
#define UART0TX_VECTOR      16   /* 0xFFF0 UART 0 Transmit */
#define UART0RX_VECTOR      18   /* 0xFFF2 UART 0 Receive */
#define WDT_VECTOR          20  /* 0xFFF4 Watchdog Timer */
#define COMPARATORA_VECTOR  22  /* 0xFFF6 Comparator A */
#define TIMERB1_VECTOR      24  /* 0xFFF8 Timer B 1-7 */
#define TIMERB0_VECTOR      26  /* 0xFFFA Timer B 0 */
#define NMI_VECTOR          28  /* 0xFFFC Non-maskable */
#define RESET_VECTOR        30  /* 0xFFFE Reset [Highest Priority] */

/************************************************************
* End of Modules
************************************************************/

#endif /* #ifndef __msp430x14x */

