Attribute VB_Name = "OL_Datenabgleich"
Option Explicit

' 2004, Ralf Nebelo

Public Const APPNAME As String = "Outlook-Datenabgleich"

'*******************************************************************************
'Makros
'*******************************************************************************

Public Sub OLDA_TempBarEinrichten()
    Dim objCB As CommandBar
    Dim objButton As CommandBarButton
    
    On Error Resume Next
    
    'Temporre Befehlsleiste anlegen
    Set objCB = ActiveExplorer.CommandBars.Add(APPNAME, msoBarBottom, , True)
    'Makrostart-Button hinzufgen
    Set objButton = objCB.Controls.Add(msoControlButton)
    'Button konfigurieren
    With objButton
        .Style = msoButtonIconAndCaption
        .BeginGroup = True
        .Caption = "Einstellungen"
        .TooltipText = "Einstellungen fr " & APPNAME
        .FaceId = 470
        'Mit Makro verknpfen
        .OnAction = "OLDA_Optionen"
    End With
    
    'Makrostart-Button hinzufgen
    Set objButton = objCB.Controls.Add(msoControlButton)
    'Button konfigurieren
    With objButton
        .Style = msoButtonIconAndCaption
        .BeginGroup = True
        .Caption = "Datenabgleich"
        .TooltipText = APPNAME & " durchfhren"
        .FaceId = 455
        'Mit Makro verknpfen
        .OnAction = "OLDA_DatenAbgleichen"
    End With
    
    'Befehlsleiste sichtbar machen
    objCB.Visible = True
End Sub

Public Sub OLDA_Optionen()
    'Userform frmDatenabgleichOptionen aufrufen
    frmDatenabgleichOptionen.Show
End Sub

Public Sub OLDA_DatenAbgleichen()
    'Userform frmDatenabgleich aufrufen
    frmDatenabgleich.Show
End Sub

'*******************************************************************************
'Allgemeine Prozeduren
'*******************************************************************************

Public Function OrdnerVorhanden(strPath As String) As Boolean
    Dim intAttribute As Integer
    
    'Fehlerverfolgung aus
    On Error Resume Next

    'Attribute von strPath auslesen
    intAttribute = GetAttr(strPath)
    'Wenn strPath ein Ordner ist (und kein Fehler auftritt), dann...
    If intAttribute And vbDirectory = vbDirectory Then
        '... gilt Existenz und Bereitschaft als bewiesen
        OrdnerVorhanden = True
    End If
End Function

Public Function OrdnerAnlegen(strPath As String) As Boolean
    'Fehlerverfolgung aus
    On Error Resume Next
    
    'Ordner anlegen
    MkDir strPath
    'Wenn kein Fehler auftritt, dann...
    If Err = 0 Then
        '... Erfolg zurckmelden
        OrdnerAnlegen = True
    End If
End Function

Public Function AddSlash(strPath As String) As String
    'Wenn Pfad nicht mit Backslash-Zeichen endet, dann...
    If Right(strPath, 1) <> "\" Then
        '... selbiges anhngen
        AddSlash = strPath & "\"
    End If
End Function

