VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmDatenabgleichOptionen 
   Caption         =   "frmDatenabgleichOptionen"
   ClientHeight    =   5610
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   5145
   OleObjectBlob   =   "frmDatenabgleichOptionen.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmDatenabgleichOptionen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2004, Ralf Nebelo

Private Sub UserForm_Initialize()
    Dim intI As Integer
    Dim strGewhlteOLOrdner
    Dim intAnzEintrge As Integer
    Dim strEintrag() As String
    
    'Titeltext des Dialogfenster festlegen
    Me.Caption = OL_Datenabgleich.APPNAME & " - Optionen"
    
    'Name des Basisordners aus Registry lesen und in txtOrdner anzeigen
    txtOrdner.Text = GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "BasisOrdner", "")
    
    'Listenfeld konfigurieren
    With lstOLOrdner
        'Drei Spalten einrichten
        .ColumnCount = 3
        'Mittlere Spalte ist unsichtbar
        .ColumnWidths = "-1;0;-1"
        
        'Anzahl der Abgleichzuordnungen aus Registry lesen
        intAnzEintrge = CInt(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "Eintrge", "0"))
        'Alle Zuordnungen durchlaufen
        For intI = 0 To intAnzEintrge - 1
            'Nummerierte Zuordnung aus Registry lesen
            strEintrag() = Split(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", Format(intI + 1, "00")), ",")
            'Name des Outlook-Ornders in erste Spalte bernehmen
            .AddItem strEintrag(0)
            'Entry-ID des Outlook-Ordners in mittlere Spalte bernehmen
            .List(.ListCount - 1, 1) = strEintrag(1)
            'Name des Abgleichdateiordners in rechte Spalte bernehmen
            .List(.ListCount - 1, 2) = strEintrag(2)
        Next
    End With
    
    'Status des Kontrollkstchens chkAlter aus Registry lesen
    chkAlter.Value = CBool(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "CheckAlter", "Wahr"))
    'Inhalt des Textfeld txtAlter aus Registry lesen
    txtAlter.Text = GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "Alter", "2")
    Call chkAlter_Click
    
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub txtOrdner_Change()
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub cmdOrdner_Click()
    Dim strOrdner As String
    Dim vntOLOrdner As Variant
    Dim intI As Integer
    Dim strUnterordner As String
    
    'Gewnschten Basisdateiordner im Dialog abfragen
    strOrdner = ctlDialoge.GetFolder("Bitte whlen Sie das freigegebene Basisverzeichnis. Es wird automatisch mit Unterverzeichnissen fr den Abgleich mit Outlook-Ordnern ausgestattet:", "Desktop", txtOrdner.Text, True)
    'Wenn Ordner angegeben, dann...
    If strOrdner > "" Then
        '... dessen Name in txtOrdner anzeigen
        txtOrdner.Text = strOrdner
        
        'Array mit Namen von abgleichfhigen Outlook-Ordnern definieren
        vntOLOrdner = Array("Aufgaben", "Entwrfe", "Gesendete Objekte", "Journal", "Kalender", "Kontakte", "Postausgang", "Posteingang")
        'Alle Array-Elemente durchlaufen
        For intI = LBound(vntOLOrdner) To UBound(vntOLOrdner)
            'Ordnerpfad aus Pfad des Basisordners und Element-Inhalts zusammensetzen
            strUnterordner = OL_Datenabgleich.AddSlash(strOrdner) & vntOLOrdner(intI)
            'Wenn Unterordner nicht existiert und...
            If OL_Datenabgleich.OrdnerVorhanden(strUnterordner) = False Then
                '... sich auch nicht anlegen lt, dann...
                If OL_Datenabgleich.OrdnerAnlegen(strUnterordner) = False Then
                    '... Fehlermeldung ausgeben
                    MsgBox "Fehler beim Anlegen der Ordnerstruktur.", vbCritical, OL_Datenabgleich.APPNAME
                    With txtOrdner
                        'Inhalt von txtOrder leeren
                        .Text = ""
                        'Fokus auf Control setzen
                        .SetFocus
                    End With
                    
                    'Prozedur verlassen
                    Exit Sub
                End If
            End If
        Next
    End If
End Sub

Private Sub lstOLOrdner_Click()
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub lstOLOrdner_DblClick(ByVal Cancel As MSForms.ReturnBoolean)
    'Anklicken der cmdEdit-Schaltflche simulieren
    Call cmdEdit_Click
End Sub

Private Sub cmdNeu_Click()
    'Userform frmDatenabgleichOrdner konfigurieren
    With frmDatenabgleichOrdner
        'Fenstertiteltext festlegen
        .Caption = OL_Datenabgleich.APPNAME & " - Hinzufgen"
        'Keine Vorgabe fr Outlook-Ordnernamen
        .txtOLOrdner.Text = ""
        'Keine Entry-ID zur Identifikation des Outlook-Ordners
        .strEntryID = ""
        'Keine Vorgabe fr Dateiordnernamen
        .txtOrdner.Text = ""
        'Pfad des Basisordners bergeben
        .strBasisOrdner = txtOrdner.Text
        'Userform anzeigen
        .Show
        
        'Wenn strEntryID vorliegt, der User also einen gltigen
        'Outlook-Ordner gewhlt hat, dann...
        If .strEntryID <> "" Then
            '... Outlook-Ordner in linke Listenfeldspalte aufnehmen
            lstOLOrdner.AddItem .txtOLOrdner.Text
            'Entry-ID in mittlere Spalte bernehmen
            lstOLOrdner.List(lstOLOrdner.ListCount - 1, 1) = .strEntryID
            'Abgleichdateiordner in rechte Spalte bernehmen
            lstOLOrdner.List(lstOLOrdner.ListCount - 1, 2) = .txtOrdner.Text
        End If
    End With
    'Userform entladen
    Unload frmDatenabgleichOrdner
    
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub cmdEdit_Click()
    'Userform frmDatenabgleichOrdner konfigurieren
    With frmDatenabgleichOrdner
        'Fenstertiteltext festlegen
        .Caption = OL_Datenabgleich.APPNAME & " - Bearbeiten"
        'Aktuellen Outlook-Ordner in txtOLOrdner eintragen
        .txtOLOrdner.Text = lstOLOrdner.List(lstOLOrdner.ListIndex, 0)
        'Entry-ID des Outlook-Ordners in strEntryID-Variable eintragen
        .strEntryID = lstOLOrdner.List(lstOLOrdner.ListIndex, 1)
        'Aktuellen Abgleichordner in txtOrdner eintragen
        .txtOrdner.Text = lstOLOrdner.List(lstOLOrdner.ListIndex, 2)
        'Pfad des Basisordners bergeben
        .strBasisOrdner = txtOrdner.Text
        'Userform anzeigen
        .Show
        
        'Wenn strEntryID vorliegt, der User also einen gltigen
        'Outlook-Ordner gewhlt hat, dann...
        If .strEntryID <> "" Then
            '... Outlook-Ordner in linke Listenfeldspalte aufnehmen
            lstOLOrdner.List(lstOLOrdner.ListIndex, 0) = .txtOLOrdner.Text
            'Entry-ID in mittlere Spalte bernehmen
            lstOLOrdner.List(lstOLOrdner.ListIndex, 1) = .strEntryID
            'Abgleichdateiordner in rechte Spalte bernehmen
            lstOLOrdner.List(lstOLOrdner.ListIndex, 2) = .txtOrdner.Text
        End If
    End With
    'Userform entladen
    Unload frmDatenabgleichOrdner
End Sub

Private Sub cmdLschen_Click()
    'Aktuellen Listenfeldeintrag lschen
    With lstOLOrdner
        .RemoveItem .ListIndex
    End With
    
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub chkAlter_Click()
    'Schaltflche txtAlter je nach Status des Kontrollkstchens
    '(de-)aktivieren
    txtAlter.Enabled = CBool(chkAlter.Value)
End Sub

Private Sub txtAlter_Change()
    'Nur numerische Eingaben akzeptieren
    txtAlter.Text = CStr(Val(txtAlter.Text))
End Sub

Private Sub cmdOK_Click()
    Dim intI As Integer
    Dim strTmp As String
    
    'Pfad des Basisordners in Registry sichern
    SaveSetting OL_Datenabgleich.APPNAME, "Einstellungen", "BasisOrdner", txtOrdner.Text
    
    With lstOLOrdner
        'Anzahl der Zuordnungen in Registry sichern
        SaveSetting OL_Datenabgleich.APPNAME, "Einstellungen", "Eintrge", CStr(.ListCount)
        'Alle Listenfeldelemente durchlaufen
        For intI = 0 To .ListCount - 1
            'Spalteninhalte zu kommaseparierter Liste zusammenfassen und...
            strTmp = .List(intI, 0) & "," & .List(intI, 1) & "," & .List(intI, 2)
            '... diese als nummerierten Wert in Registry speichern
            SaveSetting OL_Datenabgleich.APPNAME, "Einstellungen", Format(intI + 1, "00"), strTmp
        Next
    End With
    
    'Status des Kontrollkstchens chkAlter in Registry sichern
    SaveSetting OL_Datenabgleich.APPNAME, "Einstellungen", "CheckAlter", chkAlter.Value
    'Inhalt des Textfelds txtAlter in Registry sichern
    SaveSetting OL_Datenabgleich.APPNAME, "Einstellungen", "Alter", txtAlter.Text
    
    'Userform entladen
    Unload Me
End Sub

Private Sub cmdCancel_Click()
    'Userform entladen
    Unload Me
End Sub

Private Sub ButtonStatus()
    'cmdOK-Schaltflche nur aktivieren, wenn Basisordner angegeben
    'und Listenfeld mindestens eine Abgleichzuordnung enthlt
    cmdOK.Enabled = txtOrdner.Text > "" And lstOLOrdner.ListCount > 0
    With lstOLOrdner
        'Listenfeld nur aktivieren, wenn Basisordner angegeben
        .Enabled = txtOrdner.Text > ""
        'Wenn Listenfeld nicht aktiviert, dann ggf. vorhandene
        'Elementmarkierung aufheben
        If .Enabled = False Then
            .ListIndex = -1
        End If
    End With
    'cmdNeu auch nur aktivieren, wenn Basisordner angegeben
    cmdNeu.Enabled = txtOrdner.Text > ""
    
    'cmdEdit nur aktivieren, wenn Listenfeldelement markiert
    cmdEdit.Enabled = lstOLOrdner.ListIndex > -1
    'cmdLschen nur aktivieren, wenn Listenfeldelement markiert
    cmdLschen.Enabled = lstOLOrdner.ListIndex > -1
End Sub
