<?php
include('adodb/adodb.inc.php');
include('global.inc.php');
$conn = &ADONewConnection(DBTYPE);
$conn->Connect(DBHOST, DBUSER, DBPASS, DBNAME);
$conn->SetFetchMode(ADODB_FETCH_ASSOC);
$data = array(
   'title'   => 'Alle MP3-Titel',
   'version' => strftime("%d.%m.%Y")
);
$sql = "
   SELECT
      albums.album   album,
      artists.artist artist,
      albums.id      album_id,
      artists.id     artist_id
   FROM
      albums,
      artists,
      titles
   WHERE
      albums.id = titles.album_id
      AND artists.id = titles.artist_id
   GROUP BY
      artist,
      album
   ORDER BY
      artist,
      album";
$res = $conn->Execute($sql);
$i = 0;
while (!$res->EOF)
{
   $data['albums'][$i] =
      array(
         'artist'    => $res->fields['artist'],
         'album'     => $res->fields['album'],
         'artist_id' => $res->fields['artist_id'],
         'album_id'  => $res->fields['album_id']
      );
   $res->MoveNext();
   $i++;
}
foreach($data['albums'] as $i => $album)
{
   $sql = sprintf(
      "SELECT
         titles.no           position,
         titles.title        track,
         titles.bitrate      bitrate,
         titles.file_name    filename,
         titles.file_size    filesize,
         titles.playing_time playingtime,
         titles.id           id
      FROM titles
      WHERE
         titles.album_id = %d
         AND titles.artist_id = %d
      ORDER BY
         titles.no",
      $album['album_id'],
      $album['artist_id']);
   $res = $conn->Execute($sql);
   $j = 0;
   while (!$res->EOF)
   {
      $data['albums'][$i]['tracks'][$j] =
         array(
            'position' => $res->fields['position'],
            'track'    => $res->fields['track'],
            'bitrate'  => $res->fields['bitrate'],
            'filename' => $res->fields['filename'],
            'id'       => $res->fields['id'],
            'filesize' => number_format ($res->fields['filesize'] / 1024, 1, ',', '.'),
            'class'    => ($j % 2)? 'colored' : 'transparent'
         );
      $res->MoveNext();
      $j++;
   }
}
$res->Close();
$conn->Close();
$tpl = tmpl_open("titlelist.tmpl");
tmpl_set($tpl, $data);
echo tmpl_parse($tpl);
tmpl_close($tpl);
?>
