CREATE DATABASE IF NOT EXISTS music;
GRANT ALL ON music.* TO music@localhost IDENTIFIED BY 'music';

DROP TABLE IF EXISTS mp3;
CREATE TABLE mp3 (
   id INT NOT NULL AUTO_INCREMENT,
   album_name VARCHAR(30) NOT NULL DEFAULT '',
   artist VARCHAR(30) NOT NULL DEFAULT '',
   published INT, -- Jahr
   genre_id INT NOT NULL DEFAULT 0 REFERENCES genres(id),
   stereo VARCHAR(12) NOT NULL DEFAULT '',
   track_no INT,
   track_title VARCHAR(30) NOT NULL DEFAULT '',
   playing_time INT, -- seconds
   sample_freq INT, -- Hz
   bitrate INT, -- Kbit/s
   mpeg_layer VARCHAR(3),
   file_size INT, -- KByte
   file_name TEXT, -- incl. relativem Pfad ab $MP3PATH
   PRIMARY KEY (id),
   INDEX album_artist (album_name, artist)
);

DROP TABLE IF EXISTS albums;
CREATE TABLE albums (
   id INT NOT NULL AUTO_INCREMENT,
   album VARCHAR(30) NOT NULL DEFAULT '',
   published INT(4), -- Jahr
   PRIMARY KEY (id),
   INDEX (published),
   INDEX (album)
);

DROP TABLE IF EXISTS artists;
CREATE TABLE artists (
   id INT NOT NULL AUTO_INCREMENT,
   artist VARCHAR(30) NOT NULL DEFAULT '',
   PRIMARY KEY (id),
   UNIQUE KEY (artist)
);

DROP TABLE IF EXISTS titles;
CREATE TABLE titles (
   id INT NOT NULL AUTO_INCREMENT,
   album_id INT NOT NULL REFERENCES albums(id),
   artist_id INT NOT NULL REFERENCES artists(id),
   genre_id INT NOT NULL DEFAULT 0 REFERENCES genres(id),
   stereo VARCHAR(30) NOT NULL DEFAULT '',
   no INT NOT NULL DEFAULT -1,
   title VARCHAR(30) NOT NULL DEFAULT '',
   playing_time INT, -- Sekunden
   sample_freq INT NOT NULL DEFAULT -1,
   bitrate INT NOT NULL DEFAULT -1,
   mpeg_layer VARCHAR(3) NOT NULL DEFAULT '',
   file_size INT NOT NULL DEFAULT -1,
   file_name TEXT,
   PRIMARY KEY (id),
   INDEX (title),
   INDEX (album_id, artist_id),
   INDEX (album_id),
   INDEX (artist_id),
   INDEX (genre_id)
);

DROP TABLE IF EXISTS genres;
CREATE TABLE genres (
   id INT NOT NULL,
   genre VARCHAR(30) NOT NULL,
   PRIMARY KEY (id),
   UNIQUE KEY (genre)
);

INSERT INTO genres VALUES (0, 'Blues');
INSERT INTO genres VALUES (1, 'Classic Rock');
INSERT INTO genres VALUES (10, 'New Age');
INSERT INTO genres VALUES (100, 'Humour');
INSERT INTO genres VALUES (101, 'Speech');
INSERT INTO genres VALUES (102, 'Chanson');
INSERT INTO genres VALUES (103, 'Opera');
INSERT INTO genres VALUES (104, 'Chamber Music');
INSERT INTO genres VALUES (105, 'Sonata');
INSERT INTO genres VALUES (106, 'Symphony');
INSERT INTO genres VALUES (107, 'Booty Bass');
INSERT INTO genres VALUES (108, 'Primus');
INSERT INTO genres VALUES (109, 'Porn Groove');
INSERT INTO genres VALUES (11, 'Oldies');
INSERT INTO genres VALUES (110, 'Satire');
INSERT INTO genres VALUES (111, 'Slow Jam');
INSERT INTO genres VALUES (112, 'Club');
INSERT INTO genres VALUES (113, 'Tango');
INSERT INTO genres VALUES (114, 'Samba');
INSERT INTO genres VALUES (115, 'Folklore');
INSERT INTO genres VALUES (116, 'Ballad');
INSERT INTO genres VALUES (117, 'Power Ballad');
INSERT INTO genres VALUES (118, 'Rhythmic Soul');
INSERT INTO genres VALUES (119, 'Freestyle');
INSERT INTO genres VALUES (12, 'Other');
INSERT INTO genres VALUES (120, 'Duet');
INSERT INTO genres VALUES (121, 'Punk Rock');
INSERT INTO genres VALUES (122, 'Drum Solo');
INSERT INTO genres VALUES (123, 'A Cappella');
INSERT INTO genres VALUES (124, 'Euro-House');
INSERT INTO genres VALUES (125, 'Dance Hall');
INSERT INTO genres VALUES (126, 'Goa');
INSERT INTO genres VALUES (127, 'Drum & Bass');
INSERT INTO genres VALUES (128, 'Club-House');
INSERT INTO genres VALUES (129, 'Hardcore');
INSERT INTO genres VALUES (13, 'Pop');
INSERT INTO genres VALUES (130, 'Terror');
INSERT INTO genres VALUES (131, 'Indie');
INSERT INTO genres VALUES (132, 'BritPop');
INSERT INTO genres VALUES (133, 'Negerpunk');
INSERT INTO genres VALUES (134, 'Polsk Punk');
INSERT INTO genres VALUES (135, 'Beat');
INSERT INTO genres VALUES (136, 'Christian Gangsta Rap');
INSERT INTO genres VALUES (137, 'Heavy Metal');
INSERT INTO genres VALUES (138, 'Black Metal');
INSERT INTO genres VALUES (139, 'Crossover');
INSERT INTO genres VALUES (14, 'R&B');
INSERT INTO genres VALUES (140, 'Contemporary Christian');
INSERT INTO genres VALUES (141, 'Christian Rock');
INSERT INTO genres VALUES (142, 'Merengue');
INSERT INTO genres VALUES (143, 'Salsa');
INSERT INTO genres VALUES (144, 'Thrash Metal');
INSERT INTO genres VALUES (145, 'Anime');
INSERT INTO genres VALUES (146, 'JPop');
INSERT INTO genres VALUES (147, 'Synthpop');
INSERT INTO genres VALUES (15, 'Rap');
INSERT INTO genres VALUES (16, 'Reggae');
INSERT INTO genres VALUES (17, 'Rock');
INSERT INTO genres VALUES (18, 'Techno');
INSERT INTO genres VALUES (19, 'Industrial');
INSERT INTO genres VALUES (2, 'Country');
INSERT INTO genres VALUES (20, 'Alternative');
INSERT INTO genres VALUES (21, 'Ska');
INSERT INTO genres VALUES (22, 'Death Metal');
INSERT INTO genres VALUES (23, 'Pranks');
INSERT INTO genres VALUES (24, 'Soundtrack');
INSERT INTO genres VALUES (25, 'Euro-Techno');
INSERT INTO genres VALUES (26, 'Ambient');
INSERT INTO genres VALUES (27, 'Trip-Hop');
INSERT INTO genres VALUES (28, 'Vocal');
INSERT INTO genres VALUES (29, 'Jazz+Funk');
INSERT INTO genres VALUES (3, 'Dance');
INSERT INTO genres VALUES (30, 'Fusion');
INSERT INTO genres VALUES (31, 'Trance');
INSERT INTO genres VALUES (32, 'Classical');
INSERT INTO genres VALUES (33, 'Instrumental');
INSERT INTO genres VALUES (34, 'Acid');
INSERT INTO genres VALUES (35, 'House');
INSERT INTO genres VALUES (36, 'Game');
INSERT INTO genres VALUES (37, 'Sound Clip');
INSERT INTO genres VALUES (38, 'Gospel');
INSERT INTO genres VALUES (39, 'Noise');
INSERT INTO genres VALUES (4, 'Disco');
INSERT INTO genres VALUES (40, 'Alt. Rock');
INSERT INTO genres VALUES (41, 'Bass');
INSERT INTO genres VALUES (42, 'Soul');
INSERT INTO genres VALUES (43, 'Punk');
INSERT INTO genres VALUES (44, 'Space');
INSERT INTO genres VALUES (45, 'Meditative');
INSERT INTO genres VALUES (46, 'Instrumental Pop');
INSERT INTO genres VALUES (47, 'Instrumental Rock');
INSERT INTO genres VALUES (48, 'Ethnic');
INSERT INTO genres VALUES (49, 'Gothic');
INSERT INTO genres VALUES (5, 'Funk');
INSERT INTO genres VALUES (50, 'Darkwave');
INSERT INTO genres VALUES (51, 'Techno-Industrial');
INSERT INTO genres VALUES (52, 'Electronic');
INSERT INTO genres VALUES (53, 'Pop-Folk');
INSERT INTO genres VALUES (54, 'Eurodance');
INSERT INTO genres VALUES (55, 'Dream');
INSERT INTO genres VALUES (56, 'Southern Rock');
INSERT INTO genres VALUES (57, 'Comedy');
INSERT INTO genres VALUES (58, 'Cult');
INSERT INTO genres VALUES (59, 'Gangsta Rap');
INSERT INTO genres VALUES (6, 'Grunge');
INSERT INTO genres VALUES (60, 'Top 40');
INSERT INTO genres VALUES (61, 'Christian Rap');
INSERT INTO genres VALUES (62, 'Pop/Funk');
INSERT INTO genres VALUES (63, 'Jungle');
INSERT INTO genres VALUES (64, 'Native American');
INSERT INTO genres VALUES (65, 'Cabaret');
INSERT INTO genres VALUES (66, 'New Wave');
INSERT INTO genres VALUES (67, 'Psychedelic');
INSERT INTO genres VALUES (68, 'Rave');
INSERT INTO genres VALUES (69, 'Showtunes');
INSERT INTO genres VALUES (7, 'Hip-Hop');
INSERT INTO genres VALUES (70, 'Trailer');
INSERT INTO genres VALUES (71, 'Lo-Fi');
INSERT INTO genres VALUES (72, 'Tribal');
INSERT INTO genres VALUES (73, 'Acid Punk');
INSERT INTO genres VALUES (74, 'Acid Jazz');
INSERT INTO genres VALUES (75, 'Polka');
INSERT INTO genres VALUES (76, 'Retro');
INSERT INTO genres VALUES (77, 'Musical');
INSERT INTO genres VALUES (78, 'Rock & Roll');
INSERT INTO genres VALUES (79, 'Hard Rock');
INSERT INTO genres VALUES (8, 'Jazz');
INSERT INTO genres VALUES (80, 'Folk');
INSERT INTO genres VALUES (81, 'Folk/Rock');
INSERT INTO genres VALUES (82, 'National Folk');
INSERT INTO genres VALUES (83, 'Swing');
INSERT INTO genres VALUES (84, 'Fast-Fusion');
INSERT INTO genres VALUES (85, 'Bebob');
INSERT INTO genres VALUES (86, 'Latin');
INSERT INTO genres VALUES (87, 'Revival');
INSERT INTO genres VALUES (88, 'Celtic');
INSERT INTO genres VALUES (89, 'Bluegrass');
INSERT INTO genres VALUES (9, 'Metal');
INSERT INTO genres VALUES (90, 'Avantgarde');
INSERT INTO genres VALUES (91, 'Gothic Rock');
INSERT INTO genres VALUES (92, 'Progressive Rock');
INSERT INTO genres VALUES (93, 'Psychedelic Rock');
INSERT INTO genres VALUES (94, 'Symphonic Rock');
INSERT INTO genres VALUES (95, 'Slow Rock');
INSERT INTO genres VALUES (96, 'Big Band');
INSERT INTO genres VALUES (97, 'Chorus');
INSERT INTO genres VALUES (98, 'Easy Listening');
INSERT INTO genres VALUES (99, 'Acoustic');

DROP TABLE IF EXISTS playlists;
CREATE TABLE playlists (
   id INT NOT NULL AUTO_INCREMENT,
   name VARCHAR(200) NOT NULL DEFAULT '',
   PRIMARY KEY (id),
   UNIQUE ID (name)
);

INSERT INTO playlists VALUES (1, 'Genervt');
INSERT INTO playlists VALUES (2, 'Entspannt');

DROP TABLE IF EXISTS playlist_titles;
CREATE TABLE playlist_titles (
   id INT NOT NULL AUTO_INCREMENT,
   title_id INT NOT NULL REFERENCES titles(id),
   PRIMARY KEY (id)
);

