INSERT INTO albums (album, published) 
   SELECT album_name, published 
   FROM mp3 
   GROUP BY album_name, artist;

INSERT INTO artists (artist) 
   SELECT artist 
   FROM mp3 
   GROUP BY artist;

INSERT INTO titles (album_id, artist_id, genre_id, stereo, no, title, playing_time, sample_freq, bitrate, mpeg_layer, file_size, file_name)
   SELECT
      albums.id, 
      artists.id, 
      mp3.genre_id, 
      mp3.stereo, 
      mp3.track_no, 
      mp3.track_title, 
      mp3.playing_time, 
      mp3.sample_freq, 
      mp3.bitrate, 
      mp3.mpeg_layer, 
      mp3.file_size, 
      mp3.file_name 
   FROM 
      albums, 
      artists, 
      mp3
   WHERE 
      albums.album = mp3.album_name 
      AND artists.artist = mp3.artist;
