//------------------------------------------------------------------------------
//
// Copyright (C) 2004 Gehriger Engineering.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//------------------------------------------------------------------------------
#ifndef MSIEXTRACT_H
#define MSIEXTRACT_H
#ifdef _MSC_VER
#pragma once
#endif

// header includes
#include <list>
#include <map>
#include <utility>
#include <algorithm>
#include <iostream>
#include <assert.h>
#include <tchar.h>
#include "stuff.h"
#include "tstring.h"
#include "smrthandle.h"
#include "CabExtract.h"

// smart handles
typedef SmrtHandle<MSIHANDLE, UINT, MsiCloseHandle> SmrtMsiHandle;
typedef SmrtHandle<HANDLE, BOOL, CloseHandle>       SmrtFileHandle;

// list of files to extract (empty list means extract everything)
typedef std::list<tstring> FileList;

// list of stored files and containing cab
typedef std::map<tstring, tstring> StoredFiles;

// obtain list of stored MSI files
void                    getStoredFiles(MSIHANDLE db, StoredFiles& storedFiles);

// extract stored file
void                    extractStoredFile(MSIHANDLE db, const TCHAR* file, const TCHAR* cab);

// callback called during cabinet extraction
bool __stdcall          extractCallback(void* pv, bool extracted, LPCTSTR entry, size_t size);

// print the usage message
void                    printUsage();

// parse the command line
bool                    parseCommandLine(int argc, _TCHAR* argv[], FileList& fileList, tstring& msiFile);

// load text resource by resource-ID and return pointer to text buffer
LPCSTR                  loadTextResource(WORD resourceId);

// Return string record field
tstring                 recordGetString(MSIHANDLE record, UINT col);


#endif // MSIEXTRACT_H
