// CoCsDLL.h : Declaration of the CCoCsDLL

#ifndef __COCSDLL_H_
#define __COCSDLL_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CCoCsDLL
class ATL_NO_VTABLE CCoCsDLL : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CCoCsDLL, &CLSID_CoCsDLL>,
	public ISupportErrorInfo,
	public IDispatchImpl<ICoCsDLLDisp, &IID_ICoCsDLLDisp, &LIBID_CS_DLLLib>
{
private:
	CComBSTR m_StrVal;
	long m_IntVal;

public:
	CCoCsDLL()
	{
		m_StrVal= BSTR(""); 
	}

DECLARE_REGISTRY_RESOURCEID(IDR_COCSDLL)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CCoCsDLL)
	COM_INTERFACE_ENTRY(ICoCsDLLDisp)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ICoCsDLLDisp
public:
	STDMETHOD(get_ProcessID)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_StrProp)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_IntProp)(/*[out, retval]*/ long *pVal);
	STDMETHOD(StrParam)(/*[in]*/ BSTR s);
	STDMETHOD(IntParam)(/*[in]*/ long i);
	STDMETHOD(NoParam)();

};

#endif //__COCSDLL_H_
