/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: led.c 
 * Info: Routinen zur LED-Steuerung
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include <avr/delay.h>
#include "led.h"

#include "delay.h"

void LED_on(char LED){
	PORTD &= ~LED;
}

void LED_off(char LED){
	PORTD |= LED;	// LED ausschalten
}

void lauflicht(char runs){		// Achtung Endlosschleife!!!!
	LED_off(LED_ALL);
	int i=0;
	while (i<runs){
		LED_on(LED_ROT);
		delay_100ms();
		LED_off(LED_ROT);
		
		LED_on(LED_ORANGE);
		delay_100ms();
		LED_off(LED_ORANGE);
		
		LED_on(LED_GELB);
		delay_100ms();
		LED_off(LED_GELB);
		
		LED_on(LED_GRUEN);
		delay_100ms();
		LED_off(LED_GRUEN);
		i++;
	}
}

char switch_LED(char LED){
	
	if ((LED & 0x01) == 1) {
		LED_on(LED_GRUEN);
		//new_value=1;
	}else {
		LED_off(LED_GRUEN);
	}
	
	if ((LED & 0x02) ==2) {
		LED_on(LED_GELB);
		//new_value+=2;
	} else {
		LED_off(LED_GELB);
	}
	
	if ((LED & 0x04) == 4) {
		LED_on(LED_ORANGE);
		//new_value+=4;
	} else {
		LED_off(LED_ORANGE);
	}
	
	if ((LED & 0x08) == 8) {
		LED_on(LED_ROT);
		//new_value+=8;
	} else {
		LED_off(LED_ROT);
	}
	
	return LED;
}
	
