VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmVerteilerAusOrdner 
   Caption         =   "frmVerteilerAusOrdner"
   ClientHeight    =   6060
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6450
   OleObjectBlob   =   "frmVerteilerAusOrdner.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmVerteilerAusOrdner"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Nur fr Outlook 2003 (wg. exkl. SenderEmailAddress-Eigenschaft)
' 2004, Ralf Nebelo

Private Sub UserForm_Initialize()
    Dim objOrdner As MAPIFolder
    Dim objElement As Object

    'Fehlerverfolgung ausschalten
    On Error Resume Next

    'Aktuellen Ordner ermitteln
    Set objOrdner = ActiveExplorer.CurrentFolder
    'Wenn Ordner kein E-Mail-Ordner ist, dann...
    If objOrdner.DefaultItemType <> olMailItem Then
        '... Fehlermeldung ausgeben und...
        MsgBox "Bitte markieren Sie einen Nachrichtenordner.", vbInformation, OL_VerteilerAusOrdner.APPNAME
        '... Dialog beenden
        End
    End If

    'Kombinationsfeld konfigurieren
    With cmbVerteiler
        '2 Spalten
        .ColumnCount = 2
        'Zweite Spalte unsichtbar
        .ColumnWidths = "1;0"
        'Eintrag fr neuen Verteiler
        .AddItem "<Neuer Verteiler>"
        
        'Alle Elemente des Kontakte-Ordner durchlaufen
        For Each objElement In GetNamespace("MAPI").GetDefaultFolder(olFolderContacts).Items
            'Wenn Element eine Verteilerliste ist, dann...
            If TypeName(objElement) = "DistListItem" Then
                '... deren Anzeigenamen in erste Spalte des
                'Kombinationsfelds aufnehmen
                .AddItem objElement.DLName
                'Entry-ID des Elements in unsichtbare Spalte
                'des Kombinationsfelds aufnehmen
                .List(.ListCount - 1, 1) = objElement.EntryID
            End If
        Next
        
        'Erstes Listenelement vorwhlen
        .ListIndex = 0
    End With
    
    'lblPrompt2-Beschriftung festlegen
    lblPrompt2.Caption = "Folgende E-Mail-Adressen aus Ordner " & ActiveExplorer.CurrentFolder.Name & " bernehmen:"
    
    'Listenfeld konfigurieren
    With lstListenfeld
        'Elemente mit Auswahl-Checkbox anzeigen
        .ListStyle = fmListStyleOption
        'Mehrere Elemente whlbar
        .MultiSelect = fmMultiSelectMulti
    End With
    
    'Prozedur zum Einlesen der E-Mail-Adressen aufrufen
    Call MailAdressenEinlesen(objOrdner)
End Sub

Private Sub lstListenfeld_Change()
    Dim intI As Integer
    Dim intZhler As Integer

    With lstListenfeld
        'Alle Listenelemente durchlaufen
        For intI = 0 To .ListCount - 1
            'Wenn Element ausgewhlt ist, dann...
            If .Selected(intI) = True Then
                '... Zhler erhhen
                intZhler = intZhler + 1
            End If
        Next
    End With
    
    'Wenn mindestens ein Element gewhlt, dann OK-Schaltflche
    'aktivieren, ansonsten deaktivieren
    cmdOK.Enabled = intZhler > 0
    'Anzahl der ausgewhlten Elemente in Titelleiste anzeigen
    Me.Caption = OL_VerteilerAusOrdner.APPNAME & " (" & CStr(intZhler) & " ausgewhlt)"
End Sub

Private Sub cmdAlle_Click()
    Dim intI As Integer
    
    With lstListenfeld
        'Alle Listenelemente durchlaufen und...
        For intI = 0 To .ListCount - 1
            '... der Reihe nach auswhlen
            .Selected(intI) = True
        Next
    End With
End Sub

Private Sub cmdKeine_Click()
    Dim intI As Integer
    
    With lstListenfeld
        'Alle Listenelemente durchlaufen und...
        For intI = 0 To .ListCount - 1
            '... der Reihe nach abwhlen
            .Selected(intI) = False
        Next
    End With
End Sub

Private Sub cmdOK_Click()
    Dim objVerteiler As DistListItem
    Dim strVerteilerName As String
    Dim objTempMail As MailItem
    Dim intI As Integer
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf gewhlten Verteiler holen
    Set objVerteiler = GetNamespace("MAPI").GetItemFromID(cmbVerteiler.List(cmbVerteiler.ListIndex, 1))
    'Wenn Verteiler nicht existiert ("<Neuer Verteiler>" gewhlt), dann...
    If objVerteiler Is Nothing Then
        '... Verteilernamen abfragen
        strVerteilerName = InputBox("Name des neuen Verteilers:", OL_VerteilerAusOrdner.APPNAME, "Verteiler " & ActiveExplorer.CurrentFolder.Name)
        'Wenn kein Name eingegeben (oder Abbrechen gewhlt), dann...
        If strVerteilerName = "" Then
            '... Prozedur verlassen
            Exit Sub
        'Wenn Verteilername eingegeben, dann...
        Else
            '... Verweis auf mglicherweise vorhandenen, namensgleichen
            'Verteiler holen
            Set objVerteiler = GetNamespace("MAPI").GetDefaultFolder(olFolderContacts).Items(strVerteilerName)
            'Wenn namensgleicher Verteiler vorhanden, dann...
            If Not objVerteiler Is Nothing Then
                'Wenn Anwender Erlaubnis zum Lschen gibt, dann...
                If MsgBox("Der Verteiler " & strVerteilerName & " existiert bereits. Lschen?", vbYesNoCancel + vbDefaultButton2, OL_VerteilerAusOrdner.APPNAME) = vbYes Then
                    '... vorhandenen Verteiler lschen
                    objVerteiler.Delete
                'Wenn keine Lscherlaubnis, dann...
                Else
                    '... Prozedur verlassen
                    Exit Sub
                End If
            End If
            
            'Neuen Verteiler anlegen
            Set objVerteiler = CreateItem(olDistributionListItem)
            'Abgefragtem (Anzeige-) Namen zuweisen
            objVerteiler.DLName = strVerteilerName
        End If
    End If
    
    'Temporre Nachricht anlegen
    Set objTempMail = CreateItem(olMailItem)
    'Alle Listenelemente durchlaufen
    For intI = 0 To lstListenfeld.ListCount - 1
        'Wenn Element gewhlt ist, dann...
        If lstListenfeld.Selected(intI) = True Then
            '... der temporren Nachricht als Empfnger hinzufgen
            objTempMail.Recipients.Add lstListenfeld.List(intI)
        End If
    Next

    'Userform entladen
    Unload Me

    With objVerteiler
        'Empfnger der temporren Nachricht der Verteilerliste hinzufgen
        .AddMembers objTempMail.Recipients
        'Verteilerliste anzeigen
        .Display
    End With
    
    'Temporre Nachricht lschen
    objTempMail.Delete
End Sub

Private Sub cmdCancel_Click()
    'Userform entladen
    Unload Me
End Sub

'*******************************************************************
'Dienstroutinen
'*******************************************************************

Private Sub MailAdressenEinlesen(objOrdner As MAPIFolder)
    Dim objNachricht As MailItem
    Dim strEintrag As String
    Dim strTmp As String
    Dim vntAdressArray As Variant
    Dim intI As Integer

    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Alle Nachrichten im bergebenen Ordner durchlaufen
    For Each objNachricht In objOrdner.Items
        'Wenn Absendername vorhanden, dann...
        If objNachricht.SenderName > "" Then
            'Wenn Absendername gleich E-Mail-Adresse, dann...
            If LCase(objNachricht.SenderName) = LCase(objNachricht.SenderEmailAddress) Then
                '... E-Mail-Adresse als Listeneintrag whlen
                strEintrag = objNachricht.SenderEmailAddress
            'Wenn Absendername nicht gleich E-Mail-Adresse, dann...
            Else
                '... Klammeraffe in Absendername durch "at" ersetzen
                strEintrag = Replace(objNachricht.SenderName, "@", "at")
                'Listeneintrag aus Absendername und in Klammern
                'gesetzte E-Mail-Adresse zusammensetzen
                strEintrag = strEintrag & " (" & objNachricht.SenderEmailAddress & ")"
            End If
            
            'Wenn Listeneintrag noch nicht in strTmp enthalten, dann...
            If InStr(LCase(strTmp), LCase(strEintrag)) = 0 Then
                '... Listeneintrag mit Semikolon dahinter an
                'strTmp anhngen
                strTmp = strTmp & strEintrag & ";"
            End If
        End If
    Next
    
    'Letztes Semikolon aus strTmp entfernen
    If Right(strTmp, 1) = ";" Then
        strTmp = Left(strTmp, Len(strTmp) - 1)
    End If
    
    'strTmp in Array berfhren
    vntAdressArray = Split(strTmp, ";")
    'Array sortieren
    Call QuickSort(vntAdressArray)
    
    'Listenfeld konfigurieren
    With lstListenfeld
        'Alle Elemente lschen
        .Clear
        'Array durchlaufen
        For intI = LBound(vntAdressArray) To UBound(vntAdressArray)
            'Array-Element in Listenfeld bernehmen
            .AddItem vntAdressArray(intI)
            'Neues Listenelement markieren
            .Selected(.ListCount - 1) = True
        Next

        'Erstes Listenelement vorwhlen
        .ListIndex = 0
    End With
End Sub

Private Sub QuickSort(vntArray As Variant, Optional intVon As Integer = -1, Optional intBis As Integer = -1)
    Dim i As Integer
    Dim j As Integer
    Dim vntTestWert As Variant
    Dim intMitte As Integer
    Dim vntTemp As Variant

    If intVon = -1 Then intVon = LBound(vntArray)
    If intBis = -1 Then intBis = UBound(vntArray)
   
    If intVon < intBis Then
        'Mittleres Element des Sortierabschnitts bestimmen und...
        intMitte = (intVon + intBis) \ 2
        '... seinen Wert in vntTestWert speichern
        vntTestWert = LCase(vntArray(intMitte))
        i = intVon
        j = intBis
        Do
            'Links von der Mitte nach Element suchen,
            'das nicht kleiner ist als vntTestWert
            Do While LCase(vntArray(i)) < vntTestWert
                i = i + 1
            Loop
            'Rechts von der Mitte nach Element suchen,
            'das nicht grer ist als vntTestWert
            Do While LCase(vntArray(j)) > vntTestWert
                j = j - 1
            Loop
            'Wenn der Index des nicht kleineren Elements
            'auf der linken Seite kleiner oder gleich dem Index
            'des nicht greren Elements auf der rechten Seite ist,
            'dann...
            If i <= j Then
                '... Elemente tauschen
                vntTemp = vntArray(j)
                vntArray(j) = vntArray(i)
                vntArray(i) = vntTemp
                i = i + 1
                j = j - 1
            End If
        'Schleife wiederholen bis i grer ist als j
        Loop Until i > j
        'Rekursive Selbstaufrufe zum Sortieren der brigen Abschnitte.
        'Mit kleinerem Abschnitt beginnen (spart Ressourcen).
        If j <= intMitte Then
            Call QuickSort(vntArray, intVon, j)
            Call QuickSort(vntArray, i, intBis)
        Else
            Call QuickSort(vntArray, i, intBis)
            Call QuickSort(vntArray, intVon, j)
        End If
    End If
End Sub
