//#define STRUCTVERSION
using System;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Text; 

namespace TestWaveInCaps
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.NumericUpDown numericUpDown1;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.Container components = null;
		public Form1()
		{
			InitializeComponent();
		}
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.numericUpDown1 = new System.Windows.Forms.NumericUpDown();
			this.label1 = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).BeginInit();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(32, 40);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(144, 23);
			this.button1.TabIndex = 0;
			this.button1.Text = "Device-Name abfragen";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// numericUpDown1
			// 
			this.numericUpDown1.Location = new System.Drawing.Point(224, 40);
			this.numericUpDown1.Name = "numericUpDown1";
			this.numericUpDown1.Size = new System.Drawing.Size(32, 20);
			this.numericUpDown1.TabIndex = 1;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(192, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(88, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "WaveIn-Device";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 118);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.numericUpDown1);
			this.Controls.Add(this.button1);
			this.Name = "Form1";
			this.Text = "TestWaveInCaps";
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		// Importe
#if STRUCTVERSION
		[DllImport("winmm.dll", SetLastError = true)]
		static extern int waveInGetDevCaps(uint uDeviceID, ref WaveInCapsStruct pwic, int cbwic ); 
#else
		[DllImport("winmm.dll", SetLastError = true)]
		static extern int waveInGetDevCaps(uint uDeviceID, [Out] WaveInCapsClass pwic, int cbwic ); 
#endif
		[DllImport("winmm.dll", SetLastError = true)]
		private static extern int waveInGetErrorText(int mmrError, StringBuilder pszText, uint cchText); 

#if STRUCTVERSION
		public static void GetDevCaps(uint devID, ref WaveInCapsStruct wic)
		{
			HandleErr(waveInGetDevCaps(devID, ref wic, 80));
		}
#else
		public static void GetDevCaps(uint devID, ref WaveInCapsClass wic)
		{
			HandleErr(waveInGetDevCaps(devID, wic, 80));
		}
#endif

		public static string GetErrorText(int mmError)
		{
			const int MAXERRORLENGTH  = 256; 
			StringBuilder pszText = new StringBuilder(MAXERRORLENGTH);
			waveInGetErrorText(mmError, pszText, MAXERRORLENGTH); 
			return pszText.ToString();
		}

		private static void HandleErr(int mmErr)
		{
			if (mmErr != 0)
				throw new Exception("WaveIn (Error " + mmErr.ToString() + "):\n" + GetErrorText(mmErr)); 
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
#if STRUCTVERSION
			WaveInCapsStruct wc; 
#else
			WaveInCapsClass wc = new WaveInCapsClass(); 
#endif
			GetDevCaps((uint) numericUpDown1.Value, ref wc); 
			MessageBox.Show(wc.szName, "Device-Name"); 
		}
	}

	[StructLayout(LayoutKind.Sequential, Size = 80)]
	public class WaveInCapsClass
	{
		/// <summary>
		/// Manufacturer ID
		/// </summary>
		public ushort  wMid;                    
		/// <summary>
		///  Product ID 
		/// </summary>
		public ushort  wPid;                  
		/// <summary>
		/// Version of the driver
		/// </summary>
		public byte ver0, ver1, ver2, ver3;   // vDriverVersion;  
		/// <summary>
		/// Product name (Marshalled from NULL terminated string)
		/// </summary>
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
		public string szName; 
		/// <summary>
		/// Formats supported
		/// </summary>
		public uint   dwFormats;               
		/// <summary>
		/// Number of channels supported
		/// </summary>
		public short    wChannels;               
	}

	[StructLayout(LayoutKind.Explicit, Size = 80)]
	public struct WaveInCapsStruct
	{
		[FieldOffset (8), MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
		public string szName; 
	}

}
