#define testing
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Sound; 
using System.IO; 

namespace TestWaveIn
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
  public class Form1 : System.Windows.Forms.Form
  {
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.DateTimePicker dtStart;
    private System.Windows.Forms.DateTimePicker dtStop;
    private System.Windows.Forms.Timer timer1;
    private System.Windows.Forms.TextBox tbDateiname;
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.ProgressBar progressBar1;
    private System.Windows.Forms.Button bTimer;
    private System.Windows.Forms.Button bStartStop;
    private System.Windows.Forms.Panel pTrigger;
    private System.Windows.Forms.TrackBar tBTimeDelay;
    private System.Windows.Forms.TrackBar tBTrigger;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.Label label5;
    private System.Windows.Forms.Label lTriggerMin;
    private System.Windows.Forms.Label lTriggerMax;
    private System.Windows.Forms.Label lTrigger;
    private System.Windows.Forms.Label lTriggerDelay;
    private System.Windows.Forms.Label label7;
    private System.Windows.Forms.Label label8;
    private System.Windows.Forms.StatusBar statusBar1;
    private System.Windows.Forms.RadioButton rbTest;
    private System.Windows.Forms.RadioButton rbDaily;
    private System.ComponentModel.IContainer components;

    public Form1()
    {
      InitializeComponent();
      InitStartStopTime(); 
      log("Programm gestartet"); 
    }

    /// <summary>
    /// Die verwendeten Ressourcen bereinigen.
    /// </summary>
    protected override void Dispose( bool disposing )
    {
      if( disposing )
      {
        if (components != null) 
        {
          components.Dispose();
        }
      }
      base.Dispose( disposing );
    }

    #region Vom Windows Form-Designer generierter Code
    /// <summary>
    /// Erforderliche Methode fr die Designeruntersttzung. 
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
    /// </summary>
    private void InitializeComponent()
    {
		this.components = new System.ComponentModel.Container();
		this.bStartStop = new System.Windows.Forms.Button();
		this.dtStart = new System.Windows.Forms.DateTimePicker();
		this.label1 = new System.Windows.Forms.Label();
		this.label2 = new System.Windows.Forms.Label();
		this.dtStop = new System.Windows.Forms.DateTimePicker();
		this.bTimer = new System.Windows.Forms.Button();
		this.timer1 = new System.Windows.Forms.Timer(this.components);
		this.tbDateiname = new System.Windows.Forms.TextBox();
		this.label3 = new System.Windows.Forms.Label();
		this.progressBar1 = new System.Windows.Forms.ProgressBar();
		this.pTrigger = new System.Windows.Forms.Panel();
		this.tBTimeDelay = new System.Windows.Forms.TrackBar();
		this.tBTrigger = new System.Windows.Forms.TrackBar();
		this.label4 = new System.Windows.Forms.Label();
		this.label5 = new System.Windows.Forms.Label();
		this.lTriggerMin = new System.Windows.Forms.Label();
		this.lTriggerMax = new System.Windows.Forms.Label();
		this.lTrigger = new System.Windows.Forms.Label();
		this.lTriggerDelay = new System.Windows.Forms.Label();
		this.label7 = new System.Windows.Forms.Label();
		this.label8 = new System.Windows.Forms.Label();
		this.statusBar1 = new System.Windows.Forms.StatusBar();
		this.rbTest = new System.Windows.Forms.RadioButton();
		this.rbDaily = new System.Windows.Forms.RadioButton();
		this.pTrigger.SuspendLayout();
		((System.ComponentModel.ISupportInitialize)(this.tBTimeDelay)).BeginInit();
		((System.ComponentModel.ISupportInitialize)(this.tBTrigger)).BeginInit();
		this.SuspendLayout();
		// 
		// bStartStop
		// 
		this.bStartStop.Location = new System.Drawing.Point(512, 16);
		this.bStartStop.Name = "bStartStop";
		this.bStartStop.Size = new System.Drawing.Size(40, 24);
		this.bStartStop.TabIndex = 0;
		this.bStartStop.Text = "Start";
		this.bStartStop.Click += new System.EventHandler(this.bStartStop_Click);
		// 
		// dtStart
		// 
		this.dtStart.CustomFormat = "ddd.dd.MM.yyyy \'um\' HH:mm";
		this.dtStart.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
		this.dtStart.Location = new System.Drawing.Point(40, 18);
		this.dtStart.Name = "dtStart";
		this.dtStart.Size = new System.Drawing.Size(152, 20);
		this.dtStart.TabIndex = 7;
		this.dtStart.ValueChanged += new System.EventHandler(this.dtStart_ValueChanged);
		// 
		// label1
		// 
		this.label1.AutoSize = true;
		this.label1.Location = new System.Drawing.Point(8, 20);
		this.label1.Name = "label1";
		this.label1.Size = new System.Drawing.Size(28, 16);
		this.label1.TabIndex = 9;
		this.label1.Text = "Start";
		// 
		// label2
		// 
		this.label2.AutoSize = true;
		this.label2.Location = new System.Drawing.Point(208, 20);
		this.label2.Name = "label2";
		this.label2.Size = new System.Drawing.Size(27, 16);
		this.label2.TabIndex = 11;
		this.label2.Text = "Stop";
		// 
		// dtStop
		// 
		this.dtStop.CustomFormat = "ddd.dd.MM.yyyy \'um\' HH:mm";
		this.dtStop.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
		this.dtStop.Location = new System.Drawing.Point(240, 18);
		this.dtStop.Name = "dtStop";
		this.dtStop.ShowUpDown = true;
		this.dtStop.Size = new System.Drawing.Size(152, 20);
		this.dtStop.TabIndex = 10;
		this.dtStop.ValueChanged += new System.EventHandler(this.dtStop_ValueChanged);
		// 
		// bTimer
		// 
		this.bTimer.Location = new System.Drawing.Point(408, 16);
		this.bTimer.Name = "bTimer";
		this.bTimer.Size = new System.Drawing.Size(96, 24);
		this.bTimer.TabIndex = 15;
		this.bTimer.Text = "Timer starten";
		this.bTimer.Click += new System.EventHandler(this.bTimer_Click);
		// 
		// timer1
		// 
		this.timer1.Interval = 10000;
		this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
		// 
		// tbDateiname
		// 
		this.tbDateiname.Location = new System.Drawing.Point(40, 48);
		this.tbDateiname.Name = "tbDateiname";
		this.tbDateiname.ReadOnly = true;
		this.tbDateiname.Size = new System.Drawing.Size(232, 20);
		this.tbDateiname.TabIndex = 17;
		this.tbDateiname.Text = "Rec.wav";
		// 
		// label3
		// 
		this.label3.AutoSize = true;
		this.label3.Location = new System.Drawing.Point(8, 50);
		this.label3.Name = "label3";
		this.label3.Size = new System.Drawing.Size(31, 16);
		this.label3.TabIndex = 18;
		this.label3.Text = "Datei";
		// 
		// progressBar1
		// 
		this.progressBar1.Location = new System.Drawing.Point(8, 8);
		this.progressBar1.Maximum = 9;
		this.progressBar1.Name = "progressBar1";
		this.progressBar1.Size = new System.Drawing.Size(336, 24);
		this.progressBar1.Step = 1;
		this.progressBar1.TabIndex = 19;
		// 
		// pTrigger
		// 
		this.pTrigger.BackColor = System.Drawing.Color.Red;
		this.pTrigger.Controls.Add(this.progressBar1);
		this.pTrigger.Location = new System.Drawing.Point(288, 48);
		this.pTrigger.Name = "pTrigger";
		this.pTrigger.Size = new System.Drawing.Size(352, 40);
		this.pTrigger.TabIndex = 20;
		// 
		// tBTimeDelay
		// 
		this.tBTimeDelay.Location = new System.Drawing.Point(16, 120);
		this.tBTimeDelay.Name = "tBTimeDelay";
		this.tBTimeDelay.Size = new System.Drawing.Size(240, 45);
		this.tBTimeDelay.SmallChange = 5;
		this.tBTimeDelay.TabIndex = 21;
		this.tBTimeDelay.TickFrequency = 10;
		this.tBTimeDelay.Value = 5;
		this.tBTimeDelay.Scroll += new System.EventHandler(this.tBTimeDelay_Scroll);
		// 
		// tBTrigger
		// 
		this.tBTrigger.Location = new System.Drawing.Point(16, 192);
		this.tBTrigger.Maximum = 100;
		this.tBTrigger.Name = "tBTrigger";
		this.tBTrigger.Size = new System.Drawing.Size(240, 45);
		this.tBTrigger.SmallChange = 5;
		this.tBTrigger.TabIndex = 22;
		this.tBTrigger.TickFrequency = 5;
		this.tBTrigger.Value = 25;
		this.tBTrigger.Scroll += new System.EventHandler(this.tBTrigger_Scroll);
		// 
		// label4
		// 
		this.label4.Location = new System.Drawing.Point(104, 232);
		this.label4.Name = "label4";
		this.label4.Size = new System.Drawing.Size(72, 16);
		this.label4.TabIndex = 23;
		this.label4.Text = "Schwellwert";
		// 
		// label5
		// 
		this.label5.Location = new System.Drawing.Point(64, 160);
		this.label5.Name = "label5";
		this.label5.Size = new System.Drawing.Size(168, 16);
		this.label5.TabIndex = 24;
		this.label5.Text = "Ansprech-Verzgerung (Sek)";
		// 
		// lTriggerMin
		// 
		this.lTriggerMin.Location = new System.Drawing.Point(24, 232);
		this.lTriggerMin.Name = "lTriggerMin";
		this.lTriggerMin.Size = new System.Drawing.Size(40, 16);
		this.lTriggerMin.TabIndex = 25;
		this.lTriggerMin.Text = "0";
		// 
		// lTriggerMax
		// 
		this.lTriggerMax.Location = new System.Drawing.Point(232, 232);
		this.lTriggerMax.Name = "lTriggerMax";
		this.lTriggerMax.Size = new System.Drawing.Size(40, 16);
		this.lTriggerMax.TabIndex = 26;
		this.lTriggerMax.Text = "100";
		// 
		// lTrigger
		// 
		this.lTrigger.Location = new System.Drawing.Point(264, 200);
		this.lTrigger.Name = "lTrigger";
		this.lTrigger.Size = new System.Drawing.Size(40, 16);
		this.lTrigger.TabIndex = 27;
		this.lTrigger.Text = "25";
		// 
		// lTriggerDelay
		// 
		this.lTriggerDelay.Location = new System.Drawing.Point(264, 128);
		this.lTriggerDelay.Name = "lTriggerDelay";
		this.lTriggerDelay.Size = new System.Drawing.Size(40, 16);
		this.lTriggerDelay.TabIndex = 30;
		this.lTriggerDelay.Text = "5";
		// 
		// label7
		// 
		this.label7.Location = new System.Drawing.Point(232, 160);
		this.label7.Name = "label7";
		this.label7.Size = new System.Drawing.Size(40, 16);
		this.label7.TabIndex = 29;
		this.label7.Text = "10";
		// 
		// label8
		// 
		this.label8.Location = new System.Drawing.Point(24, 160);
		this.label8.Name = "label8";
		this.label8.Size = new System.Drawing.Size(24, 16);
		this.label8.TabIndex = 28;
		this.label8.Text = "0";
		// 
		// statusBar1
		// 
		this.statusBar1.Location = new System.Drawing.Point(0, 276);
		this.statusBar1.Name = "statusBar1";
		this.statusBar1.Size = new System.Drawing.Size(656, 22);
		this.statusBar1.TabIndex = 31;
		// 
		// rbTest
		// 
		this.rbTest.Location = new System.Drawing.Point(40, 96);
		this.rbTest.Name = "rbTest";
		this.rbTest.Size = new System.Drawing.Size(168, 24);
		this.rbTest.TabIndex = 33;
		this.rbTest.Text = "alle 20 Minuten (Testbetrieb)";
		this.rbTest.CheckedChanged += new System.EventHandler(this.tbDaily_CheckedChanged);
		// 
		// rbDaily
		// 
		this.rbDaily.Checked = true;
		this.rbDaily.Location = new System.Drawing.Point(40, 72);
		this.rbDaily.Name = "rbDaily";
		this.rbDaily.TabIndex = 34;
		this.rbDaily.TabStop = true;
		this.rbDaily.Text = "tglich";
		this.rbDaily.CheckedChanged += new System.EventHandler(this.tbDaily_CheckedChanged);
		// 
		// Form1
		// 
		this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
		this.ClientSize = new System.Drawing.Size(656, 298);
		this.Controls.Add(this.rbDaily);
		this.Controls.Add(this.rbTest);
		this.Controls.Add(this.statusBar1);
		this.Controls.Add(this.lTriggerDelay);
		this.Controls.Add(this.label7);
		this.Controls.Add(this.label8);
		this.Controls.Add(this.lTrigger);
		this.Controls.Add(this.lTriggerMax);
		this.Controls.Add(this.lTriggerMin);
		this.Controls.Add(this.label5);
		this.Controls.Add(this.label4);
		this.Controls.Add(this.tBTrigger);
		this.Controls.Add(this.tBTimeDelay);
		this.Controls.Add(this.label3);
		this.Controls.Add(this.tbDateiname);
		this.Controls.Add(this.bTimer);
		this.Controls.Add(this.label2);
		this.Controls.Add(this.dtStop);
		this.Controls.Add(this.label1);
		this.Controls.Add(this.dtStart);
		this.Controls.Add(this.bStartStop);
		this.Controls.Add(this.pTrigger);
		this.Name = "Form1";
		this.Text = "WaveRecorder";
		this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
		this.pTrigger.ResumeLayout(false);
		((System.ComponentModel.ISupportInitialize)(this.tBTimeDelay)).EndInit();
		((System.ComponentModel.ISupportInitialize)(this.tBTrigger)).EndInit();
		this.ResumeLayout(false);

	}
    #endregion

    [STAThread]
    static void Main() 
    {
      Application.Run(new Form1());
    }

    #region Datenverarbeitung
    private WaveIn win; 
    private FileStream fs, fsIdx; 
    private int WaveDataLen; 
    private bool fsOpen; 

    private void win_open(object sender, WaveIn.WaveInEventArgs e)
    {
    }

    // Asynchone Methode wird synchron beendet 
    private void win_close(object sender, WaveIn.WaveInEventArgs e)
    {
      BeginInvoke(new fin(finishSync)); 
    }
    delegate void fin(); 
    void finishSync()
    {
      WriteRemainingFrames(); 
      Frames = null; 
      lock(this)
      {
        fs.Seek(4,0);
        fs.Write(IntToByteArray(WaveDataLen+36),0,4); 
        fs.Seek(40,0);
        fs.Write(IntToByteArray(WaveDataLen),0,4); 
        fsOpen = false; 
        fs.Close(); 
        fsIdx.Close(); 
        bStartStop.Enabled = true; 
      }
    }

    byte[] IntToByteArray(int arg)
    {
      return new byte[] {(byte) arg, (byte)(arg >> 8), (byte)(arg >> 16), (byte)(arg >> 24)}; 
    }

    // verarbeitet einen Frame
    private void win_data(object sender, WaveIn.WaveInEventArgs e)
    {
      double sum = 0; 
      // Aufsummieren der Absolutwerte
      for(int i = 0; i < e.sArr.Length; i++)
        if (e.sArr[i] > 0)
          sum += e.sArr[i];
        else 
          sum -= e.sArr[i];
      DisplayLevel(sum); 
       ProcessFrame(e.bArr, sum); 
    }

    // Aussteuerungsmesser
    const int Triggerfaktor = 50000; 
    private void DisplayLevel(double sum)
    {
      double squelch = sum - tBTrigger.Value*Triggerfaktor;   // Schwellwert 
      int i;
      double j = 1000; 
      if (squelch > 0) 
        for(i = 0; i < 60; i++, j*=5.1) // Lautstrkeanzeige
        {
          if(squelch < j) 
          {
            progressBar1.Value = i; 
            break; 
          }
        }
      else 
        progressBar1.Value = 0; 

    }

    ArrayList Frames;       // Liste
    int MaxFrames;          // Anzahl der betrachteten Frames
    double levels = 0;         // Aufsummieren der Levels 
    bool InBlock = false;   // true solange Block geschrieben wird

    // kopiert Frames, sammelt jeweils n in ArrayList und prft, 
    // ob diese im Mittel den Schwellwert berschreiten.
    // wenn ja, wird ein Frame geschrieben, wenn nein, verworfen. 
    // - fr jeden zusammenhngenden Block erfolgt ein Eintrag in Indexdatei (Datetime + Offset in Wav-Datei)!
    private void ProcessFrame(byte[] Arr, double sum)
    {
      byte[] bArr; 
      if (Frames == null)  // beim ersten Mal alles initialisieren; 
      {
        MaxFrames = 1 + (2 * 22050 / Arr.Length) * tBTimeDelay.Value; 
        Frames = new ArrayList(); 
      }

      Frames.Add(new Entry(sum, (byte[])Arr.Clone()));  // neuen Frame in Liste eintragen
      levels += sum; 
      Entry entry = (Entry)Frames[0];  
      if (Frames.Count == MaxFrames)
      {
        // obere Blockbedingung (Hysterese)
        if (levels > tBTrigger.Value * Triggerfaktor * MaxFrames)  
        {
          if (!InBlock)  // neuer Block?
          {
            // neuer Eintrag in Indexdatei
            InBlock = true; 
            int t = entry.time.Hour << 16 + entry.time.Minute << 8 + entry.time.Second; 
            fsIdx.Write(IntToByteArray(WaveDataLen), 0, 4);
            fsIdx.Write(IntToByteArray(t), 0, 4);
          }
        }
        // untere Blockbedingung = 0.7 * obere (Hysterese)
        if (levels > 0.7 * tBTrigger.Value * Triggerfaktor * MaxFrames)  
        {
          levels -= entry.level; 
          WriteFrame(entry.arr); 
          Frames.RemoveAt(0); 
          pTrigger.BackColor = Color.Green; 
        }
        else  // Block zu Ende dh. Frames rausschreiben oder ltesten Frame verwerfen
        {
          if(!InBlock) // ltesten Frame verwerfen
          {
            levels -= ((Entry)Frames[0]).level; 
            Frames.RemoveAt(0); 
          }
          else
            WriteRemainingFrames();  // setzt InBlock auf false
        }
      }
    }

    private void WriteFrame(byte[] bArr)
    {
      if (fsOpen)
        lock(this)
        {
          WaveDataLen += bArr.Length; 
          fs.Write(bArr,0,bArr.Length); 
        }
    }

    private void WriteRemainingFrames()
    {
      pTrigger.BackColor = Color.Red; 
      progressBar1.Value = 0; 
      if(InBlock)    // Frames rausschreiben (letzten auch!)
      {
        while (Frames.Count > 0)
        {
          WriteFrame(((Entry)Frames[0]).arr); 
          Frames.RemoveAt(0); 
        }
      }
      levels = 0; 
      InBlock = false; 
    }

    struct Entry
    {
      public DateTime time;
      public double level; 
      public byte[] arr; 
      public Entry(double l, byte[] b)
      {
        time = DateTime.Now; 
        level = l; 
        arr = b; 
      }
    }

    #endregion 

    private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
    {
      if (bTimer.Text != "Timer starten")
        bTimer_Click(null, null); 
      if (win != null)
        win.Close(); 
      System.Threading.Thread.Sleep(500); 
      log("Programm beendet"); 
    }

    #region StartStopTime
    // Auf Mitternacht nchster Tag initialisieren
    private void InitStartStopTime()
    {
      if (rbTest.Checked)
        dtStart.Value = DateTime.Now + new TimeSpan(0,0,0,30);
      else
      {
        DateTime Now = DateTime.Now + new TimeSpan(1,0,0,0);
        dtStart.Value = new DateTime(Now.Year, Now.Month, Now.Day, 0, 0, 0); 
      }
      dtStart_ValueChanged(null, null);
    }
    //Dateinamen generieren
    private void dtStart_ValueChanged(object sender, System.EventArgs e)
    {
      if (rbTest.Checked)
        dtStop.Value = dtStart.Value + new TimeSpan(0,8,0);  
      else
        dtStop.Value = dtStart.Value + new TimeSpan(5,0,0);  // 5 Stunden

      DateTime dt = dtStart.Value; 
      string datetime = dt.ToShortDateString() + "_"+dt.ToLongTimeString();
      datetime = datetime.Replace(":", "-"); 
      datetime = datetime.Replace(".", "-"); 
      tbDateiname.Text = "Rec "+ datetime +".wav"; 
    }
    private void dtStop_ValueChanged(object sender, System.EventArgs e)
    {
      if (dtStop.Value <= dtStart.Value)
      {
        if (rbTest.Checked)
          dtStop.Value = dtStart.Value + new TimeSpan(0,8,0);  
        else
          dtStop.Value = dtStart.Value + new TimeSpan(5,0,0);  // 5 Stunden
      }
    }
    #endregion

    private void tBTrigger_Scroll(object sender, System.EventArgs e)
    {
      lTrigger.Text = tBTrigger.Value.ToString();
    }

    private void tBTimeDelay_Scroll(object sender, System.EventArgs e)
    {
      lTriggerDelay.Text = tBTimeDelay.Value.ToString();
    }

    #region Buttons
    private void bStartStop_Click(object sender, System.EventArgs e)
    {
      if (bStartStop.Text == "Stop")
      {
        bTimer.Enabled = true; 
        bStartStop.Enabled = false; 
        bStartStop.Text = "Start"; 
        win.Close(); 
      }
      else
      {
        bTimer.Enabled = false;
        bStartStop.Text = "Stop"; 
        initWaveIn(); 
      }
    }

    // Wav-Datei und WaveIn-Objekt anlegen, Handler registrieren und starten 
    void initWaveIn()
    {
      WaveDataLen = 0;
      lock(this)
      {
        fs = new FileStream(tbDateiname.Text,FileMode.Create); 
        fsIdx = new FileStream(tbDateiname.Text + ".idx",FileMode.Create); 
        initFileStream(WAVEFORMAT._2M16,fs); 
      }
      fsOpen = true; 
      win = new WaveIn(WAVEFORMAT._2M16, -1, 4410, 3);  // Buffer reicht fr 1 Sek
      win.WIOpen += new WaveIn.WaveInEvent(win_open); 
      win.WIClose += new WaveIn.WaveInEvent(win_close); 
      win.WIData += new WaveIn.WaveInEvent(win_data); 
      win.Start(); 
    }

    // legt die Wave-Datei fr das verwendete Format an
    void initFileStream(WAVEFORMAT FormatTag, FileStream fs)
    {
      uint ft = (ushort)FormatTag; 
      short Channels = 0; 
      int SampleRate = 0; 
      int ByteRate = 0; 
      short BitsPerSample = 0; 
      bool done = false; 

      for(SampleRate = 11025; !done && SampleRate < 50000; SampleRate*=2)
      {
        for (ushort i = 0; i < 4 && !done; i++, ft >>= 1)
        {
          Channels = (short) (i % 2 + 1); 
          BitsPerSample = (short) ((i / 2+1) * 8); 
          if((ft & 1) == 1)
          {
            done = true; 
          }
        }
      }
      SampleRate/=2; 
      ByteRate = SampleRate * Channels * BitsPerSample/8; 
      short BlockAlign = (short) (Channels * BitsPerSample / 8); 

      fs.Seek(0,0); 
      // http://ccrma-www.stanford.edu/CCRMA/Courses/422/projects/WaveFormat/
      byte[] header = new byte[] { 0x52, 0x49, 0x46, 0x46,  // "RIFF"
                                   0, 0, 0, 0,              // offs 8: 36+DataSize
                                   0x57, 0x41, 0x56, 0x45,  // "WAVE"
                                   0x66, 0x6d, 0x74, 0x20,  // "fmt "
                                   16, 0, 0, 0,              // Subchunk1Size
                                   1, 0, (byte) Channels, 0, // PCM, NumChannels
                                   (byte) (SampleRate%256), 
                                   (byte) (SampleRate/256), 0, 0, // SampleRate
                                   (byte) (ByteRate%256), 
                                   (byte) ((ByteRate % 0x10000)/0x100), 
                                   (byte) (ByteRate / 0x10000), 0, // ByteRate
                                   (byte) BlockAlign, 0, (byte) BitsPerSample, 0,
                                   0x64, 0x61, 0x74, 0x61,   // "data"
                                   0, 0, 0, 0                // offs 40: DataSize spter schreiben 
                                 };

      fs.Write(header,0,header.Length); 
    }

    private void bTimer_Click(object sender, System.EventArgs e)
    {
      if (bTimer.Text == "Timer starten")
      {
        bStartStop.Enabled = false; 
        bTimer.Text = "Timer stoppen";
        log("Timer gestartet");
        timer1.Enabled = true; 
      }
      else
      {
        bStartStop.Enabled = true; 
        bTimer.Text = "Timer starten";
        log("Timer interaktiv gestoppt");
        timer1.Enabled = false; 
        if (recording && win != null)
          win.Close(); 
      }
    }
    #endregion

    bool recording = false;  
    // startet und beendet die automatische Aufzeichnung
    // - pflegt die Startzeit
    private void timer1_Tick(object sender, System.EventArgs e)
    {
      DateTime dt = DateTime.Now; 
      if (recording)
      {
        if (dt > dtStop.Value)       // Stoppzeit erreicht?
        {
          recording = false; 
          log("Aufnahme beendet!"); 
          if (win != null)
            win.Close();
          if (rbTest.Checked)
          {
            dtStart.Value += new TimeSpan(0,0,20,0);  // plus 20 Minuten
          }
          else
          {
            dtStart.Value += new TimeSpan(1,0,0,0);  // plus 1 Tag
          }
        }
      }
      else
        if (dt > dtStart.Value)// Startzeit erreicht?
        {
          initWaveIn(); 
          log("Aufnahme gestartet: " + tbDateiname.Text); 
          recording = true; 
        }
    }

    private void log(string s)
    {
      string message = DateTime.Now.ToString("dd.MM.yy HH:mm:ss - ") + s; 
      statusBar1.Text = message; 
      StreamWriter sr = new StreamWriter("WaveRecorder.log", true); 
      sr.WriteLine(message); 
      sr.Close(); 
    }

    private void tbDaily_CheckedChanged(object sender, System.EventArgs e)
    {
      InitStartStopTime(); 
    }
 	}
}
