#import <Cocoa/Cocoa.h>
#import <IOBluetooth/objc/IOBluetoothL2CAPChannel.h>

#define MP3_PSM        11

#define MP3_DATA	0
#define MP3_CMD_RESET   1
#define MP3_CMD_VOLUME  2
#define MP3_CMD_FWREV   3

#define MP3_CMD_BUTTONS 4 

#define NO_CMD		0
#define CMD_NEXT	1
#define CMD_PAUSE	2
#define CMD_PREV	3

extern unsigned char gBlueMP3UUID[];

@interface BlueMP3Object : NSObject
{
    IOBluetoothL2CAPChannel	*mL2CAPChannel;
    BluetoothL2CAPMTU		channelMTU;

    NSAppleScript		*asCallbackScript;
    NSString			*asCallbackHandler;

    NSString			*currentSong;
    unsigned int		currentSongIndex;
    unsigned int 		blueMP3Volume;
    unsigned int 		internalCmd;
    BOOL			isPlaying;
    BOOL			continuePlaying;
    BOOL			loopMode;
    BOOL			batteryLow;
}

- (id)init;
- initWithVolume:(char)value andLoopMode:(BOOL)loop;

- (BOOL)selectBlueMP3;
- (BOOL)connectToBlueMP3;
- (BOOL)disconnectFromBlueMP3;
- (BOOL)isConnected;
- (BOOL)startPlaying:(NSArray *)songs;
- (void)playThread:(NSArray *)songs;
- (BOOL)sendMP3Data:(unsigned char *)buffer length:(UInt32)length;
- (void)pausePlaying;
- (void)stopPlaying;
- (void)previousSong;
- (void)nextSong;
- (void)setLoopMode:(BOOL)mode;
- (BOOL)getLoopMode;

- (BOOL)isPlaying;
- (NSString *)songBeingPlayed;
- (unsigned int)songBeingPlayedByIndex;

- (void)resetBlueMP3:(BOOL)hardReset;
- (void)setVolumeOfLeftChannel:(char)left ofRightChannel:(char)right;
- (void)setVolume:(char)value;
- (char)getVolume;
- (void)volumeFadeIn;
- (void)volumeFadeOut;

- (void)setAppleScriptCallback:(NSString *)handler inScript:(NSString *)script;
- (void)informAppleScriptAbout:(NSString *)msg withData:(int)data;

- (void)l2capChannelData:(IOBluetoothL2CAPChannel*)l2capChannel data:(void *)dataPtr length:(size_t)dataLength;
- (void)l2capChannelClosed:(IOBluetoothL2CAPChannel*)l2capChannel;

@end