/*
 * Notiz.java
 *
 * geschrieben 2004 von
 * Thomas Knneth
 */

import java.awt.*;
import java.util.*;
import java.util.zip.*;
import java.io.*;

public class Notiz implements TypeManager {
    
    private Vector notes, checksums;
    private String filename;
    private CRC32 checksum;
    
    /*
     * Instantiierung durch die Methode loadTypeManagers der
     * Klasse TKPDManager
     */
    public Notiz() {
        notes = new Vector();
        checksums = new Vector();
        checksum = new CRC32();
        filename = TKPDManager.USER_HOME + TKPDManager.FILE_SEPARATOR + "Notizen.txt";
        load(filename);
    }
    
    /*
     * laden der Notizen und berechnen
     * der CRC32 Prfsummen
     */
    private void load(String filename) {
        FileReader fr = null;
        BufferedReader br = null;
        String line;
        try {
            fr = new FileReader(filename);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if (line.length() == 0)
                    continue;
                notes.addElement(line);
                checksum.update(line.getBytes());
                checksums.addElement(new Long(checksum.getValue()));
            }
        } catch (IOException e) {
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                } catch (IOException e) {
                }
            }
        }
    }
    
    /*
     * speichern aller Notizen
     */
    private void save(String filename) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(filename);
            bw = new BufferedWriter(fw);
            for (int i = 0; i < notes.size(); i++) {
                bw.write(getNote(i));
                bw.newLine();
            }
        } catch (IOException e) {
            TKPDManager.showExceptionDialog(e);
        } finally {
            if (bw != null) {
                try {
                    bw.close();
                } catch (IOException e) {
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                } catch (IOException e) {
                }
            }
        }
    }
    
    /*
     * diese Methode vereinfacht den Zugriff
     * auf eine bestimmte Notiz
     */
    private String getNote(int pos) {
        return (String) notes.elementAt(pos);
    }
    
    /*
     * diese Methode gehrt zum TypeManager Interface
     */
    public boolean fileDeleted(Entry e) {
        int i, j;
        long checksum1, checksum2;
        checksum1 = Long.parseLong(e.getIntern());
        for (i = 0; i < checksums.size(); i++) {
            checksum2 = ((Long)checksums.elementAt(i)).longValue();
            if (checksum1 == checksum2) {
                checksums.removeElementAt(i);
                notes.removeElementAt(i);
            }
        }
        return false;
    }
    
    /*
     * diese Methode gehrt zum TypeManager Interface; ihr wird ein
     * Vector bergeben, der alle Eintrge im repository
     * enthlt (soweit sie zu diesem Modul gehren);
     * hier wird der lokale Datenbestand auf neue Notizen hin
     * berprft; wenn ein Element des Vectors entries im
     * lokalen Bestand gefunden wird, wird es aus entries entfernt;
     * die aufrufende Methode kann so Lschungen implements lokalen
     * Bestand ermitteln und das repository aktualisieren
     */
    public Vector getNewEntries(TKPDManager manager, Vector entries) {
        Entry e;
        long checksum1, checksum2;
        boolean found;
        int i, j;
        for (i = 0; i < checksums.size(); i++) {
            found = false;
            checksum1 = ((Long)checksums.elementAt(i)).longValue();
            for (j = 0; j < entries.size(); j++) {
                e = (Entry) entries.elementAt(j);
                checksum2 = Long.parseLong(e.getIntern());
                if (checksum1 == checksum2) {
                    found = true;
                    entries.removeElement(e);
                    break;
                }
            }
            if (found == false) {
                TKPDCanvas canvas = manager.createTKPDCanvas(5);
                String text = getNote(i);
                canvas.setText(text);
                manager.addEntry(canvas, this, manager.createFilenameFromText(text), Long.toString(checksum1));
            }
        }
        save(filename);
        return entries;
    }
}
