import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.imageio.*;
import java.util.*;
import java.io.*;

public class TKPDCanvas extends BufferedImage {
    
    private Graphics2D graphics;
    private int width, height;
    private FontMetrics fontMetrics;
    
    /* 
     * dieser Konstruktor bildet nur die Grundlage fr die 
     * ffentlichen Konstruktoren; sie ttigen implements Gegensatz
     * zu diesem setFont-Aufrufe; dies ist wichtig, weil setFont
     * einige Variablen initialisiert bzw. bestimmte Methoden aufruft
     */
    private TKPDCanvas(int width, int height) {
        super(width, height, BufferedImage.TYPE_INT_RGB);
        this.width = width;
        this.height = height;
        graphics = createGraphics();
    }

    public TKPDCanvas(int width, int height, Font f) {
        this(width, height);
        setFont(f);
    }

    public TKPDCanvas(int width, int height, int lines) {
        this(width, height);
        setFont(calcFontSize(null, Font.PLAIN, lines));
    }

    /*
     * ermittelt eine Fontgre, so da das Bild aus
     * lines Zeilen besteht
     */
    public Font calcFontSize(String name, int style, int lines) {
        Font font;
        Font lastFont = null;
        FontMetrics fm;
        int maxHeight = height / lines;
        for (int size = 1; size <= 999; size++) {
            font = new Font(name, style, size);
            fm = graphics.getFontMetrics(font);
            if ((fm.getMaxAscent() + fm.getMaxDescent()) > maxHeight)
                break;
            lastFont = font;
        }
        return lastFont;
    }
    
    public void setFont(Font font) {
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
    }
    
    public void setText(String text) {
        StringTokenizer tok = new StringTokenizer(text);
        String str;
        Rectangle bounds;
        int x = 0;
        int y = getAscent();
        int yOffset = getLineHeight();
        int xOffset;
        int blankWidth = fontMetrics.charWidth(' ');
        while (tok.hasMoreTokens()) {
            str = tok.nextToken();
            bounds = fontMetrics.getStringBounds(str, graphics).getBounds();
            xOffset = bounds.width + blankWidth;
            if ((x + xOffset) >= width) {
                y += yOffset;
                x = 0;
            }
            graphics.drawString(str, x, y);
            x += xOffset;
        }
    }
    
    public int getLineHeight() {
        return getAscent() + getDescent();
    }
    
    public int getAscent() {
        return fontMetrics.getAscent();
    }
    
    public int getDescent() {
        return fontMetrics.getDescent();
    }

    public void fillWithColor(Color col) {
        graphics.setBackground(col);
        graphics.clearRect(0, 0, width, height);
    }

    public Graphics getGraphics() {
        return graphics;
    }
    
    public void save(String filename) {
        try {
            ImageIO.write(this, "jpg", new File(filename));
        } catch (Exception e) {
        }
    }
}
