# -*- coding: ISO-8859-1 -*-
"""Interfaces fr die Blog-Applikation"""

from zope.interface import Interface

from zope.schema import TextLine, SourceText, Choice, Field

# Internationalisierung
from zope.app.i18n import ZopeMessageIDFactory as _

class IBlogEntry(Interface):
    """Ein Blog-Eintrag"""

    # Schema-Definitionen, die z.B. fr HTML-Widgets genutzt werden
    subject = TextLine(title=_(u'Betreff'),
                       description=_(u'Betreffzeile des Eintrags'),
                       default=u'',
                       required=True)

    topics = TextLine(title=_(u'Themen'),
                      description=_(u'Komma-getrennte Themenliste'),
                      default=u'',
                      required=False)

    text = SourceText(title=_(u'Blog-Eintrag'),
                      description=_(u'Text des Eintrags'),
                      default=u'',
                      required=True)

    renderer = Choice(title=_(u'Renderer'),
                      description=_(u'Textdarstellung'),
                      default=u'zope.source.rest', # reStructuredText
                      required=True,
                      vocabulary='SourceTypes')

    # Methoden des Interfaces -- in diesem Fall nur eine
    def getTopicsAsSequence():
        """Themen als Sequence zurck liefern, nicht als String"""

# Ein gutes existierendes Interface fr Container wie Ordner usw.
from zope.app.container.interfaces import IContainer

from zope.app.container.constraints import ContainerTypesConstraint
from zope.app.container.constraints import ItemTypePrecondition

# IContainer erbt bereits das Interface
class IBlog(IContainer):
    """Ein Blog, das als Container fr Blog-Entries fungiert"""

    title = TextLine(title=_(u'Titel'),
                    description=_(u'Titel des Blogs'),
                    default=u'',
                    required=True)

    tagline = TextLine(title=_(u'Tagline'),
                       description=_(u'Tagline (Untertitel) des Blogs'),
                       default=u'',
                       required=True)

    def __setitem__(name, object):
        """Blog-Eintrag hinzufgen"""

    # Nur Objekte erlauben, die das IBlogEntry-Interface befriedigen
    __setitem__.precondition = ItemTypePrecondition(IBlogEntry)

class IContainedInBlog(Interface):
    """Container, in denen sich BlogEntrys befinden drfen"""
    __parent__ = Field(constraint = ContainerTypesConstraint(IBlog))
