; ---------------------------------------------------------------------
; Name:             DiSo v0.9 (Direkte Sonderzeichen)
; Author:           Wolfgang Reszel fr c't
; Datum:            5.12.2004
;
; Language:         german
; Platform:         NT and above (testet with XP)
; #Includeable:     yes
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Erweitert die Tastatur um viele typographische Sonderzeichen. Im
; Gegensatz zu der blichen, im Artikel beschriebenen Methode Zeichen
; mit dem Send-Befehl an andere Anwendungen zu schicken, habe ich einen
; anderen aufwndigeren Weg gewhlt. Die Send-Methode funktioniert
; nmlich nicht mit Adobe Illustrator CS und Photoshop CS. Alle normal
; nicht ber die Tastatur erreichbare Zeichen werden nicht korrekt
; ausgegeben.
;
; Der Trick besteht nun darin, dass ich alle Zeichen als UTF-8-String
; in eine Variable schreibe und diesen von AutoHotkey im Unicodeformat
; in die Zwischenablage konvertiert.
; Die Zwischenablage wird nun ganz normal mit Strg+V in das Programm
; eingefgt.
; Ist Illustrator oder Photoshop aktiv, wird die Ausgabe deutlich
; verlangsamt, da sich die Programm sonst gerne verhaspeln
;
; Zustzlich lsst sich ein 31-Zeichen-Warner aktivieren, der in
; Dateidialogen einen Tooltip zeigt, wenn ein Dateiname lnger als
; 31 Zeichen ist.
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Konfiguration: ---------------------------------------------------
; ---------------------------------------------------------------------

#MaxThreads 50
#SingleInstance force   ; Nur eine Instanz
DetectHiddenWindows, On ; Erkenne versteckte Fenster
SetTitleMatchMode, 2    ; Titelerkennung in einem beliebigen Substring
BlockInput, Send        ; Blockiere die Tastatur, wenn Send ausgefhrt wird

; ---------------------------------------------------------------------
; -- Initialisierung: -------------------------------------------------
; ---------------------------------------------------------------------

Version_diso = 0.9
Titel_diso   = Direkte Sonderzeichen v%Version_diso% Freeware
Menu, TRAY, Tip, %Titel_diso%

AutoReplace_diso = yes
varWarner_diso = no
installed_diso = no

; ---------------------------------------------------------------------

; Prfe auf Systemsprache
StringRight, Lng_diso, A_Language, 2
if Lng_diso <> 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   msgbox, ,%Titel_diso%, DiSo funktioniert nur mit deutschen Tastaturlayouts.
   ExitApp
}

; Prfe aus Betriebssystem
if A_OSType <> WIN32_NT
{
   msgbox, ,%Titel_diso%, DiSo funktioniert nur unter Windows NT und hher.
   ExitApp
}

; Eigenes Traymen erstellen
Menu, TRAY, NoStandard
Menu, TRAY, Add, Tastaturbelegung zeigen                     , Belegung_diso
Menu, TRAY, Add, Zeichentabelle aufrufen                     , callCharMap_diso
Menu, TRAY, Add
Menu, TRAY, Add, Automatische Ersetzung                      , AutoReplace_diso
Menu, TRAY, Add, Hinweis bei Dateinamen lnger als 31 Zeichen, 31Warner_diso
Menu, TRAY, Add
Menu, TRAY, Add, DiSo deaktivieren                           , menuSettings_diso
Menu, TRAY, Add, verstecken                                  , hide_diso
Menu, TRAY, Add
Menu, TRAY, Add,DiSo mit Windows starten                     , goInst_diso
Menu, TRAY, Add
Menu, TRAY, Add,Beenden                                      , Quit_diso

Menu, TRAY, Default, Tastaturbelegung zeigen

; Kommandozeilenparameter ermitteln
Loop, %0% ; %0% enthlt die Anzahl der Parameter
{
   StringTrimRight, CLParameter_diso, %a_index%, 0 ; berflssige Leerzeichen entfernen
   if CLParameter_diso = /h                        ; Wenn Prameter = /h
   {
      Menu, TRAY, NoIcon                           ; dann TrayIcon verstecken
      TrayHidden_diso = yes
   }
   if CLParameter_diso = /-a                       ; Wenn Parameter = /-a
   {
      AutoReplace_diso = no                        ; AutoReplace deaktivieren
   }
   if CLParameter_diso = /31                       ; Wenn Parameter = /31
   {
      varWarner_diso = yes                         ; 31-Zeichen-Warner einschalten
   }
   if CLParameter_diso = /install                  ; Wenn Parameter = /install
   {
      gosub, install_diso                               ; DiSo im Autostart installieren
      exitapp
   }
   if CLParameter_diso = /uninstall                ; Wenn Parameter = /uninstall
   {
      gosub, uninstall_diso                             ; DiSo wieder deinstallieren
      exitapp
   }
}

Gosub, CheckInstalled_diso                         ; Prfe ob DiSo installiert
Gosub, AutoReplace_diso                            ; AutoReplace umschalten
Gosub, 31Warner_diso                               ; 31 Warner umschalten

Return ; Auto-Execute-Bereich beenden

; ---------------------------------------------------------------------
CheckInstalled_diso: ; Prfe ob DiSo installiert

   ; Autostart aus Registry auslesen
   RegRead, installedInReg_diso, HKEY_CURRENT_USER,SOFTWARE\Microsoft\Windows\CurrentVersion\Run, DiSo
   if installedInReg_diso =                                 ; Wenn nicht in Registry eingetragen
   {
      if installed_diso = yes                                  ; und DiSo als installiert markiert
      {
         Menu, TRAY, ToggleCheck, DiSo mit Windows starten        ; dann Menpunkt aktivieren
      }
      installed_diso = no                                      ; DiSo gilt als nicht installiert
   }
   else                                                     ; dann ist's wohl eingetragen
   {
      if installed_diso = no                                   ; DiSo gilt als nicht installiert?
      {
         Menu, TRAY, ToggleCheck, DiSo mit Windows starten        ; dann Menpunkt deaktivieren
      }
      installed_diso = yes                                     ; DiSo gilt als installiert
   }
   ; Wenn DiSo nicht installiert ist, wird nichts gendert und der Menpunkt ist aktiv
return

; ---------------------------------------------------------------------
goInst_diso: ; Installieren/Deinstallieren vom Men starten
   if installed_diso = yes ; Wenn schon installiert
      gosub, uninstall_diso     ; Deinstallieren
   else                    ; sonst
      gosub, install_diso       ; Installieren
   gosub, CheckInstalled_diso
return

; ---------------------------------------------------------------------
menuSettings_diso: ; Standardeinstellungen fr das Traymen
   Menu,TRAY,ToggleCheck,DiSo deaktivieren
   Menu,TRAY,ToggleEnable,Tastaturbelegung zeigen
   Menu,TRAY,ToggleEnable,Automatische Ersetzung
   Menu,TRAY,ToggleEnable,Hinweis bei Dateinamen lnger als 31 Zeichen
   Suspend,toggle
return

; ---------------------------------------------------------------------
AutoReplace_diso: ; Automatische Ersetzung umschalten
   if AutoReplace_diso = no ; Wenn aus
   {
      Menu,TRAY,UnCheck,Automatische Ersetzung ; dann wieder an
      AutoReplace_diso = yes
   }
   else                    ; Wenn an
   {
      Menu,TRAY,Check,Automatische Ersetzung   ; dann wieder aus
      AutoReplace_diso = no
   }
return


; ---------------------------------------------------------------------
31Warner_diso: ; 31-Zeichen-Warner umschalten
   if varWarner_diso = no
   {
      Menu, TRAY, UnCheck, Hinweis bei Dateinamen lnger als 31 Zeichen
      Settimer, subWarner_diso, OFF
      varWarner_diso = yes
   }
   else
   {
      Menu, TRAY, Check, Hinweis bei Dateinamen lnger als 31 Zeichen
      Settimer, subWarner_diso, 600
      varWarner_diso = no
   }
return

; ---------------------------------------------------------------------
Belegung_diso: ; About-Fenster
   Gui, 2:+ToolWindow
   Gui, 2:Add, Text,,Tastaturkrzel:
   Gui, 2:Font, S11, Tahoma
   ; Etwas Chaos ;-)
   Gui, 2:Add, Text,     y+2 w190 ReadOnly, Alt+.`t`t`nAlt+Shift+.`t`nStrg+Alt+Sh+.`t`nAlt+1`t`t`nAlt+2`t`t`nAlt+3`t`t`nAlt+<`t`t`nAlt+Shift+<`t`nStrg+Alt+<`t`nStrg+Alt+Sh+<`t`nAlt+#`t`t`nAlt+Sh+#`t`nAlt+-`t`t`nAlt+Sh+-`t`nAlt+`t`t
   Gui, 2:Add, Text, x+4     w190 ReadOnly, Alt+`t`t`nAlt+-`t`t`nAltGr+C`t`t`nAltGr+R`t`t`nAltGr+T`t`t`nAltGr+^`t`t`nAltGr+1`t`t`nAltGr+4`t`t`nAltGr+5`t`t`nAltGr+Y`t`t`nAltGr+O`t`t`nAltGr+Shift+O`t`nAltGr+F`t`t`nLShift+RShift+1`t`nLShift+RShift+`t
   Gui, 2:Font
   Gui, 2:Add, Text, x10     w190         , `nAutomatische Ersetzung:
   Gui, 2:Add, Text, x+4     w190         ,`nUnicode Zeichen:
   Gui, 2:Font, S11, Tahoma

   if AutoReplace_diso=no ; Wenn Autoreplace aktiv
   {
      Gui, 2:Add, Text, x10 y+2 w190,1/4`t`t`n1/2`t`t`n3/4`t`t`n
      Gui, 2:Add, Text, x+4 w190,<=`tkleiner gleich`n>=`tgrer gleich`n<>`tungleich`n==`tfast gleich`n++`tSigma`n1/8`n3/8`n5/8`n7/8`n
   }
   else                   ; Wenn AutoReplace inaktive, dann grau darstellen
   {
      Gui, 2:Add, Text, x10 y+2 w190 Disabled,1/4`t`t`n1/2`t`t`n3/4`t`t`n
      Gui, 2:Add, Text, x+4 w190 Disabled,<=#`tkleiner gleich`n>=#`tgrer gleich`n<>#`tungleich`n==#`tfast gleich`n++#`tSigma`n1/8`n3/8`n5/8`n7/8`n
   }
   Gui, 2:Font
   Gui, 2:Add, Text, x10 w400 center, von Wolfgang Reszel (ahk@rumborak.de)
   Gui, 2:Add, Button, Default x160 w100,OK
   Gui, 2:Show, Center , %Titel_diso%
return

; ---------------------------------------------------------------------
2GuiEscape: ; About-Fenster schlieen
2GuiCancel: ; About-Fenster schlieen
2ButtonOK:  ; About-Fenster schlieen

   Gui, 2:Destroy
return

; ---------------------------------------------------------------------
hide_diso: ; DiSo verstecken

   MsgBox, Das Programm kann nur noch ber den Taskmanager beendet werden.`nUm es direkt beim Starten zu verstecken, muss es mit dem Parameter /h aufgerufen werden.
   Menu,TRAY,NoIcon
   TrayHidden_diso = yes
return

; ---------------------------------------------------------------------
callCharMap_diso: ; Zeichentabelle aufrufen
   Run, charmap.exe
return

; ---------------------------------------------------------------------
subWarner_diso: ; 31-Zeichen-Warner

   WinGet, active_id, ID, A                     ; ID des aktiven Fensters
   WinGetClass, f_class, ahk_id %active_id%     ; Fensterklasse ermitteln
   If f_class = #32770                          ; Wenn Dialogfenster
   {
      WinGetActiveTitle, wintitle                  ; Fenstertitel ermitteln
      WinGetText, wintext, ahk_id %active_id%      ; Fenstertext ermittlen

      ; 31-Warner nur anzeigen, wenn der Dialog folgende Begriffe enthlt
      if wintext contains Dateiname, Filename, Folder, Verzeichnis, Ordner, Suchen in
      {
         ; ---------------------------------------------------------------------
         ; Zusatz fr InDesign:
         ; Dateinamen die im Dateidialog mit ".indd.ps" enden werden so umbenannt,
         ; dass das ".indd" verschwindet
         ControlGetFocus, control, ahk_id %active_id% ; Control ermitteln
         if control = Edit1                           ; Ist es ein Edit-Control?
         {
            ControlGetText, edittext_diso, Edit1, ahk_id %active_id% ; Inhalt des Edit-Controls
            if inddWasReplaced31_diso <> %active_id%                 ; Wurde der Inhalt schonmal ersetzt?
            {
               if edittext_diso contains .indd.ps                    ; Enthlt Control ".indd.ps"?
               {
                  StringReplace, edittext_diso, edittext_diso, .indd.ps, .ps  ; ".indd.ps" durch ".ps" ersetzen
                  ControlSetText, Edit1, %edittext_diso%, ahk_id %active_id%  ; Edit-Control ndern
               }
            }
            inddWasReplaced31_diso = %active_id%                     ; Merken, ob schon ersetzt wurde
         }
         ; ---------------------------------------------------------------------
      }
      else                                         ; Wenn Begriffe nicht enthalten
      {
         Gosub, TipHide31_diso                     ; ToolTip verschwinden lassen
      }
   }
   else                                         ; Wenn kein Dialog
   {
      Gosub, TipHide31_diso                     ; ToolTip verschwinden lassen
   }
return

; ---------------------------------------------------------------------
ToollTip31_diso: ;    ToolTip fr 31-Zeichen-Warner
   ControlGetText, edittext_diso, Edit1, ahk_id %active_id% ; Inhalt der aktiven EditBox
   SplitPath, edittext_diso, FName_diso                     ; nur der Dateiname
   StringLen, editlen_diso, FName_diso                      ; Lnge das Dateinamens
   if editlen_diso <> %editlenLast_diso%                    ; Wenn die Lnge sich gendert hat
   {
      if editlen_diso > 31                 ; Wenn zu lang
      {
         meldung31_diso        = Dateiname lnger als 31 Zeichen (%editlen_diso%) ; Meldung
         editlenLast_diso = %editlen_diso%                                   ; Lnge merken

         Gosub, TipRefresh31_diso             ; ToolTip anzeigen
         SetTimer, TipHide31_diso, 1600       ; ToolTip nach 1600 ms ausschalten
      }
      else                                 ; nicht zu lang
      {
         if editlen_diso = 31              ; Wenn genau 31 Zeichen
         {
            meldung31_diso = OK                      ; OK-Meldung
            editlenLast_diso = %editlen_diso%   ; Lnge merken
            Gosub, TipRefresh31_diso            ; ToolTip anzeigen
            SetTimer, TipHide31_diso, 600       ; ToolTip nach 600 mx ausschalten
         }
         else                              ; Wenn Lnge unter 31 Zeichen
         {
            Gosub, TipHide31_diso               ; ToolTip verstecken
         }
      }
   }
return

; ---------------------------------------------------------------------
TipHide31_diso: ;    ToolTip fr 31-Zeichen-Warner auschalten

   ToolTip,,,, 3
   SetTimer, TipHide31_diso, Off
return

; ---------------------------------------------------------------------
TipRefresh31_diso: ;    ToolTip fr 31-Zeichen-Warner positionieren

   ; Unterhalb des Eingabecursors
   X_31 = %A_CaretX%
   X_31 += 7
   Y_31 = %A_CaretY%
   Y_31 += 13

   ToolTip, %meldung31_diso%, %X_31%, %Y_31%,3
return

; ---------------------------------------------------------------------
install_diso: ; DiSo installiern

   ; Fragen
   MsgBox,36,%Titel_diso%, Soll DiSo automatisch mit Windows gestartet werden?
   IfMsgBox, Yes ; Wenn ja
   {
      ; Parametereinstellung der aktuellen Sitzung ermitteln
      p1 =
      p2 =
      p3 =
      if AutoReplace_diso = yes
         p1 = /-a
      if TrayHidden_diso = yes
         p2 = /h
      if varWarner_diso = no
         p3 = /31

      ; DiSo im Autostart und bei Systemsteuerung/Software installieren
      RegWrite, REG_SZ, HKEY_CURRENT_USER , SOFTWARE\Microsoft\Windows\CurrentVersion\Run           , DiSo           , %A_ScriptFullPath% %p1% %p2% %p3%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, DisplayIcon    , %A_ScriptFullPath%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, DisplayName    , DiSo v%Version_diso% startet mit Windows
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, DisplayVersion , v%Version_diso%
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, Publisher      , Wolfgang Reszel
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, UninstallString, %A_ScriptFullPath% /uninstall
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo, URLInfoAbout   , http://illustrator.hilfdirselbst.ch/Tools/

      MsgBox,64,%Titel_diso%, DiSo startet nun automatisch mit Windows.
   }
return

; ---------------------------------------------------------------------
uninstall_diso: ; DiSo deinstallieren

   ; Fragen, ob DiSo wirklich deinstalliert werden soll
   MsgBox,36,%Titel_diso%, Soll der automatische Start von DiSo wirklich deaktiviert werden?
   IfMsgBox, Yes ; Wenn ja
   {
     ;DiSo aus dem Autostart und Systemsteuerung/Software entfernen
     RegDelete, HKEY_CURRENT_USER , SOFTWARE\Microsoft\Windows\CurrentVersion\Run            , DiSo
     RegDelete, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DiSo

     MsgBox, 64, %Titel_diso%, DiSo startet nun nicht mehr automatisch beim Systemstart.
   }
return

; ---------------------------------------------------------------------
utf8send: ; UTF-8-String ber Zwischenablage ausgeben
; Dieser Weg ist fr Illustrator und Photoshop notwendig, da beide
; Programme Probleme mit dem Befehl Send haben. Das liegt allerdings
; an AutoHotKey, sondern an den Programmen. Die fragen die Tastatur
; scheinbar in einer unblichen Weise ab.

   WinGetActiveTitle, title_utf
   cliptemp_utf = %clipboard%                ; Zwichenablage sichern
   Transform, Clipboard, Unicode, %utf8%     ; UTF-8-String als Unicode in die Zwischanblage konvertieren
   Send,{Ctrl}                               ; Ctrl senden, es kommt sonst zu unerwarteten Problemen
   if title_utf contains Adobe Illustrator, Adobe Photoshop
      SetKeyDelay,70,1                          ; Die Tastenausgabe verlangsamen
   Send,^v                                   ; Strg+V ausgeben, also die Zwischenablage einfgen
   SetKeyDelay,                              ; Die Tastenausgabe wieder mit normalen Tempo
   if A_ThisHotKey contains <^>!,^!,!^       ; Wenn das Krzel AltGr oder Strg enthlt
   {
      GetKeyState, ctrlState_utf, Ctrl, P       ; Status von Strg ermitteln
      if ctrlState_utf = D                      ; Wenn Strg gedrckt
         Send,{LCtrl}{RAlt}                     ; Probleme mit Menleiste austricksen
   }
   else                                      ; wenn nicht
   {
      if A_ThisHotKey contains !             ; und das Krzel Alt enthlt
         Send,{Alt}                          ; Probleme mit Menleiste austricksen
   }
   clipboard = %cliptemp_utf%                ; alte Zwischenablage wiederherstellen
return

; ---------------------------------------------------------------------
Quit_diso:
   ExitApp
return

; ---------------------------------------------------------------------
; -- Tastaturkrzel ---------------------------------------------------
; ---------------------------------------------------------------------

;^!u:: ; Control+Alt+U
;   Transform, ClipUTF, Unicode
;   Clipboard = %ClipUTF%
;   send,^v
;return

!.::                          ; Alt + .
   utf8=•                  ; UF8-String von 
   gosub, utf8send
return
<^>!.::                      ; AltGr + .
   utf8=•                  ; UF8-String von 
   gosub, utf8send
return
!+.::Send,{Alt}             ; Alt + Shift + .
!^+.::                       ; Strg + Alt + Shift + .
   utf8=…                  ; UF8-String von 
   gosub, utf8send
return
!3::                         ; Alt + 3
   utf8=”                  ; UF8-String von 
   gosub, utf8send
return
!2::                         ; Alt + 2
   utf8=“                  ; UF8-String von 
   gosub, utf8send
return
!1::                         ; Alt + 1
   utf8=„                  ; UF8-String von 
   gosub, utf8send
return

!SC02B::                     ; Alt + #
   utf8=‘                  ; UF8-String von 
   gosub, utf8send
return
!+SC02B::                    ; Alt + Shift + #
   utf8=’                  ; UF8-String von 
   gosub, utf8send
return
!-::                         ; Alt + -
   utf8=–                  ; UF8-String von 
   gosub, utf8send
return
<^>!-::                      ; AltGr + -
   utf8=–                  ; UF8-String von 
   gosub, utf8send
return
!+-::                        ; Alt + Shift + -
   utf8=—                  ; UF8-String von 
   gosub, utf8send
return
<^>!+-::                     ; AltGr + Shift + -
   utf8=—                  ; UF8-String von 
   gosub, utf8send
return
!NumpadMult::                ; Alt +  (Zehnerblock)
   utf8=×                   ; UF8-String von 
   gosub, utf8send
return
<^>!NumpadMult::             ; AltGr +  (Zehnerblock)
   utf8=×                   ; UF8-String von 
   gosub, utf8send
return
!NumpadDiv::                 ; Alt +  (Zehnerblock)
   utf8=÷                   ; UF8-String von 
   gosub, utf8send
return
<^>!NumpadDiv::              ; AltGr +  (Zehnerblock)
   utf8=÷                   ; UF8-String von 
   gosub, utf8send
return
!NumpadAdd::                 ; Alt + - (Zehnerblock)
!NumpadSub::                 ; Alt + + (Zehnerblock)
   utf8=±                   ; UF8-String von 
   gosub, utf8send
return
!SC056::                     ; Alt + <
   utf8=«                   ; UF8-String von 
   gosub, utf8send
return
!+SC056::                    ; Alt + Shift + <
   utf8=»                   ; UF8-String von 
   gosub, utf8send
return
!^SC056::                    ; Strg + Alt + <
   utf8=‹                  ; UF8-String von 
   gosub, utf8send
return
!^+SC056::                   ; Strg + Alt + Shift + <
   utf8=›                  ; UF8-String von 
   gosub, utf8send
return
<^>!SC056::Send,|{Alt}       ; AltGr + <
<^>!c::                      ; AltGr + C
   utf8=©                   ; UF8-String von 
   gosub, utf8send
return
<^>!r::                      ; AltGr + R
   utf8=®                   ; UF8-String von 
   gosub, utf8send
return
<^>!t::                      ; AltGr + T
   utf8=™                  ; UF8-String von 
   gosub, utf8send
return
<^>!SC029::                  ; AltGr + ^
   utf8=º                   ; UF8-String von 
   gosub, utf8send
return
<^>!1::                      ; AltGr + 1
   utf8=¹                   ; UF8-String von 
   gosub, utf8send
return
<^>!4::                      ; AltGr + 4
   utf8=£                   ; UF8-String von 
   gosub, utf8send
return
<^>!5::                      ; AltGr + 5
   utf8=‰                  ; UF8-String von 
   gosub, utf8send
return
<^>!y::                      ; AltGr + Y
   utf8=¥                   ; UF8-String von 
   gosub, utf8send
return
<^>!o::                      ; AltGr + O
   utf8=ø                   ; UF8-String von 
   gosub, utf8send
return
<^>!+o::                     ; AltGr + Shift + O
   utf8=Ø                   ; UF8-String von 
   gosub, utf8send
return
<^>!f::                      ; AltGr + F
   utf8=ƒ                   ; UF8-String von 
   gosub, utf8send
return
<+>+::                      ; Shift + Shift + 
   utf8=¿                   ; UF8-String von 
   gosub, utf8send
return
<+>+1::                      ; Shift + Shift + 1 (!)
   utf8=¡                   ; UF8-String von 
   gosub, utf8send
return

; Automatische Ersetzung

:*B0:1`/4::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=¼                   ; UF8-String von 
      gosub, utf8send
   }
return
:*B0:1`/2::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=½                   ; UF8-String von 
      gosub, utf8send
   }
return
:*B0:3`/4::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=¾                   ; UF8-String von 
      gosub, utf8send
   }
return
:*B0:1`/8::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=⅛                  ; UF8-String von '1/8'
      gosub, utf8send
   }
return
:*B0:3`/8::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=⅜                  ; UF8-String von '3/8'
      gosub, utf8send
   }
return
:*B0:5`/8::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=⅝                  ; UF8-String von '5/8'
      gosub, utf8send
   }
return
:*B0:7`/8::
   if AutoReplace_diso = no
   {
      Send,{BS 3}
      utf8=⅞                  ; UF8-String von '7/8'
      gosub, utf8send
   }
return
:*B0:<=::
   if AutoReplace_diso = no
   {
      Send,{BS 2}
      utf8=≤                  ; UF8-String von 'kleiner gleich'
      gosub, utf8send
   }
return
:*B0:>=::
   if AutoReplace_diso = no
   {
      Send,{BS 2}
      utf8=≥                  ; UF8-String von 'grer gleich'
      gosub, utf8send
   }
return
:*B0:<>::
   if AutoReplace_diso = no
   {
      Send,{BS 2}
      utf8=≠
      ; UF8-String von 'fast gleich'
      gosub, utf8send
   }
return
:*B0:==::
   if AutoReplace_diso = no
   {
      Send,{BS 2}
      utf8=≈                  ; UF8-String von 'ungefhr'
      gosub, utf8send
   }
return
:*B0:++::
   if AutoReplace_diso = no
   {
      Send,{BS 2}
      utf8=∑                  ; UF8-String von 'Sigma'
      gosub, utf8send
   }
return

