; ---------------------------------------------------------------------
; Name:             Eject v0.1
; Author:           Wolfgang Reszel fr c't
; Datum:            5.12.2004
;
; Language:         german
; Platform:         tested with XP
; #Includeable:     yes
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Ermglicht es mit einem Tastaturkrzel CDs oder andere Medien
; auszuwerfen bzw. einzuziehen. Dabei wird wie bei Mac OS X ein
; transparentes Symbol am Bildschirm dargestellt.
;
; Bentigt die Datei Eject.bmp
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Konfiguration: ---------------------------------------------------
; ---------------------------------------------------------------------

FadeSpeed_ejct = 2 ; Ausblenden-Geschwindigkeit

; ---------------------------------------------------------------------
; -- Tastaturkrzel ---------------------------------------------------
; ---------------------------------------------------------------------

; Medium auswerfen/einziehen mit der Taste "Rollen"
ScrollLock:: ; HotkeyDef
   Drive_ejct = F:
   gosub, Eject
Return

; Medium auswerfen/einziehen mit der Taste "Shift+Rollen"
+ScrollLock:: ; HotkeyDef
   Drive_ejct = E:
   gosub, Eject
Return

; ---------------------------------------------------------------------
Eject: ; Medium auswerfen [Drive_ejct]

   transparent_ejct = 150 ; Anfangstransparenz

   ; Position berechnen
   distY_ejct = %A_ScreenHeight%
   posY_ejct  = %A_ScreenHeight%
   distY_ejct /= 4
   posY_ejct  -= %distY_ejct%

   ; Auswefen-Symbol darstellen
   ifExist, %A_ScriptDir%\Eject.bmp ; nur wenn auch vorhanden
   {
      Gui, Add, pic, x0 y0, %A_ScriptDir%\Eject.bmp  ; Bild laden
      DetectHiddenWindows on                         ; versteckte Fenster finden
      WinWait, %A_ScriptName%                        ; Aktuelles Gui-Fenster wird "last found"
      WinSet, TransColor ,0000FF %transparent_ejct%  ; Transparenz setzen
      WinSet, AlwaysOnTop, On                        ; Immer im Vordergrund
      Gui, -Caption                                  ; Ohne Titelleiste
      Gui, Show, w150 h150 y%posY_ejct%              ; Symbol darstellen
   }

   Drive, Eject, %Drive_ejct%                        ; Medium auswerden

   if A_TimeSinceThisHotkey < 1000                   ; Wenn Auswerfen sehr schnell ging
   {                                                 ; dann war das Laufwerk schon offen
      Drive, Eject, %Drive_ejct%, 1                  ; also wird es nun geschlossen
   }

   ; Auswerfen-Symbol langsam ausblenden
   ifExist, %A_ScriptDir%\Eject.bmp ; nur wenn auch vorhanden
   {
      Count_ejct = %transparent_ejct%
      Count_ejct /= %FadeSpeed_ejct%
      Loop, %Count_ejct%                               ; Schleife "Anfangstransparenz" mal
      {
         transparent_ejct -= %FadeSpeed_ejct%          ; Transparenz runterzhlen
         WinSet, TransColor,0000FF %transparent_ejct%  ; Transparenz setzen
      }
      Gui, Destroy                                     ; Symbol/Fenster aus dem Speicher
   }
return
