; ---------------------------------------------------------------------
; Name:             Verzeichnis-Liste v0.1
; Author:           Wolfgang Reszel fr c't
; Datum:            7.12.2004
;
; Language:         german
; Platform:         tested with XP
; #Includeable:     no
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Erweitert das Kontextmen des Explorers, so dass eine Liste aller in
; einem Verzeichnis enthaltenen Dateien in die Zwischenablage kopiert
; wird. Der Befehl ist nur im Kontextmen fr Verzeichnisse verfgbar
;
; Das Skript luft nur als kompilierte EXE-Datei vernnftig, da der
; Aufruf ber das Kontextmen bei normalen Skript-Dateien zu einer
; Fehlermeldung fhrt.
;
; Beim ersten Start fragt das Skript, ob es installiert werden soll.
; Die Deinstallation geschieht ber Systemsteuerung/Software
;
; Ruft man den Befehl bei gehaltener Shift-Taste auf, werden Optionen
; angezeigt, die dann auch in der Registry gespeichert werden.
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Initialisierung --------------------------------------------------
; ---------------------------------------------------------------------

#SingleInstance off
#NoTrayIcon

Version_vl   = 0.1
LongName_vl  = Verzeichnisinhalt in die Zwischenablage
ShortName_vl = Verzeichnis-Liste
Titel_vl     = %ShortName_vl% v%Version_vl% Freeware

; ---------------------------------------------------------------------

if 1 = ; ohne Kommandozeillenparameter
{
   ; Prfen ob Verzeichnis-Liste schon in Registry eingetragen
   RegRead, Reg_vl, HKEY_CLASSES_ROOT,Folder\shell\%LongName_vl%\command
   StringReplace, Reg_vl, Reg_vl ,%A_SPACE%"`%1",   ; [ "%1"] entfenren

   if Reg_vl <> %A_ScriptFullPath% ; Wenn Script noch nicht eingetragen
   {
      ; Fragen ob Verzeichnis-Liste ins Kontextmen integriert werden soll
      MsgBox, 36, %Titel_vl%, Soll %ShortName_vl% in das Explorer-Kontextmen integriert werden?
      IfMsgBox, Yes ; Wenn Ja
      {
         SplitPath, A_ScriptName,,, Ext_vl
         if Ext_vl = AHK
         {
            MsgBox, 16, %Titel_vl%, Die Integration ins Kontextmen funktioniert nur mit der kompilierten Version des Skripts!
            ExitApp
         }
         ; Verzeichnis-Liste in Registry eintragen
         RegWrite, REG_SZ, HKEY_CLASSES_ROOT , Folder\shell\%LongName_vl%\command                                ,                , %A_ScriptFullPath% "`%1"
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%, DisplayIcon    , %A_ScriptFullPath%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%, DisplayName    , %ShortName_vl% v%Version_vl%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%, DisplayVersion , v%Version_vl%
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%, Publisher      , Wolfgang Reszel
         RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%, UninstallString, %A_ScriptFullPath% /uninstall

         MsgBox, 64, %Titel_vl%, %ShortName_vl% wurde installiert!
      }
   }
   else ; Verzeichnis-Liste ist schon installiert
   {
      ; Hinweis ausgeben, wie Verzeichnis-Liste zu verwenden ist
      MsgBox, 64, %Titel_vl%, %ShortName_vl% muss mit einem Verzeichnis als Parameter aufgerufen werden!
   }
   ExitApp ; Ende
}

if 1 = /uninstall ; Wenn Kommandozeilenparameter = "/uninstall%
{
   ; Fragen ob Verzeichnis-Liste deinstalliert werden soll
   MsgBox, 36, %Titel_vl%, Soll %ShortName_vl% wirklich deinstalliert werden?
   IfMsgBox, Yes ; Wenn Ja
   {
      ; Verzeichnis-Liste aus der Registry entfernen
      RegDelete, HKEY_CLASSES_ROOT       , *\shell\%LongName_vl%
      RegDelete, HKEY_LOCAL_MACHINE      , SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%ShortName_vl%
      ; Eintrag in RunOnce, so dass Verzeichnis-Liste nach dem nchsten Systemstart gelscht wird
      RegWrite, REG_SZ, HKEY_LOCAL_MACHINE, SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce, %ShortName_vl%, %comspec% /c del /q "%A_ScriptFullPath%"

      MsgBox, 64, %Titel_vl%, %ShortName_vl% wurde deinstalliert. %A_ScriptName% wird nach einem Neustart automatisch gelscht.
   }
   ExitApp
}

; Hier geht's weiter, wenn eine Datei als Kommandozeilenparameter bergeben wurde
IfNotExist, %1%
{
   MsgBox, Das angegebene Verzeichnis existiert nicht!`n%1%
   ExitApp
}

RegRead, Recursive_vl, HKEY_CLASSES_ROOT , Folder\shell\%LongName_vl%\Options, Recursive
RegRead, FullPaths_vl, HKEY_CLASSES_ROOT , Folder\shell\%LongName_vl%\Options, FullPaths

GetKeyState,Shift_vl,Shift
if Shift_vl = D
{
   StringReplace, Recursive_Checked, Recursive_vl,1, Checked
   StringReplace, FullPaths_Checked, FullPaths_vl,1, Checked
   Gui, Add, CheckBox, vRecursive_vl %Recursive_Checked%, Unterverzeichnisse mit aufnehmen
   Gui, Add, CheckBox, vFullPaths_vl %FullPaths_Checked%, Komplette Pfade
   Gui, Add, Button,      gCancel_vl        , Abbrechen
   Gui, Add, Button, x+20 gOK_vl     Default, in Zwischenablage
   Gui, Show,,%ShortName_vl% v%Version_vl%
}
else
{
   Gosub, Verzeichnis-Liste
   ExitApp
}

Return ; Auto-Execute-Bereich beenden

OK_vl:
   Gui, Submit
   RegWrite, REG_SZ, HKEY_CLASSES_ROOT , Folder\shell\%LongName_vl%\Options, Recursive, %Recursive_vl%
   RegWrite, REG_SZ, HKEY_CLASSES_ROOT , Folder\shell\%LongName_vl%\Options, FullPaths, %FullPaths_vl%
   Gosub, Verzeichnis-Liste
   ExitApp
Return

Cancel_vl:
   GuiEscape:
   Gui, Destroy
   ExitApp
Return

Verzeichnis-Liste:
   SplashTextOn, 410, 23, %Titel_vl%, Kopieren den Verzeichnisinhalt in die Zwischenablage ...
   Loop, %1%\*.*, 1,%Recursive_vl%
   {
      SubName_vl = %A_LoopFileFullPath%
      if FullPaths_vl <> 1
         StringReplace, SubName_vl, SubName_vl, %1%\,
      AllFiles_vl = %AllFiles_vl%%SubName_vl%`n
   }

   clipboard = %AllFiles_vl%
   SplashTextOff
Return