#ifndef __prime_h
#define __prime_h

#include "bits.h"
#include "bitvalue.h"
#include "bucket.h"
#include "config.h"
#include "data.h"
#include "macro.h"
#include "status.h"

#include <ctime>
#include <fstream.h>

uint32 product 		(uint32);
uint32 getshift 	(uint64,uint32);
uint32 pi	 		(uint64,uint32);
uint32 listsize 	(uint64,uint32);

class Prime
{

public:

	 Prime();
	~Prime();
	
	ofstream files[8];

	clock_t time[4];

	uint64 count[7];

	void SetStart	(uint64);
	void SetStop	(uint64);
	void SetSieve	(uint32);
	void SetGSize	(uint32);
	void SetRepF	(uint32);
	void SetPGap	(uint32);
	void SetState	(uint32);

	void Search		();

private:

	bucket ** lists;
	bucket  * buckets;

	data *data1;
	data *data2;
	data *dat;

	uint8 *repf;
	uint8 *sieve;

	uint32 curr;
	uint32 logd;
	uint32 modd;

	uint32 shift;
	uint32 state;
	uint32 gap;
	uint32 incr;

	uint32 pos;
	uint32 prp;
	uint32 ind;
	uint32 seg;

	uint32 lsize;
	uint32 rsize;
	uint32  size;
	uint32 gsize;

	uint64 use;
	uint64 rsa;
	uint64 rsp;
	uint64 sta;
	uint64 stp;
	uint64 ltp;

	void Init			();
	void InitArrays		();
	void InitStartUp	();
	void InitRepField	();
	void SetRepField	();
	void SetPos			(uint64);
	void Copyf			();
	void DoData			(uint64,data*);
	void SetData		(uint64,data*);
	void SetDataQd		(uint64,data*);
	void DataBucket		(uint32);
	void SPrimesModulo	(uint32);
	void SPrimesEratos	(uint32);
	void Store			(uint32);
	void SievePrimes	();
	void Cyrene			();
	void Sieve			(uint64);
	void Count			();
	void Coend			(uint64);
	void PGaps			(uint64);
	void SetPGap		(uint64,uint64);
	void FindPGaps		(uint64);
	void Print			(uint64);
	void PrintPrimes	(uint64,uint32);
	void PrintStatus	(uint64);
	void PrintTimes		();
	void PrintCount		();
	void BucketMore		();
	void BucketGet		(uint32);
	void BucketSet		();
	void BucketSetUse	();
	void BucketInit		();
	void BucketSieve	();
	void Bucket			(uint64);

	uint32 Correct		(uint32);
	uint32 CountSieve	(uint8*);
};

#endif //__prime_h
