#include "prime.h"
#include "count.h"
#include "print.h"
#include "label.h"

#include <stdio.h>
#include <cstdlib>

//---------------------------------------------------------------
void Prime::Print(uint64 n)
{
	for(uint32 i = 0; i < 7; i++) {
		if(state & _EC_PRINT(i)) PrintPrimes(n, i);
	}

	PrintStatus(n + incr);
}
//----------------------------------------------------------------------
void Prime::PrintStatus(uint64 n)
{
	static uint32 o = 1;

	uint32 p = (uint32)(  ( (double)(  n - rsa) / 
							(double)(rsp - rsa) ) * 100.0	);

	if(p > 100) {
		p = 100; o = 1;
	}

	if(o != p) {
		printf("\r%d%%", (o = p) );
	}
}
//----------------------------------------------------------------------
void Prime::PrintPrimes(uint64 n, uint32 j)
{
	uint8* s = ind + sieve;
	uint8* e = seg + s;

	uint32 c,i,l;

	for(uint8 *b; s < e; s++, n += 30) {

		c = ctabs[j][s[0]];

		if(c) {

			b = ptabs[j][s[0]];

			for(i = 0; i <  c; i++)
			for(l = 0; l <= j; l++) {

				files[j] << itoa64(n + bitv[b[i] + l])

					<< ((l < j) ?", " :"\n");
			}
		}
	}
}
//----------------------------------------------------------------------
void Prime::PrintCount()
{
	for(uint32 i = 0; i < 7; i++) {

		if(state & _EC_COUNT(i)) {
			printf("\n%s: %s", label[i], itoa64(count[i]) );
		}
	}
}
//----------------------------------------------------------------------
void Prime::PrintTimes()
{
	clock_t t;

	uint32 j = (state & _EC_TIMES_DETAIL) ?0 :2;

	for(uint32 i = j; i < 3; i++) {

		t = time[i+1] -
			time[i];

		printf("\n%s: %.3f sec", tlabel[i], (double)t / CLOCKS_PER_SEC);
	}
}
//----------------------------------------------------------------------
