#include "prime.h"

//---------------------------------------------------------
void Prime::SetStart(uint64 n)
{
	if(n > 0) {
		rsa	= n;	/*rsa > 0 */
	if(n > 5) {
		ltp	= n; }	/*last prime (pgaps) */
	}
}
//---------------------------------------------------------
void Prime::SetStop(uint64 n)
{
	if(n > 0) {
		if(n > 2) n -= (~n & 1); /*n = 2k + 1 */

		rsp	= n; /*rsp > 0 */
	}
}
//---------------------------------------------------------
void Prime::SetGSize(uint32 n) /*n bytes */
{
	if(n <= (1 << 14) * _EC_KB) { /*sieve size <= 2^14 KB */

		gsize = n;

		 incr = gsize * 30;
	}
}
//---------------------------------------------------------
void Prime::SetSieve(uint32 n) /*n bytes */
{
	if(n <= (1 << 14) * _EC_KB) { /*sieve size <= 2^14 KB */

		size = n;
	}
}
//---------------------------------------------------------
void Prime::SetRepF(uint32 n) /*(n)#, 7 <= n <= 23 */
{
	prp = n;
}
//---------------------------------------------------------
void Prime::SetPGap(uint32 n)
{
	gap = n;

	this->SetState( _EC_PGAPS_PRIMES );
}
//---------------------------------------------------------
void Prime::SetState(uint32 n)
{
	state |= n;
}
//---------------------------------------------------------
