#include "prime.h"
#include "count.h"
#include "print.h"

#include <climits>
#include <cmath>

//--------------------------------------------------------
void Prime::SPrimesModulo(uint32 lim) /*up to rsp^(1/4) */
{
	data1[0].prime = 3;
	data1[1].prime = 5;

	uint32 s;
	uint32 n = 7, i = 2;

	data *p;

	while(n <= lim) {

		s = (uint32) sqrt( (double)n );
		p = data1;

		while(p->prime <= s) {

			if(n % p->prime) p++;
			else
				break;
		}

		if(p->prime > s) {
			data1[i++].prime = n;
		}

		n += 2;
	}

	data1[i].prime = UINT_MAX;
}
//--------------------------------------------------------------
void Prime::SPrimesEratos(uint32 lim) /*up to rsp^(1/2) */
{	
	uint32 lint = 0;
	uint32 uint = incr + _EC_ADJUST;

	ind = 0;
	seg = gsize;

	this->DoData(lint, data1);
	this->SetPos(lint);

	while(uint < lim) {

		this->Copyf();
		this->Sieve(uint);
		this->Store(lint);

		lint += incr;
		uint += incr;
	}

	seg = (uint32) 
		ceil( (double)(lim - lint) / 30);

	this->Copyf();
	this->Sieve(lim);

	sieve[seg-1] &= 
		Correct((lim + 31) - uint);

	this->Store(lint);
}
//--------------------------------------------------------------
void Prime::Store(uint32 n)
{
	uint8* s = sieve;
	uint8* e = sieve + seg;

	static uint32 i = 0;

	uint32 j,l,c;

	for(uint8* p; s < e; s++, n += 30) {

		c = ctabs[0][s[0]];

		if(c) {
			p = ptabs[0][s[0]];

			for(j = 0; j < c; j++) {

				l = n + bitv[p[j]]; /*prime */

				if(l > shift) {

					DataBucket(l);
				}
				else {
					data2[i++].prime = l;
				}
			}
		}
	}

	data2[i].prime = UINT_MAX;
}
//--------------------------------------------------------------
