#include "prime.h"
#include "count.h"
#include "print.h"
#include "pgaps.h"

#include <cstdlib>

//---------------------------------------------------------------
void Prime::PGaps(uint64 n)
{
	if(state & _EC_PGAPS_PRIMES) {

		this->FindPGaps(n);
	}
}
//---------------------------------------------------------------
void Prime::SetPGap(uint64 f, uint64 l)
{
	if(!(state & _EC_PGAPS_CONST)) {

		gap = (uint32)(l - f);	/*set new first occurrence gap */
	}

	files[7] << itoa64(f)
		<< ", ";
	files[7] << itoa64(l - f)
		<< "\n";
}
//---------------------------------------------------------------
void Prime::FindPGaps(uint64 n)
{
	uint8* s = ind + sieve;
	uint8* e = seg + s;
	uint8* p;

	uint32 c,j;
	uint64 o;

	if(gap <= 32) { /*small gaps only */

		for(; s < e; s++, n += 30) {

			if(s[0]) {

				if( (uint32)(n - ltp) + 31 < gap) {

					ltp = ltbit[s[0]] + n;
				}
				else {
					c = ctabs[0][s[0]];
					p = ptabs[0][s[0]];

					for(j = 0; j < c; j++) {

						  o = ltp;

						ltp = bitv[p[j]] + n;

						if( (uint32)(ltp - o) > gap) {

							this->SetPGap(o, ltp);
						}
					}

					if(gap > 32) break;
				}
			}
		}
	}

	for(; s < e; s++, n += 30) { /*gaps >= 33 */

		j = (uint32)(n - ltp) + 32;

		if(gap > j) {

			j = (gap - j) / 30;

			if(s < e - j) {

				for(; j && !s[j]; j--);

				s += j;
				n += j * 30;

				if((int) j > 0) {

					ltp = ltbit[s[0]] + n;

					continue;
				}
			}
		}

		if(s[0]) {

			if( (uint32)(n - ltp) + ftbit[s[0]] > gap) {

				this->SetPGap(ltp, ftbit[s[0]] + n);
			}
	
			ltp = ltbit[s[0]] + n;
		}
	}
}
//---------------------------------------------------------------
