#include "prime.h"
#include "label.h"

uint32 v[8][2] = {

	{2,0}, /*2 */				{3,0}, /*3 */
	{5,0}, /*5 */				{3,1}, /*3, 5 */
	{5,1}, /*5, 7 */			{5,2}, /*5, 7, 11 */
	{5,3}, /*5, 7, 11, 13 */	{5,4}  /*5, 7, 11, 13, 17 */
};

//---------------------------------------------------------------
Prime::Prime()
{
	this->Init();
}
//---------------------------------------------------------------
Prime::~Prime()
{
	delete [] data1;
	delete [] data2;
	delete [] repf;
	delete [] sieve;

	/*files not closed */
}
//---------------------------------------------------------------
void Prime::Init()
{
	for(uint32 i = 0; i < 7; i++) {
		count[i] = 0; 
	}

	rsa	= 1;	/*start > 0 */
	rsp	= 1;	/*stop  > 0 */

	 size = _EC_STD_SIZE;

	gsize = _EC_STD_SIZE;
	 incr = _EC_STD_SIZE * 30;

	state = 0;

	prp = 0;	/*repf */
	gap = 0;	/*gaps */
	ltp = 5;	/*gaps */
}
//---------------------------------------------------------------
void Prime::InitArrays()
{
	this->InitRepField(); /*sets rsize */

	sieve = new uint8[size];
	 repf = new uint8[rsize];

	shift = getshift(rsp, incr); /*lower limit bucket sieve */

	uint32 a, b;

	a = pi(rsp, 4);
	b = pi(shift, 1);

	data1 = new data[a];
	data2 = new data[b];
}
//---------------------------------------------------------------
void Prime::InitStartUp()
{
	uint32 i;

	for(i = 0; i < 7; i++) { /*open files */

		if(state & _EC_PRINT(i)) files[i].open(flabel[i]);
	}

	for(i = 0; i < 7; i++) { /*count, print primes and k-tuplets */

		if(rsa <= v[i][0]) {

			if(state & _EC_COUNT(v[i][1])) count[v[i][1]] ++;
			if(state & _EC_PRINT(v[i][1])) {

				files[v[i][1]] << smallp[i] << "\n";
			}
		}
	}

	if(state & _EC_PGAPS_PRIMES ) { /*prime gaps */

		files[7].open(flabel[7]);

		if(rsa <= 2) {
			if((3 - 2) > gap) SetPGap(2,3);
		}

		if(rsa <= 3) {
			if((5 - 3) > gap) SetPGap(3,5);
		}
	}
}
//---------------------------------------------------------------
