#include "prime.h"
#include <climits>
#include <cmath>

static const uint32 offexp[30] =	{ /*( 30k + bitvalue(n) )^2 % 30 = 1 | 19 */

	0, 0,0,0,0, 0,
	0,13,0,0,0,16,
	0,29,0,0,0,37,
	0,40,0,0,0,53,
	0, 0,0,0,0,56
};

static const uint32 offset[30] =	{ /*offset mod30 */

	0,0,0,0,0,0,
	0,1,0,0,0,2,
	0,3,0,0,0,4,
	0,5,0,0,0,6,
	0,0,0,0,0,7
};

static const uint8 xmul[8][30] =	{ /*xmul mod30 */

	{1,0,5,4,3,2,1,0,3,2,1,0,1,0,3,2,1,0,1,0,3,2,1,0,5,4,3,2,1,0},
	{1,0,3,2,1,2,1,0,3,2,1,0,1,0,5,2,1,0,5,0,3,4,1,0,1,4,3,2,3,0},
	{1,0,1,4,3,4,1,0,1,2,3,0,1,0,3,2,3,0,1,0,1,2,5,0,5,2,1,2,3,0},
	{1,0,3,2,1,2,1,0,3,4,1,0,5,0,3,2,1,0,1,0,3,2,3,0,1,4,5,2,1,0},
	{1,0,1,2,5,4,1,0,3,2,3,0,1,0,1,2,3,0,5,0,1,4,3,0,1,2,1,2,3,0},
	{1,0,3,2,1,2,5,0,5,2,1,0,1,0,3,2,3,0,1,0,3,2,1,0,1,4,3,4,1,0},
	{1,0,3,2,3,4,1,0,1,4,3,0,5,0,1,2,5,0,1,0,1,2,3,0,1,2,1,2,3,0},
	{1,0,1,2,3,4,5,0,1,2,3,0,1,0,1,2,3,0,1,0,1,2,3,0,1,2,3,4,5,0}
};

//--------------------------------------------------------------
void Prime::DoData(uint64 lnt, data *d)
{
	uint32 Sqrt = (uint32) sqrt((double)(lnt + _EC_ADJUST));


	while(d->prime <= Sqrt) { 

		SetData(lnt, d++);
	}

	while(d->prime != UINT_MAX) { /*i.e 31^2 > 960, 31^2 - (960 + _EC_SHIFT) < 0 */

		SetDataQd(lnt, d++);
	}
}
//--------------------------------------------------------------
void Prime::SetDataQd(uint64 lnt, data *d)
{
	uint64 e = (uint64) d->prime;
	uint32 p = (uint32)

		(((e * e) - (lnt + _EC_SHIFT)) % incr); /*size > (2^32 / 30), incr > UINT_MAX */

	d->pos = (p / 30) |

		(offexp[d->prime % 30] << 24);
}
//--------------------------------------------------------------
void Prime::SetData(uint64 lnt, data *d)
{
	uint32 n = d->prime;
	uint32 p = 

		n - (uint32)(lnt % n);

	if(p <= _EC_ADJUST) {
	   p += n;
	}

	p += xmul[offset[n % 30]][p % 30] * n; /* n + n * 5 < UINT_MAX, n < 2^32/6 */

	d->pos = ((p - _EC_SHIFT) / 30)	|

	   ((offset[p % 30] + 
		(offset[n % 30] * 8)) << 24);
}
//--------------------------------------------------------------
void Prime::DataBucket(uint32 n)
{
	uint32 a,k,p,r;
	
	bucket *c;

	a = n - (uint32)(use % n);

	if(a <= _EC_ADJUST) { /* a + n > 2^32, a > UINT_MAX */
	   a += n;
	}

	uint64 b = xmul[offset[n % 30]][a % 30];

	b *= n;
	b += a;

	if(b > UINT_MAX) {

		r =  offset[b % 30] + 
			(offset[n % 30] * 8);

		p = (uint32)((b - _EC_SHIFT) / 30);
	}
	else {

		a = (uint32)(b);

		r =  offset[a % 30] + 
			(offset[n % 30] * 8);

		p = (a - _EC_SHIFT) / 30;
	}

	k = (p >> logd);
	p = (r << 24)	| 
		(p  & modd);

	c = lists[k];

	r = c->count++;

	c->data[r].prime = n / 15;
	c->data[r].pos   = p;

	if(r == _get_new_bucket) {

		BucketGet(k);
	}
}
//--------------------------------------------------------------
