#include "prime.h"
#include "sieve.h"
#include <cmath>

//--------------------------------------------------------------
void Prime::Sieve(uint64 lim)
{
	uint8* s = ind + sieve;
	uint8* e = seg + s;

	uint32 Sqrt = (uint32) sqrt( (double)(lim) );
	uint32 limt =

		(Sqrt < (uint32)(seg * _EC_FIXED_BITPOS)) ?Sqrt : \
				(uint32)(seg * _EC_FIXED_BITPOS);	/*limit fixed bit-position algorithm */

	uint32 a,b,c;
	uint32 o,r;

	uint8 *h,*n;
	 data *p;

	p = dat;

	for(; p->prime <= limt; p++ ->pos = (n - e) | (r << 24))
	{

		r = p->pos >> 24;
		o = p->pos & 16777215;

		n = s + o;

		h = e - p->prime;

		a = p->prime / 15;

		b = a + a;
		c = a + b;

		switch( r )
		{

					for(;;)
					{
					if(n >= e) goto out0;
		case 0:		*n &= bit7; n += c + 1;
					if(n >= e) goto out1;
		case 1:		*n &= bit0; n += b;
					if(n >= e) goto out2;
		case 2:		*n &= bit1; n += a;
					if(n >= e) goto out3;
		case 3:		*n &= bit2; n += b;
					if(n >= e) goto out4;
		case 4:		*n &= bit3; n += a;
					if(n >= e) goto out5;
		case 5:		*n &= bit4; n += b;
					if(n >= e) goto out6;
		case 6:		*n &= bit5; n += c;
					if(n >= e) goto out7;
		case 7:		*n &= bit6; n += a;

					while(n <= h)
					{
					  *n &= bit7; n += c + 1;
					  *n &= bit0;
					n[b] &= bit1; n += c;
					  *n &= bit2;
					n[b] &= bit3; n += c;
					  *n &= bit4;
					n[b] &= bit5; n += c;
					n[b] &= bit6; n += c;
					}}

					for(;;)
					{
					if(n >= e) goto out1;
		case 9:		*n &= bit0; n += c + 1;
					if(n >= e) goto out5;
		case 13:	*n &= bit4; n += b + 1;
					if(n >= e) goto out4;
		case 12:	*n &= bit3; n += a;
					if(n >= e) goto out0;
		case 8:		*n &= bit7; n += b + 1;
					if(n >= e) goto out7;
		case 15:	*n &= bit6; n += a + 1;
					if(n >= e) goto out3;
		case 11:	*n &= bit2; n += b + 1;
					if(n >= e) goto out2;
		case 10:	*n &= bit1; n += c + 1;
					if(n >= e) goto out6;
		case 14:	*n &= bit5; n += a + 1;

					while(n <= h)
					{
							*n &= bit0; n += c;
					n[		1] &= bit4;
					n[b +	2] &= bit3; n += c;
					n[		2] &= bit7;
					n[b +	3] &= bit6; n += c;
					n[		4] &= bit2;
					n[b +	5] &= bit1; n += c;
					n[b +	6] &= bit5; n += c + 7;
					}}

					for(;;)
					{
					if(n >= e) goto out2;
		case 18:	*n &= bit1; n += c + 2;
					if(n >= e) goto out4;
		case 20:	*n &= bit3; n += b + 1;
					if(n >= e) goto out0;
		case 16:	*n &= bit7; n += a + 1;
					if(n >= e) goto out6;
		case 22:	*n &= bit5; n += b + 2;
					if(n >= e) goto out1;
		case 17:	*n &= bit0; n += a;
					if(n >= e) goto out7;
		case 23:	*n &= bit6; n += b + 2;
					if(n >= e) goto out3;
		case 19:	*n &= bit2; n += c + 2;
					if(n >= e) goto out5;
		case 21:	*n &= bit4; n += a + 1;

					while(n <= h)
					{
							*n &= bit1; n += c;
					n[		2] &= bit3;
					n[b +	3] &= bit7; n += c;
					n[		4] &= bit5;
					n[b +	6] &= bit0; n += c;
					n[		6] &= bit6;
					n[b +	8] &= bit2; n += c;
					n[b +  10] &= bit4; n += c + 11;
					}}

					for(;;)
					{
					if(n >= e) goto out3;
		case 27:	*n &= bit2; n += c + 2;
					if(n >= e) goto out0;
		case 24:	*n &= bit7; n += b + 2;
					if(n >= e) goto out6;
		case 30:	*n &= bit5; n += a + 1;
					if(n >= e) goto out5;
		case 29:	*n &= bit4; n += b + 2;
					if(n >= e) goto out2;
		case 26:	*n &= bit1; n += a + 1;
					if(n >= e) goto out1;
		case 25:	*n &= bit0; n += b + 1;
					if(n >= e) goto out7;
		case 31:	*n &= bit6; n += c + 3;
					if(n >= e) goto out4;
		case 28:	*n &= bit3; n += a + 1;

					while(n <= h)
					{
							*n &= bit2; n += c;
					n[		2] &= bit7;
					n[b +	4] &= bit5; n += c;
					n[		5] &= bit4;
					n[b +	7] &= bit1; n += c;
					n[		8] &= bit0;
					n[b +	9] &= bit6; n += c;
					n[b +  12] &= bit3; n += c + 13;
					}}

					for(;;)
					{
					if(n >= e) goto out4;
		case 36:	*n &= bit3; n += c;
					if(n >= e) goto out7;
		case 39:	*n &= bit6; n += b + 1;
					if(n >= e) goto out1;
		case 33:	*n &= bit0; n += a;
					if(n >= e) goto out2;
		case 34:	*n &= bit1; n += b;
					if(n >= e) goto out5;
		case 37:	*n &= bit4; n += a;
					if(n >= e) goto out6;
		case 38:	*n &= bit5; n += b;
					if(n >= e) goto out0;
		case 32:	*n &= bit7; n += c + 1;
					if(n >= e) goto out3;
		case 35:	*n &= bit2; n += a;

					while(n <= h)
					{
							*n &= bit3; n += c;
							*n &= bit6;
					n[b +	1] &= bit0; n += c;
					n[		1] &= bit1;
					n[b +	1] &= bit4; n += c;
					n[		1] &= bit5;
					n[b +	1] &= bit7; n += c + 2;
					n[b		 ] &= bit2; n += c;
					}}

					for(;;)
					{
					if(n >= e) goto out5;
		case 45:	*n &= bit4; n += c + 1;
					if(n >= e) goto out3;
		case 43:	*n &= bit2; n += b;
					if(n >= e) goto out7;
		case 47:	*n &= bit6; n += a + 1;
					if(n >= e) goto out1;
		case 41:	*n &= bit0; n += b;
					if(n >= e) goto out6;
		case 46:	*n &= bit5; n += a;
					if(n >= e) goto out0;
		case 40:	*n &= bit7; n += b + 1;
					if(n >= e) goto out4;
		case 44:	*n &= bit3; n += c + 1;
					if(n >= e) goto out2;
		case 42:	*n &= bit1; n += a;

					while(n <= h)
					{
							*n &= bit4; n += c;
					n[		1] &= bit2;
					n[b +	1] &= bit6; n += c;
					n[		2] &= bit0;
					n[b +	2] &= bit5; n += c;
					n[		2] &= bit7;
					n[b +	3] &= bit3; n += c + 4;
					n[b		 ] &= bit1; n += c;
					}}

					for(;;)
					{
					if(n >= e) goto out6;
		case 54:	*n &= bit5; n += c + 2;
					if(n >= e) goto out2;
		case 50:	*n &= bit1; n += b + 1;
					if(n >= e) goto out3;
		case 51:	*n &= bit2; n += a;
					if(n >= e) goto out7;
		case 55:	*n &= bit6; n += b + 1;
					if(n >= e) goto out0;
		case 48:	*n &= bit7; n += a + 1;
					if(n >= e) goto out4;
		case 52:	*n &= bit3; n += b + 1;
					if(n >= e) goto out5;
		case 53:	*n &= bit4; n += c + 2;
					if(n >= e) goto out1;
		case 49:	*n &= bit0; n += a;

					while(n <= h)
					{
							*n &= bit5; n += c;
					n[		2] &= bit1;
					n[b +	3] &= bit2; n += c;
					n[		3] &= bit6;
					n[b +	4] &= bit7; n += c;
					n[		5] &= bit3;
					n[b +	6] &= bit4; n += c + 8;
					n[b		 ] &= bit0; n += c;
					}}

					for(;;)
					{
					if(n >= e) goto out7;
		case 63:	*n &= bit6; n += c + 3;
					if(n >= e) goto out6;
		case 62:	*n &= bit5; n += b + 2;
					if(n >= e) goto out5;
		case 61:	*n &= bit4; n += a + 1;
					if(n >= e) goto out4;
		case 60:	*n &= bit3; n += b + 2;
					if(n >= e) goto out3;
		case 59:	*n &= bit2; n += a + 1;
					if(n >= e) goto out2;
		case 58:	*n &= bit1; n += b + 2;
					if(n >= e) goto out1;
		case 57:	*n &= bit0; n += c + 2;
					if(n >= e) goto out0;
		case 56:	*n &= bit7; n += a + 1;

					while(n <= h)
					{
							*n &= bit6; n += c;
					n[		3] &= bit5;
					n[b +	5] &= bit4; n += c;
					n[		6] &= bit3;
					n[b +	8] &= bit2; n += c;
					n[		9] &= bit1;
					n[b +  11] &= bit0; n += c;
					n[b +  13] &= bit7; n += c + 14;
					}}
		}

		out0:
		r = (r & 56);
		continue;
		out1:
		r = (r & 56) | 1;
		continue;
		out2:
		r = (r & 56) | 2;
		continue;
		out3:
		r = (r & 56) | 3;
		continue;
		out4:
		r = (r & 56) | 4;
		continue;
		out5:
		r = (r & 56) | 5;
		continue;
		out6:
		r = (r & 56) | 6;
		continue;
		out7:
		r = (r | 7);
	}


	for(; p->prime <= Sqrt; p++ ->pos = (o - seg) | (r << 24))
	{

		r = p->pos >> 24;
		o = p->pos  & 16777215;

		if(o >= seg) {
			continue;
		}

		a = p->prime / 15;

		do {
			s[o] &= s30[r][0];
			  o  += s30[r][1] * a;
			  o  += s30[r][2];
			  r   = s30[r][3];
		}
		 while(o < seg);
	}
}
//--------------------------------------------------------------
