import java.util.Vector;
// die virtuelle Ameise zur Lsung des TSP
public class Ant {
	private double objectiveValue = 0.0;	//Lnge der Route
	private ProblemInstance data = null;	//TSP-Daten
	private AntColony colony = null;			//Zeiger auf Kolonie
	private int tour[]; 									//die Runreise als Array
	private Vector notJetVisited = null;  //noch nicht besuchte Stdte

	public Ant(ProblemInstance data, AntColony colony){
		this.data = data;
		this.colony = colony;
	}

	public double getObjectiveValue(){
		if (objectiveValue == 0.0) {;
			int count = data.getCountCities();
			for (int i=0; i<count-1; i++)
				objectiveValue += data.getDistance(tour[i], tour[i+1]);
			//Verbindung von der letzten zur ersten Stadt (Tour schlieen)
			objectiveValue += data.getDistance(tour[count-1], tour[0]);
		}
		return objectiveValue;
	}

	public void newRound(){//Ameise auf neue Wegsuche vorbereiten
		objectiveValue = 0.0;
		tour = new int[data.getCountCities()];
		notJetVisited = new Vector();
		for (int i=1; i<=data.getCountCities(); i++)
			notJetVisited.addElement(new Integer(i));
	}

	public void layPheromon(){	//auf allen Kanten Pheromon ablegen
		double p = colony.DECAY_FACTOR / objectiveValue;
		int count = data.getCountCities();
		for (int i=0; i<count-1; i++){
		    colony.addPheromon(tour[i], tour[i+1], p);
		    colony.addPheromon(tour[i+1], tour[i], p);
		}	//Tour schlieen
		colony.addPheromon(tour[count-1], tour[0], p);
		colony.addPheromon(tour[0], tour[count-1], p);
	}

	public void lookForWay() {
		int count = data.getCountCities();
		//Ausgangspunkt zufllig bestimmen
		int sel = new Double((double)count * Math.random()).intValue()+1;
		tour[0] = sel;
		notJetVisited.removeElement(new Integer(sel));
		for (int i=1; i<count; i++){ // weitere Stdte
			double sum = 0.0; //Summe der Priowerte aller erlaubten Stdte
			for (int j=0; j<notJetVisited.size(); j++){
				int pos = ((Integer)notJetVisited.elementAt(j)).intValue();
				sum += colony.getPheromon(tour[i-1], pos)
						/ data.getDistance(tour[i-1],pos);
			}
			double act = 0.0;	//Auswahlwahrscheinlichkeit
			double rand = Math.random(); //Monte-Carlo-Auswauswahl
			for (int j=0; j<notJetVisited.size(); j++){
				int pos = ((Integer)notJetVisited.elementAt(j)).intValue();
				act += colony.getPheromon(tour[i-1], pos)
						/ data.getDistance(tour[i-1],pos) / sum;
				if (rand<act){
					sel = pos;
					break;
				}
			}
			tour[i] = sel; //ausgewhlte Stadt festschreiben
			notJetVisited.removeElement(new Integer(sel));//nicht mehr besuchen
		}
		getObjectiveValue();
	}

	public String toString() {	//Ergebnis-String erzeugen
			return new Double(objectiveValue).toString();
	}
}