<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- Es wird zunächst XSL-FO erzeugt, dass dann zu PDF weiterverarbeitet wird -->	
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="styleDoc" select="document('./sxw/styles.xml')"/>
    <!-- Basis Template, dass für das Seitenlayout zuständig ist -->
    <xsl:template match="/office:document-content" xmlns:office="http://openoffice.org/2000/office"  xmlns:style="http://openoffice.org/2000/style"  
    		xmlns:text="http://openoffice.org/2000/text"  xmlns:table="http://openoffice.org/2000/table" xmlns:draw="http://openoffice.org/2000/drawing"  
    		xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
    			<xsl:variable name="pageMaster" select="$styleDoc/office:document-styles/office:automatic-styles/style:page-master[1]"/>
	    		<fo:layout-master-set>	<!-- XSL-FO funtioniert wie ein DTP-Programm, zuerst werden die Page Master definiert, anschließend kommen die Inhalte -->
        			<fo:simple-page-master master-name="{$pageMaster/@style:name}"
          			margin-top="{$pageMaster/style:properties/@fo:margin-top}"  margin-bottom="{$pageMaster/style:properties/@fo:margin-bottom}"
          			margin-left="{$pageMaster/style:properties/@fo:margin-left}"  margin-right="{$pageMaster/style:properties/@fo:margin-right}"
          			page-width="{$pageMaster/style:properties/@fo:page-width}" page-height="{$pageMaster/style:properties/@fo:page-height}">
          			<fo:region-body margin-bottom="0.5cm"/>
          			<fo:region-after extent="1cm" display-align="after"/>
        			</fo:simple-page-master>
      		</fo:layout-master-set>
		     <fo:page-sequence master-reference="{$pageMaster/@style:name}">	<!-- Den Page Master mit Inhalten fülle -->
			<fo:flow flow-name="xsl-region-body">	<!-- Die übrigen Inhalte einfügen -->
					<xsl:for-each select="office:body/child::*">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
	    </fo:root>
	</xsl:template>	<!-- In jedem Template braucht man erneut alle verwendeten Namespaces -->
	<xsl:template match="text:p | text:h"  xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" xmlns:draw="http://openoffice.org/2000/drawing"  xmlns:xlink="http://www.w3.org/1999/xlink" 
			xmlns:office="http://openoffice.org/2000/office"  xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:block>
			<xsl:for-each select="./text()">		<!-- Anschließend den Text einfügen, es können sich aber auch noch Tabulatoren und Span Elemente dazwischen befinden -->
				<xsl:value-of select="."/>
			</xsl:for-each>
		</fo:block>
	</xsl:template>
	<xsl:template match="*"></xsl:template>
</xsl:stylesheet>
