<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Es wird zunächst XSL-FO erzeugt, dass dann zu PDF weiterverarbeitet wird -->
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<!-- Basis Template, dass für das Seitenlayout zuständig ist -->
	<xsl:template match="/w:wordDocument" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:aml="http://schemas.microsoft.com/aml/2001/core">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:variable name="pageSettings" select="//w:sectPr[1]"/>
			<fo:layout-master-set>
				<!-- XSL-FO funtioniert wie ein DTP-Programm, zuerst werden die Page Master definiert, anschließend kommen die Inhalte -->
				<fo:simple-page-master master-name="main" margin-top="{format-number(number($pageSettings/w:pgMar/@w:top) div 567, '0.00cm')}" 
					margin-bottom="{format-number(number($pageSettings/w:pgMar/@w:bottom) div 567, '0.00cm')}" 
					margin-left="{format-number(number($pageSettings/w:pgMar/@w:left) div 567, '0.00cm')}" 
					margin-right="{format-number(number($pageSettings/w:pgMar/@w:right) div 567, '0.00cm')}" 
					page-width="{format-number(number($pageSettings/w:pgSz/@w:w) div 567, '0.00cm')}" 
					page-height="{format-number(number($pageSettings/w:pgSz/@w:h) div 567, '0.00cm')}">
					<fo:region-body margin-bottom="1cm"/>
					<fo:region-after extent="1cm" display-align="after"/>
					<!-- Einen Zentimeter Platz für die Fußzeile reservieren -->
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="main">
				<xsl:if test="$pageSettings/w:ftr">
					<fo:static-content flow-name="xsl-region-after">
						<!-- Fußzeileninhalte einfügen -->
						<fo:block>
							<xsl:if test="$pageSettings/w:ftr/w:p/w:pPr/w:jc">
								<xsl:attribute name="text-align"><xsl:value-of select="$pageSettings/w:ftr/w:p/w:pPr/w:jc/@w:val"/></xsl:attribute>
							</xsl:if>
							<xsl:for-each select="$pageSettings/w:ftr/w:p/w:r">
								<xsl:if test="not(w:rPr/w:rStyle/@w:val='Seitenzahl')">
									<xsl:value-of select="w:t"/>
								</xsl:if>
								<xsl:if test="w:rPr/w:rStyle/@w:val='Seitenzahl' and w:instrText=' PAGE '">
									<fo:page-number/>
								</xsl:if>
							</xsl:for-each>
						</fo:block>
					</fo:static-content>
				</xsl:if>
				<fo:flow flow-name="xsl-region-body">
					<!-- restliche Inhalte einfügen -->
					<xsl:for-each select="w:body/wx:sect">
						<xsl:apply-templates select="wx:sub-section"/>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!-- pro Subsection alle Absätze durchgehen -->
	<xsl:template match="wx:sub-section" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" 
		xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:for-each select="w:p">
			<!-- Für jeden Absatz -->
			<xsl:if test="count(w:r/w:t)=0 and count(w:hlink)=0 ">
				<fo:block space-after="10pt"/>
			</xsl:if>
			<!-- Leerzeilen behandeln -->
			<xsl:choose>
				<xsl:when test="w:pPr/w:pStyle/@w:val='Titel'">
					<!-- Titel, Überschriften und Beschriftungen werden alle gleich behandelt, nur Formatierung über Vorlage -->
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="contains(w:pPr/w:pStyle/@w:val, 'berschrift')">
					<!-- Überschriften -->
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="w:pPr/w:pStyle/@w:val='Beschriftung'">
					<!-- Tabellen- und Abbildungsbeschriftungen -->
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:when test="contains(translate(w:pPr/w:pStyle/@w:val, 'V', 'v'), 'verzeichnis')">
					<!-- Inhalts- und Tabellenverzeichnis -->
					<xsl:variable name="hName" select="w:pPr/w:pStyle/@w:val"/>
					<!-- den Namen des Styles für die weitere Referenzierung merken -->
					<xsl:variable name="hStyle" select="/w:wordDocument/w:styles/w:style[@w:styleId=$hName]"/>
					<fo:block text-align-last="justify">
						<fo:basic-link internal-destination="{w:hlink/@w:bookmark}">
							<xsl:if test="number($hStyle/w:pPr/w:ind/@w:left)>0">
								<xsl:attribute name="text-indent"><!-- Einrückung für die Überschriften zweiter Ordnung! Das geht in OO nicht -->
									<xsl:value-of select="format-number(number($hStyle/w:pPr/w:ind/@w:left) div 567, '0.00cm')"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:value-of select="w:hlink/w:pPr/w:pStyle/@w:val"/>
							<xsl:for-each select="w:hlink/w:r">
								<xsl:value-of select="w:t"/>
								<xsl:if test="w:tab/@wx:tlc='none'">
									<xsl:text> </xsl:text>
								</xsl:if>
								<!-- Tabulatoren einmal vereinfacht mit Leerzeichen ... -->
								<xsl:if test="w:tab/@wx:tlc='dot'">
									<fo:leader leader-pattern="dots"/>
								</xsl:if>
								<!-- und einmal mit leader -->
							</xsl:for-each>
						</fo:basic-link>
					</fo:block>
				</xsl:when>
				<xsl:when test="w:pPr/w:pStyle/@w:val=false()">
					<!-- Normaler Text ohne extra Stil -->
					<fo:block font-family="Times" text-align="start">
						<xsl:if test="number(w:pPr/w:spacing/@w:after) &gt; 0">
							<!-- Abstand nach dem Absatz? -->
							<xsl:attribute name="space-after"><xsl:value-of select="number(w:pPr/w:spacing/@w:after) div 20"/>pt</xsl:attribute>
						</xsl:if>
						<xsl:if test="number(w:pPr/w:spacing/@w:before) &gt; 0">
							<!-- Abstand vor dem Absatz? -->
							<xsl:attribute name="space-before"><xsl:value-of select="number(w:pPr/w:spacing/@w:before) div 20"/>pt</xsl:attribute>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="w:pPr/w:jc/@w:val='right' or w:pPr/w:jc/@w:val='center'">
								<!--zentriert, oder rechtsbündig? -->
								<xsl:attribute name="text-align"><xsl:value-of select="w:pPr/w:jc/@w:val"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="w:pPr/w:jc/@w:val='both'">
								<!-- Blocksatz? -->
								<xsl:attribute name="text-align">justify</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="text-align">left</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="w:pPr/w:rPr/w:b">
							<!-- Schriftgrad fett?-->
							<xsl:attribute name="font-weight">bold</xsl:attribute>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="number(w:pPr/w:rPr/w:sz/@w:val)>0">
								<!-- Zeichengröße definiert ?-->
								<xsl:attribute name="font-size"><xsl:value-of select="number(w:pPr/w:rPr/w:sz/@w:val) div 2"/>pt</xsl:attribute>
								<xsl:attribute name="line-height"><xsl:value-of select="(number(w:pPr/w:rPr/w:sz/@w:val) div 2)+1"/>pt</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="font-size"><!-- sonst die Zeichengröße des Standard Stils verwenden -->
								<xsl:value-of select="format-number(number(/w:wordDocument/w:styles/w:style[@w:styleId='Standard']/w:rPr/w:sz/@w:val) div 2, '0pt')"/></xsl:attribute>
								<xsl:attribute name="line-height"><xsl:value-of select="format-number(number(/w:wordDocument/w:styles/w:style[@w:styleId='Standard']/w:rPr/w:sz/@w:val) div 2 +1,'0pt')"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="w:pPr/w:rPr/w:u/@w:val='single'">
								<!-- Unterstreichungen nötig ? -->
								<fo:inline text-decoration="underline">
									<xsl:apply-templates select="w:r"/>
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="w:r"/>
							</xsl:otherwise>
						</xsl:choose>
					</fo:block>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<!-- w:p -->
		<xsl:for-each select="w:tbl">
			<!-- Evtl. vorhandene Tabellen behandeln -->
			<fo:table table-layout="fixed" border="2pt solid black">
				<xsl:for-each select="w:tblGrid/w:gridCol">
					<!-- Spalten mit Breite einrichten -->
					<fo:table-column column-width="{number(@w:w) div 22}pt"/>
				</xsl:for-each>
				<fo:table-body>
					<xsl:for-each select="w:tr">
						<fo:table-row space-before.optimum="3pt">
							<!-- Formatierungen innerhalb sind der Einfachheit halber nicht dynamisch ermittelt. -->
							<xsl:for-each select="w:tc">
								<fo:table-cell border="1pt solid black">
									<fo:block font-family="Times" font-size="12pt" margin-left="3pt" margin-right="3pt" margin-top="3pt" margin-bottom="3pt">
										<xsl:choose>
											<xsl:when test="w:p/w:pPr/w:jc/@w:val='center'">
												<!-- Zentriert? -->
												<xsl:attribute name="text-align">center</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="text-align">left</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:if test="w:p/w:pPr/w:rPr/w:b">
											<!-- Schriftgrad fett?-->
											<xsl:attribute name="font-weight">bold</xsl:attribute>
										</xsl:if>
										<xsl:apply-templates select="w:p/w:r"/>
									</fo:block>
								</fo:table-cell>
							</xsl:for-each>
						</fo:table-row>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:for-each>
		<!-- end w:tbl -->	<!-- das ganze für geschachtelte Untereinheiten wiederholen -->
		<xsl:apply-templates select="wx:sub-section"/>
	</xsl:template>
	<!-- Absatzformatierungen anwenden -->
	<xsl:template match="w:p" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:variable name="hName" select="w:pPr/w:pStyle/@w:val"/>
		<!-- den Namen des Styles für die weitere Referenzierung merken -->
		<xsl:variable name="hStyle" select="/w:wordDocument/w:styles/w:style[@w:styleId=$hName]"/>
		<fo:block font-family="{substring-before($hStyle/w:rPr/wx:font/@wx:val, ' ')}">
			<xsl:if test="aml:annotation/@w:type='Word.Bookmark.End'">
				<xsl:variable name="bID" select="aml:annotation/@aml:id"/><xsl:attribute name="id">
				<xsl:value-of select="//aml:annotation[./@aml:id=$bID]/@w:name"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$hStyle/w:rPr/w:sz">
				<xsl:attribute name="font-size"><xsl:value-of select="number($hStyle/w:rPr/w:sz/@w:val) div 2"/>pt</xsl:attribute>
				<xsl:attribute name="line-height"><xsl:value-of select="number($hStyle/w:rPr/w:sz/@w:val) div 2"/>pt</xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$hStyle/w:pPr/w:jc/@w:val='center' or $hStyle/w:pPr/w:jc/@w:val='right'">
					<!-- Zentriert oder rechtsbündig? -->
					<xsl:attribute name="text-align"><xsl:value-of select="$hStyle/w:pPr/w:jc/@w:val"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="$hStyle/w:pPr/w:jc/@w:val='both'">
					<!-- Blocksatzt? -->
					<xsl:attribute name="text-align">justify</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="text-align">left</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="number($hStyle/w:pPr/w:spacing/@w:after) &gt; 0">
				<!-- Abstand nach dem Absatz? -->
				<xsl:attribute name="space-after"><xsl:value-of select="number($hStyle/w:pPr/w:spacing/@w:after)  div 20"/>pt</xsl:attribute>
			</xsl:if>
			<xsl:if test="number($hStyle/w:pPr/w:spacing/@w:before) &gt; 0">
				<!-- Abstand vor dem Absatz? -->
				<xsl:attribute name="space-before"><xsl:value-of select="number($hStyle/w:pPr/w:spacing/@w:before) div 20"/>pt</xsl:attribute>
			</xsl:if>
			<xsl:if test="$hStyle/w:rPr/w:b">
				<!-- Schriftgrad fett?-->
				<xsl:attribute name="font-weight">bold</xsl:attribute>
			</xsl:if>
			<xsl:if test="$hStyle/w:rPr/w:i">
				<!-- Schrift kursiv?-->
				<xsl:attribute name="font-style">italic</xsl:attribute>
			</xsl:if>
			<!-- Nummerierung der Überschriften einfügen -->
			<xsl:if test="w:r/w:t">
				<xsl:value-of select="w:pPr/w:listPr/wx:t/@wx:val"/>
				<xsl:text>  </xsl:text>
			</xsl:if>
			<xsl:choose>
				<!-- Unterstreichung ?-->
				<xsl:when test="$hStyle/w:rPr/w:u/@w:val='single'">
					<fo:inline text-decoration="underline">
						<xsl:apply-templates select="w:r"/>
					</fo:inline>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="w:r"/>
				</xsl:otherwise>
			</xsl:choose>
		</fo:block>
	</xsl:template>
	<!-- und schließlich die inline Formatierungen -->
	<xsl:template match="w:r" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:if test="w:tab">
			<fo:leader leader-pattern="space" leader-length="{number(w:tab/@wx:wTab) div 348}cm"/>
		</xsl:if>
		<xsl:if test="w:t">
			<xsl:choose>
				<xsl:when test="w:rPr">
					<fo:inline>
						<xsl:if test="w:rPr/w:i">
							<xsl:attribute name="font-style">italic</xsl:attribute>
						</xsl:if>
						<xsl:if test="w:rPr/w:b">
							<xsl:attribute name="font-weight">bold</xsl:attribute>
						</xsl:if>
						<xsl:if test="w:rPr/w:u">
							<xsl:attribute name="text-decoration">underline</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="w:t"/>
					</fo:inline>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="w:t"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="w:pict">	<!-- Bilder können in Word entweder verknüpft werden -->
			<xsl:if test="not(w:pict/w:binData) and w:pict/v:shape/v:imagedata">
				<fo:block>
						<fo:external-graphic>
							<xsl:attribute name="src">url(<xsl:value-of select="w:pict/v:shape/v:imagedata/@src"/>)</xsl:attribute>
						</fo:external-graphic>
				</fo:block>
			</xsl:if>
			<xsl:if test="w:pict/w:binData"> <!-- oder als base64 kodierte Binärdaten in die XML Datei eingebettet werden -->
				<fo:float float="right">
					<fo:block>
						<fo:external-graphic>
							<xsl:attribute name="src">url("data:image/gif;base64,<xsl:value-of select="w:pict/w:binData"/>&#xA;")</xsl:attribute>
						</fo:external-graphic>
						<xsl:if test="following-sibling::node()/w:pict/v:shape/v:textbox"> <!-- Beschriftung behandeln -->
								<xsl:apply-templates select="following-sibling::node()/w:pict/v:shape/v:textbox/w:txbxContent/w:p"/>
						</xsl:if>
					</fo:block>
				</fo:float>
			</xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
