<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Es wird zunächst XSL-FO erzeugt, dass dann zu PDF weiterverarbeitet wird -->
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<!-- Basis Template, dass für das Seitenlayout zuständig ist -->
	<xsl:template match="/w:wordDocument" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:aml="http://schemas.microsoft.com/aml/2001/core">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:variable name="pageSettings" select="//w:sectPr[1]"/>
			<fo:layout-master-set>
				<!-- XSL-FO funtioniert wie ein DTP-Programm, zuerst werden die Page Master definiert, anschließend kommen die Inhalte -->
				<fo:simple-page-master master-name="main" margin-top="{format-number(number($pageSettings/w:pgMar/@w:top) div 567, '0.00cm')}" 
					margin-bottom="{format-number(number($pageSettings/w:pgMar/@w:bottom) div 567, '0.00cm')}" 
					margin-left="{format-number(number($pageSettings/w:pgMar/@w:left) div 567, '0.00cm')}" 
					margin-right="{format-number(number($pageSettings/w:pgMar/@w:right) div 567, '0.00cm')}" 
					page-width="{format-number(number($pageSettings/w:pgSz/@w:w) div 567, '0.00cm')}" 
					page-height="{format-number(number($pageSettings/w:pgSz/@w:h) div 567, '0.00cm')}">
					<fo:region-body margin-bottom="1cm"/>
					<fo:region-after extent="1cm" display-align="after"/>
					<!-- Einen Zentimeter Platz für die Fußzeile reservieren -->
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="main">
				<fo:flow flow-name="xsl-region-body">
					<!-- restliche Inhalte einfügen -->
					<xsl:for-each select="w:body/wx:sect">
						<xsl:apply-templates select="wx:sub-section"/>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!-- pro Subsection alle Absätze durchgehen -->
	<xsl:template match="wx:sub-section" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" 
		xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:for-each select="w:p">
			<!-- Für jeden Absatz -->
			<fo:block>
				<xsl:for-each select="w:r">
					<xsl:for-each select="w:t"><xsl:value-of select="."/></xsl:for-each>
				</xsl:for-each>
			</fo:block>
		</xsl:for-each>
		<xsl:apply-templates select="wx:sub-section"/>
	</xsl:template>
</xsl:stylesheet>
