/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;
import org.pdfbox.pdmodel.graphics.image.PDXObjectImage;

public class ExtractImages {
    private int imageCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";

    public static void main(String[] args) throws Exception {
        ExtractImages extractor = new ExtractImages();
        extractor.extractImages(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractImages(String[] args) throws Exception {
        if (args.length < 1 || args.length > 3) {
            ExtractImages.usage();
        } else {
            String pdfFile = null;
            String password = "";
            String prefix = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(PREFIX)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    prefix = args[i];
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (prefix == null && pdfFile.length() > 4) {
                prefix = pdfFile.substring(0, pdfFile.length() - 4);
            }
            PDDocument document = null;
            try {
                PDStandardEncryption stdEncryption;
                PDEncryptionDictionary encDictionary;
                document = PDDocument.load(pdfFile);
                if (document.isEncrypted()) {
                    if (document.isOwnerPassword(password)) {
                        document.decrypt(password);
                    } else {
                        throw new IOException("Error: You are only allowed to extract images with the owner password.");
                    }
                }
                if ((encDictionary = document.getEncryptionDictionary()) instanceof PDStandardEncryption && !document.wasDecryptedWithOwnerPassword() && !(stdEncryption = (PDStandardEncryption)encDictionary).canExtractContent()) {
                    throw new IOException("You do not have permission to extract images.");
                }
                List pages = document.getDocumentCatalog().getAllPages();
                Iterator iter = pages.iterator();
                while (iter.hasNext()) {
                    PDPage page = (PDPage)iter.next();
                    PDResources resources = page.getResources();
                    Map images = resources.getImages();
                    if (images == null) continue;
                    Iterator imageIter = images.keySet().iterator();
                    while (imageIter.hasNext()) {
                        String key = (String)imageIter.next();
                        PDXObjectImage image = (PDXObjectImage)images.get(key);
                        String name = this.getUniqueFileName(key, image.getSuffix());
                        System.out.println("Writing image:" + name);
                        image.write2file(name);
                    }
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.ExtractImages [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -suffix  <password>          Image suffix(default to pdf name)\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

