/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.annotation;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;

public abstract class PDAnnotation
implements COSObjectable {
    private COSDictionary dictionary;

    public PDAnnotation(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDRectangle getRectangle() {
        COSArray rectArray = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Rect"));
        PDRectangle rectangle = null;
        if (rectArray != null) {
            rectangle = new PDRectangle(rectArray);
        }
        return rectangle;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.dictionary.setItem(COSName.getPDFName("Rect"), (COSBase)rectangle.getCOSArray());
    }

    public int getAnnotationFlags() {
        int retval = 0;
        COSInteger f = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("F"));
        if (f != null) {
            retval = f.intValue();
        }
        return retval;
    }

    public void setAnnotationFlags(int flags) {
        COSInteger f = new COSInteger(flags);
        this.getDictionary().setItem(COSName.getPDFName("F"), (COSBase)f);
    }

    public COSBase getCOSObject() {
        return this.getDictionary();
    }
}

