/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfparser.PDFStreamParser;
import org.pdfbox.pdfwriter.ContentStreamWriter;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontDescriptor;
import org.pdfbox.pdmodel.font.PDSimpleFont;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDVariableText;
import org.pdfbox.util.PDFOperator;

public class PDAppearance {
    private PDVariableText parent;
    private String value;
    private COSString defaultAppearance;
    private PDAcroForm acroForm;
    private List widgets = new ArrayList();

    public PDAppearance(PDAcroForm theAcroForm, PDVariableText field) throws IOException {
        this.acroForm = theAcroForm;
        this.parent = field;
        PDWidget fieldWidget = field.getWidget();
        if (fieldWidget == null) {
            this.widgets = field.getKids();
        } else {
            this.widgets.add(fieldWidget);
        }
        this.defaultAppearance = this.getDefaultAppearance();
    }

    private COSString getDefaultAppearance() {
        COSString dap = this.parent.getDefaultAppearance();
        if (dap == null) {
            dap = (COSString)this.acroForm.getDictionary().getDictionaryObject(COSName.getPDFName("DA"));
        }
        return dap;
    }

    private List getOriginalStream(PDAppearanceStream appearanceStream) throws IOException {
        List tokens = null;
        if (appearanceStream != null) {
            PDFStreamParser parser = new PDFStreamParser(appearanceStream.getStream());
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private boolean containsMarkedContent(List stream) {
        return stream.contains(PDFOperator.getOperator("BMC"));
    }

    public void setAppearanceValue(String apValue) throws IOException {
        if (this.parent.isMultiline() && apValue.indexOf(10) != -1) {
            apValue = this.convertToMultiLine(apValue);
        }
        this.value = apValue;
        Iterator widgetIter = this.widgets.iterator();
        while (widgetIter.hasNext()) {
            ContentStreamWriter writer;
            ByteArrayOutputStream output;
            Map normalAppearance;
            PDAppearanceStream appearanceStream;
            PDWidget widget = (PDWidget)widgetIter.next();
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new PDAppearanceDictionary();
                widget.setAppearance(appearance);
            }
            if ((appearanceStream = (PDAppearanceStream)(normalAppearance = appearance.getNormalAppearance()).get("default")) == null) {
                COSStream cosStream = new COSStream(this.acroForm.getDocument().getDocument().getScratchFile());
                appearanceStream = new PDAppearanceStream(cosStream);
                appearanceStream.setBoundingBox(widget.getRectangle().createRetranslatedRectangle());
                appearance.setNormalAppearance(appearanceStream);
            }
            List tokens = this.getOriginalStream(appearanceStream);
            PDFont pdFont = this.getFontAndUpdateResources(tokens, appearanceStream);
            if (!this.containsMarkedContent(tokens)) {
                output = new ByteArrayOutputStream();
                writer = new ContentStreamWriter(output);
                writer.writeTokens(tokens);
                output.write(" /Tx BMC\n".getBytes());
                this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                output.write(" EMC".getBytes());
                this.writeToStream(output.toByteArray(), appearanceStream);
                continue;
            }
            if (tokens == null) continue;
            output = new ByteArrayOutputStream();
            writer = new ContentStreamWriter(output);
            float fontSize = this.calculateFontSize(pdFont, appearanceStream.getBoundingBox(), tokens, null);
            boolean foundString = false;
            for (int i = 0; i < tokens.size(); ++i) {
                if (!(tokens.get(i) instanceof COSString)) continue;
                foundString = true;
                COSString drawnString = (COSString)tokens.get(i);
                drawnString.reset();
                drawnString.append(apValue.getBytes());
            }
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            tokens.set(setFontIndex - 1, new COSFloat(fontSize));
            if (foundString) {
                writer.writeTokens(tokens);
            } else {
                int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
                int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
                if (bmcIndex != -1) {
                    writer.writeTokens(tokens, 0, bmcIndex);
                } else {
                    writer.writeTokens(tokens);
                }
                output.write("\n".getBytes());
                this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                if (emcIndex != -1) {
                    writer.writeTokens(tokens, emcIndex, tokens.size());
                }
            }
            this.writeToStream(output.toByteArray(), appearanceStream);
        }
    }

    private void insertGeneratedAppearance(PDWidget fieldWidget, OutputStream output, PDFont pdFont, List tokens, PDAppearanceStream appearanceStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(output, true);
        float fontSize = 0.0f;
        PDRectangle boundingBox = null;
        boundingBox = appearanceStream.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        printWriter.println("q");
        printWriter.println("BT");
        if (this.defaultAppearance != null) {
            String daString = this.defaultAppearance.getString();
            PDFStreamParser daParser = new PDFStreamParser(new ByteArrayInputStream(daString.getBytes()), null);
            daParser.parse();
            List daTokens = daParser.getTokens();
            fontSize = this.calculateFontSize(pdFont, boundingBox, tokens, daTokens);
            int fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"));
            if (fontIndex != -1) {
                daTokens.set(fontIndex - 1, new COSFloat(fontSize));
            }
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            daWriter.writeTokens(daTokens);
        }
        printWriter.println(this.getTextPosition(boundingBox, pdFont, fontSize, tokens));
        int q = this.parent.getQ();
        if (q != 0) {
            if (q == 1 || q == 2) {
                float fieldWidth = boundingBox.getWidth();
                float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
                float adjustAmount = fieldWidth - stringWidth - 4.0f;
                if (q == 1) {
                    adjustAmount /= 2.0f;
                }
                printWriter.println(adjustAmount + " 0 Td");
            } else {
                throw new IOException("Error: Unknown justification value:" + q);
            }
        }
        printWriter.println("(" + this.value + ") Tj");
        printWriter.println("ET Q");
        printWriter.flush();
    }

    private PDFont getFontAndUpdateResources(List tokens, PDAppearanceStream appearanceStream) throws IOException {
        PDFont retval = null;
        PDResources streamResources = appearanceStream.getResources();
        PDResources formResources = this.acroForm.getDefaultResources();
        if (formResources != null) {
            COSString da;
            if (streamResources == null) {
                streamResources = new PDResources();
                appearanceStream.setResources(streamResources);
            }
            if ((da = this.getDefaultAppearance()) != null) {
                String data = da.getString();
                PDFStreamParser streamParser = new PDFStreamParser(new ByteArrayInputStream(data.getBytes()), null);
                streamParser.parse();
                tokens = streamParser.getTokens();
            }
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            COSName cosFontName = (COSName)tokens.get(setFontIndex - 2);
            String fontName = cosFontName.getName();
            retval = (PDFont)streamResources.getFonts().get(fontName);
            if (retval == null) {
                retval = (PDFont)formResources.getFonts().get(fontName);
                streamResources.getFonts().put(fontName, retval);
            }
        }
        return retval;
    }

    private String convertToMultiLine(String line) {
        int currIdx = 0;
        int lastIdx = 0;
        StringBuffer result = new StringBuffer(line.length() + 64);
        while ((currIdx = line.indexOf(10, lastIdx)) > -1) {
            result.append(this.value.substring(lastIdx, currIdx));
            result.append(" ) Tj\n0 -13 Td\n(");
            lastIdx = currIdx + 1;
        }
        result.append(line.substring(lastIdx));
        return result.toString();
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float getLineWidth(List tokens) {
        int wIndex;
        float retval = 1.0f;
        if (tokens != null && (wIndex = tokens.indexOf(PDFOperator.getOperator("w"))) >= 1) {
            retval = ((COSNumber)tokens.get(wIndex - 1)).floatValue();
        }
        return retval;
    }

    private float calculateFontSize(PDFont pdFont, PDRectangle boundingBox, List tokens, List daTokens) throws IOException {
        int fontIndex;
        float fontSize = 0.0f;
        if (daTokens != null && (fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"))) != -1) {
            fontSize = ((COSNumber)daTokens.get(fontIndex - 1)).floatValue();
        }
        if (this.parent.doNotScroll()) {
            float widthAtFontSize1 = pdFont.getStringWidth(this.value);
            float availableWidth = boundingBox.getWidth();
            float perfectFitFontSize = availableWidth / widthAtFontSize1;
        } else if (fontSize == 0.0f) {
            float lineWidth = this.getLineWidth(tokens);
            float stringWidth = pdFont.getStringWidth(this.value);
            float height = 0.0f;
            height = pdFont instanceof PDSimpleFont ? ((PDSimpleFont)pdFont).getFontDescriptor().getFontBoundingBox().getHeight() : pdFont.getAverageFontWidth();
            float availHeight = this.getAvailableHeight(boundingBox, lineWidth);
            fontSize = availHeight / (height /= 1000.0f);
        }
        return fontSize;
    }

    private String getTextPosition(PDRectangle boundingBox, PDFont pdFont, float fontSize, List tokens) throws IOException {
        float lineWidth = this.getLineWidth(tokens);
        float pos = 0.0f;
        if (this.parent.isMultiline()) {
            int rows = (int)(this.getAvailableHeight(boundingBox, lineWidth) / (float)((int)fontSize));
            pos = (float)rows * fontSize - fontSize;
        } else if (pdFont instanceof PDSimpleFont) {
            PDFontDescriptor fd = ((PDSimpleFont)pdFont).getFontDescriptor();
            float bBoxHeight = boundingBox.getHeight();
            float fontHeight = fd.getFontBoundingBox().getHeight() + 2.0f * fd.getDescent();
            fontHeight = fontHeight / 1000.0f * fontSize;
            pos = (bBoxHeight - fontHeight) / 2.0f;
        } else {
            throw new IOException("Error: Don't know how to calculate the position for non-simple fonts");
        }
        return "2 " + pos + " Td";
    }

    private float getAvailableWidth(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getWidth() - 2.0f * lineWidth;
    }

    private float getAvailableHeight(PDRectangle boundingBox, float lineWidth) {
        return boundingBox.getHeight() - 2.0f * lineWidth;
    }
}

