; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               HotStrings
; -----------------------------------------------------------------------------
; Prefix:             hs_
; Version:            0.2
; Date:               2005-08-24
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

#include *i settings\Hotstrings.ini

init_HotStrings:
   Prefix = hs
   %Prefix%_ScriptName          = HotStrings
   %Prefix%_ScriptVersion       = 0.2
   ConfigFile_Hotstrings        = settings\Hotstrings.ini
   AddSettings_Hotstrings       = 1
   DisableIfCompiled_Hotstrings = 1

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %hs_ScriptName% - Automatische Textbausteine
      Description                   = Ersetzt eingegebene Abkrzungen automatisch mit Textbausteinen
      lng_hs_Name                   = Abkrzung/Krzel
      lng_hs_Text                   = Textbaustein
      lng_hs_OptionDirect           = Direkt ersetzen (sonst bei Leerzeichen, Enter ...)
      lng_hs_OptionOmitEnd          = Zeichen, welches die Ersetzung aufruft ignorieren
      lng_hs_OptionInside           = Ersetzung auch innerhalb von Wrtern
      lng_hs_OptionRaw              = Steuerbefehle wie z.B. {Enter}{Left} nicht umsetzen und in Klartext ausgegeben
      lng_hs_OptionAutoBS           = Abkrzung/Krzel nicht durch Textbaustein ersetzen, sondern ergnzen
      lng_hs_OptionAutoEscape       = !, +, ^, und # in Alt, Shift, Strg und Windows umsetzen
      lng_hs_OptionCase             = Klein-/Groschreibung der Abkrzung
      lng_hs_OptionCase1            = beachten
      lng_hs_OptionCase2            = ignorieren
      lng_hs_OptionCase3            = ignorieren und nicht umsetzen
      lng_hs_New                    = (neu)
      lng_hs_Duplicate              = Doppelter Eintrag
      tooltip_hs_HotstringOption_Direct    = Die Ersetzung durch den Textbaustein erfolgt direkt `nnach der Eingabe des letzten Zeichens des Krzels.`nNtzlich fr eigene Ersetzungszeichen (ahk#, mfg# ...)
      tooltip_hs_HotstringOption_OmitEnd   = Das Zeichen woraufhin der Textbaustein eingefgt wird, `nwird nicht mit ausgegeben. Ntzlich wenn z.B. hinter `ndem Textbaustein direkt weitergeschrieben werden soll.
      tooltip_hs_HotstringOption_Inside    = Eine Abkrzung wird auch dann erkannt, `nwenn sie innerhalb eines Wortes steht.
      tooltip_hs_HotstringOption_AutoBS    = Die Abkrzung wird nicht durch den Textbaustein ersetzt, `nsondern der Textbaustein wird hinter die eingegebene `nAbkrzung eingefgt.
      tooltip_hs_HotstringOption_Raw       = Der Textbaustein wird genau wie hier eingetragen ausgegeben, `nSteuerbefehle wie {Enter}, {Left}, {Home} etc. werden `nnicht durch die entsprechenden Tastatureingaben ersetzt.
      tooltip_hs_HotstringOption_AutoEscape= Mit dieser Option werden die Zeichen !, +, ^, und # wie von AutoHotkey `ngewohnt als Steuerzeichen fr Alt, Shift, Strg und Windows umgesetzt.`n1+1 steht dann z.B. fr 1 gefolgt von Shift+1.
      tooltip_hs_HotstringOption_Case1     = Die Abkrzung wird nur erkannt und duch den Textbaustein`nersetzt, wenn sie exakt in ihrer definierten Schreibweise eingegeben wurde.
      tooltip_hs_HotstringOption_Case2     = Die Abkrzung wird unabhngig von ihrer Schreibweise erkannt.`nWird die Abkrzung allerdings komplett in Grobuchstaben`ngeschrieben, wird ebenfalls der Textbaustein komplett in `nGrobuchstaben ausgegeben.
      tooltip_hs_HotstringOption_Case3     = Die Abkrzung wird unabhngig von ihrer Schreibweise erkannt.`nDer Textbaustein wird immer so ausgegeben wie er hier eingetragen wurde.
   }
   else        ; = other languages (english)
   {
      MenuName                      = %hs_ScriptName% - automatic text replacement
      Description                   = Replaces typed abbreviations automatically with text.
      lng_hs_Name                   = Abbreviation
      lng_hs_Text                   = Text
      lng_hs_OptionDirect           = replace immediately (otherwise after Space, Enter ...)
      lng_hs_OptionOmitEnd          = ignore the character which causes the replacement
      lng_hs_OptionInside           = replace inside words
      lng_hs_OptionRaw              = output control-commands like {Enter}{Left} as plain text
      lng_hs_OptionAutoBS           = don't replace abbreviation but append the text
      lng_hs_OptionAutoEscape       = substitute !, +, ^, and # with Alt, Shift, Strg or Windows
      lng_hs_OptionCase             = case sensitivity
      lng_hs_OptionCase1            = yes
      lng_hs_OptionCase2            = ignore case
      lng_hs_OptionCase3            = ignore case and don't transpose case
      lng_hs_New                    = (new)
      lng_hs_Duplicate              = duplicate entry
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   If Enable_Hotstrings <> 1
      hs_FilenameAdd = .disabled

   IfNotExist, %ConfigFile_Hotstrings%%hs_FilenameAdd%
      FileAppend, `:*C1`:ahk#`:`:AutoHotkey`n`:*`:se#`:`:Stephan Ehrmann`n`:O`:mfg`:`:Mit freundlichen Gren``r``rIhre c't-Redaktion+{Home} `; don't escape modifiers`n`:*`:wr#`:`:Wolfgang Reszel`n`:*`:sg#`:`:Sehr geehrte Damen und Herren{Left 17}+{Right 17} `; don't escape modifiers, %ConfigFile_Hotstrings%%hs_FilenameAdd%
Return

SettingsGui_HotStrings:
   AutoTrim, Off
   hs_Selected =
   Loop, Read, %ConfigFile_Hotstrings%%hs_FilenameAdd%
   {
      If A_LoopReadLine =
         continue
      hs_Hotstring4 =
      StringReplace, hs_Hotstring, A_LoopReadLine, :,
      StringReplace, hs_Hotstring, hs_Hotstring, :, 
      StringReplace, hs_Hotstring, hs_Hotstring, :`:, 
      StringReplace, hs_Hotstring, hs_Hotstring, % " `; " , 
      StringSplit, hs_Hotstring, hs_Hotstring, 
      hs_HotstringOptions[%A_Index%] = %hs_Hotstring1%
      AutoTrim, On
      hs_HotstringName[%A_Index%] = %hs_Hotstring2%
      AutoTrim, Off
      hs_HotstringText[%A_Index%] = %hs_Hotstring3%
      If hs_Hotstring4 contains don't escape modifiers
         hs_HotstringESC[%A_Index%] = 1
      Else
         hs_HotstringESC[%A_Index%] = 0
      hs_UndoHotstringOptions[%A_Index%] = %hs_Hotstring1%
      hs_UndoHotstringName[%A_Index%] = %hs_Hotstring2%
      hs_UndoHotstringText[%A_Index%] = %hs_Hotstring3%
      hs_UndoHotstringESC[%A_Index%] := hs_HotstringESC[%A_Index%]
      hs_Hotstrings = %A_Index%
   }

   hs_HotstringBox =
   Loop, %hs_Hotstrings%
   {
      hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] "|"
   }

   If A_IsCompiled = 1
      hs_Disabled = Disabled
   Else
      hs_Disabled =

   Gui, Add, ListBox, xs+10 y+5 R18 W150 AltSubmit vhs_HotstringBox ghs_sub_Select, %hs_HotstringBox%
   Gui, Add, Text, x+10 yp+3 %hs_Disabled%, %lng_hs_Name%:
   Gui, Add, Edit, x+5 ghs_sub_Store yp-3 W280 vhs_HotstringName %hs_Disabled%,
   Gui, Add, Text, y+7 xs+170 %hs_Disabled%, %lng_hs_Text%:
   Gui, Add, Edit, y+5 xs+170 ghs_sub_Store vhs_HotstringText R5 W390 %hs_Disabled%,
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_Direct %hs_Disabled%,%lng_hs_OptionDirect%
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_OmitEnd %hs_Disabled%,%lng_hs_OptionOmitEnd%
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_Inside %hs_Disabled%,%lng_hs_OptionInside%
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_AutoBS %hs_Disabled%,%lng_hs_OptionAutoBS%
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_Raw %hs_Disabled%,%lng_hs_OptionRaw%
   Gui, Add, Checkbox, y+4 ghs_sub_Store vhs_HotstringOption_AutoEscape %hs_Disabled%,%lng_hs_OptionAutoEscape%
   Gui, Add, Text, y+9 %hs_Disabled%, %lng_hs_OptionCase%:
   Gui, Add, Radio, y+3 ghs_sub_Store vhs_HotstringOption_Case1 %hs_Disabled%,%lng_hs_OptionCase1%
   Gui, Add, Radio, x+5 ghs_sub_Store vhs_HotstringOption_Case2 %hs_Disabled%,%lng_hs_OptionCase2%
   Gui, Add, Radio, x+5 ghs_sub_Store vhs_HotstringOption_Case3 %hs_Disabled%,%lng_hs_OptionCase3%

   Gui, Add, Button, -Wrap xs+10 ys+260 w25 ghs_sub_ListBox_add %hs_Disabled%, +
   Gui, Add, Button, -Wrap x+5 w25 vhs_Remove_HotstringBox ghs_sub_ListBox_remove %hs_Disabled%, 

   Gui, Add, Button, -Wrap xs+516 ys+135 ghs_sub_Undo w45 h15 %hs_Disabled%, Undo

   GuiControl,Choose, hs_HotstringBox, 1
   Gosub, hs_sub_Select
   AutoTrim, On
Return

AddSettings_HotStrings:
   If AddFreshSettings = 1
      hs_HotStrings = 0

   AddResult = 0
   Loop, Read, %AddFile%
   {
      If (A_LoopReadLine = "" AND A_Index = 1)
         continue
      hs_Hotstring4 =
      StringReplace, hs_Hotstring, A_LoopReadLine, :,
      StringReplace, hs_Hotstring, hs_Hotstring, :, 
      StringReplace, hs_Hotstring, hs_Hotstring, :`:, 
      StringReplace, hs_Hotstring, hs_Hotstring, % " `; " , 
      StringSplit, hs_Hotstring, hs_Hotstring, 
      hs_HotstringOptionsTmp = %hs_Hotstring1%
      AutoTrim, On
      hs_HotstringNameTmp = %hs_Hotstring2%
      AutoTrim, Off
      hs_HotstringTextTmp = %hs_Hotstring3%
      If hs_Hotstring4 contains don't escape modifiers
         hs_HotstringESCTmp = 1
      Else
         hs_HotstringESCTmp = 0

      hs_Duplicates = 0
      Loop, %hs_Hotstrings%
      {
         hs_Line1 :=  ":" hs_HotstringName[%A_Index%] ":`:"
         hs_Line2 :=  ":" hs_HotstringNameTmp ":`:"
;         hs_Line1 :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:"
;         hs_Line2 :=  ":" hs_HotstringOptionsTmp ":" hs_HotstringNameTmp ":`:"
         If (hs_Line1 = hs_Line2)
         {
            hs_Duplicates++
            break
         }
      }
      If hs_Duplicates = 0
      {
         hs_Hotstrings++
         hs_HotstringOptions[%hs_Hotstrings%] = %hs_HotstringOptionsTmp%
         hs_HotstringName[%hs_Hotstrings%] = %hs_HotstringNameTmp%
         hs_HotstringText[%hs_Hotstrings%] = %hs_HotstringTextTmp%
         hs_HotstringESC[%hs_Hotstrings%] := hs_HotstringESCTmp
         hs_UndoHotstringOptions[%hs_Hotstrings%] = %hs_HotstringOptionsTmp%
         hs_UndoHotstringName[%hs_Hotstrings%] = %hs_HotstringNameTmp%
         hs_UndoHotstringText[%hs_Hotstrings%] = %hs_HotstringTextTmp%
         hs_UndoHotstringESC[%hs_Hotstrings%] := hs_HotstringESCTmp
      }
   }

   hs_HotstringBox =
   Loop, %hs_Hotstrings%
   {
      hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] "|"
   }
   hs_NoStore = 1
   GuiControl,, hs_HotstringBox, %hs_HotstringBox%
   GuiControl,Choose,hs_HotstringBox,%hs_Hotstrings%
   Gosub, hs_sub_Select
   hs_NoStore = 0

Return

hs_sub_Select:
   AutoTrim, Off
   If hs_Store = 1
      return

   hs_NoStore = 1

   GuiControlGet, hs_Selected,, hs_HotstringBox
   StringReplace, hs_HotstringText, hs_HotstringText[%hs_Selected%],``n,`r`n, All  ; Do this replacement first to avoid interfering with the others below.
   StringReplace, hs_HotstringText, hs_HotstringText, ``r, `r`n, All  ; Using `r works better than `n in MS Word, etc.
   StringReplace, hs_HotstringText, hs_HotstringText, ``t, %A_Tab%, All
   StringReplace, hs_HotstringText, hs_HotstringText, ```;, `;, All
   If hs_HotstringESC[%hs_Selected%] = 0
   {
      StringReplace, hs_HotstringText, hs_HotstringText, ``!, !, All
      StringReplace, hs_HotstringText, hs_HotstringText, ``^, ^, All
      StringReplace, hs_HotstringText, hs_HotstringText, ``+, +, All
      StringReplace, hs_HotstringText, hs_HotstringText, ``#, #, All
   }
   StringReplace, hs_HotstringText, hs_HotstringText,````,``, All  ; Do this replacement first to avoid interfering with the others below.

   GuiControl,,hs_HotstringText, %hs_HotstringText%
   GuiControl,,hs_HotstringName, % hs_HotstringName[%hs_Selected%]
   hs_OptionDirect = 0
   hs_OptionAutoBS = 0
   hs_OptionInside = 0
   hs_OptionOmitEnd = 0
   hs_OptionRaw = 0
   hs_OptionCase1 = 0
   hs_OptionCase2 = 0
   hs_OptionCase3 = 0
   hs_HotstringOptions := hs_HotstringOptions[%hs_Selected%]
   IfInString, hs_HotstringOptions, *
      hs_OptionDirect = 1
   IfInString, hs_HotstringOptions, ?
      hs_OptionInside = 1
   IfInString, hs_HotstringOptions, B0
      hs_OptionAutoBS = 1
   IfInString, hs_HotstringOptions, O
      hs_OptionOmitEnd = 1
   IfInString, hs_HotstringOptions, R
      hs_OptionRaw = 1
   IfInString, hs_HotstringOptions, C1
   {
      hs_OptionCase3 = 1
      StringReplace, hs_HotstringOptions, hs_HotstringOptions, C1,
   }
   IfInString, hs_HotstringOptions, C0
   {
      hs_OptionCase2 = 1
      StringReplace, hs_HotstringOptions, hs_HotstringOptions, C0,
   }
   IfInString, hs_HotstringOptions, C
      hs_OptionCase1 = 1

   If (hs_OptionCase1 = 0 AND hs_OptionCase2 = 0 AND hs_OptionCase3 = 0 )
      hs_OptionCase2 = 1

   GuiControl,,hs_HotstringOption_Direct, %hs_OptionDirect%
   GuiControl,,hs_HotstringOption_AutoBS, %hs_OptionAutoBS%
   GuiControl,,hs_HotstringOption_OmitEnd, %hs_OptionOmitEnd%
   GuiControl,,hs_HotstringOption_Inside, %hs_OptionInside%
   GuiControl,,hs_HotstringOption_Raw, %hs_OptionRaw%
   GuiControl,,hs_HotstringOption_Case1, %hs_OptionCase1%
   GuiControl,,hs_HotstringOption_Case2, %hs_OptionCase2%
   GuiControl,,hs_HotstringOption_Case3, %hs_OptionCase3%
   GuiControl,,hs_HotstringOption_AutoEscape, % hs_HotstringESC[%hs_Selected%]
   AutoTrim, On

Return

hs_sub_Store:
   If hs_NoStore = 1
   {
      hs_NoStore = 0
      Return
   }

   Gosub, sub_CheckIfSettingsChanged
   AutoTrim, On
   GuiControlGet,hs_HotstringName,,,
   hs_HotStringName = %hs_HotStringName%
   AutoTrim, Off
   GuiControlGet,hs_HotstringText,,,
   GuiControlGet,hs_HotstringOption_Direct,,,
   GuiControlGet,hs_HotstringOption_AutoBS,,,
   GuiControlGet,hs_HotstringOption_OmitEnd,,,
   GuiControlGet,hs_HotstringOption_Inside,,,
   GuiControlGet,hs_HotstringOption_Raw,,,
   GuiControlGet,hs_HotstringOption_Case1,,,
   GuiControlGet,hs_HotstringOption_Case2,,,
   GuiControlGet,hs_HotstringOption_Case3,,,
   GuiControlGet,hs_HotstringOption_AutoEscape,,,

   if hs_HotstringName =
      hs_HotstringName = |

   StringReplace, hs_HotstringText, hs_HotstringText, ``, ````, All  ; Do this replacement first to avoid interfering with the others below.
   StringReplace, hs_HotstringText, hs_HotstringText, ``!, __altsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``^, __ctrlsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``+, __shiftsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, ``#, __winsym__, All
   StringReplace, hs_HotstringText, hs_HotstringText, `r`n, ``r, All  ; Using `r works better than `n in MS Word, etc.
   StringReplace, hs_HotstringText, hs_HotstringText, `n, ``r, All
   StringReplace, hs_HotstringText, hs_HotstringText, %A_Tab%, ``t, All
   StringReplace, hs_HotstringText, hs_HotstringText, `;, ```;, All

   If hs_HotstringOption_AutoEscape = 0
   {
      StringReplace, hs_HotstringText, hs_HotstringText, !, ``!, All
      StringReplace, hs_HotstringText, hs_HotstringText, ^, ``^, All
      StringReplace, hs_HotstringText, hs_HotstringText, +, ``+, All
      StringReplace, hs_HotstringText, hs_HotstringText, #, ``#, All
   }
   StringReplace, hs_HotstringText, hs_HotstringText, __altsym__, ``!, All
   StringReplace, hs_HotstringText, hs_HotstringText, __ctrlsym__, ``^, All
   StringReplace, hs_HotstringText, hs_HotstringText, __shiftsym__, ``+, All
   StringReplace, hs_HotstringText, hs_HotstringText, __winsym__, ``#, All

   hs_HotstringName[%hs_Selected%] := hs_HotstringName
   hs_HotstringText[%hs_Selected%] := hs_HotstringText
   hs_HotstringESC[%hs_Selected%] := hs_HotstringOption_AutoEscape

   hs_HotstringOptions[%hs_Selected%] =

   If hs_HotstringOption_Direct = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "*"
   If hs_HotstringOption_Inside = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "?"
   If hs_HotstringOption_AutoBS = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "B0"
   If hs_HotstringOption_OmitEnd = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "O"
   If hs_HotstringOption_Raw = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "R"
   If hs_HotstringOption_Case3 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "C1"
   If hs_HotstringOption_Case2 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] ""
   If hs_HotstringOption_Case1 = 1
      hs_HotstringOptions[%hs_Selected%] := hs_HotstringOptions[%hs_Selected%] "C"

   hs_HotstringBox = |
   hs_Duplicates = 0
   Loop, %hs_Hotstrings%
   {
      hs_HotstringBox := hs_HotstringBox hs_HotstringName[%A_Index%] "|"
      hs_Line1 :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:"
      if hs_Selected <>
         hs_Line2 :=  ":" hs_HotstringOptions[%hs_Selected%] ":" hs_HotstringName[%hs_Selected%] ":`:"
      If (hs_Line1 = hs_Line2 AND A_Index <> hs_Selected)
         hs_Duplicates++
   }

   if hs_Duplicates > 0
   {
      GuiControl, Disable, MainGuiOK
      ToolTip, %lng_hs_Duplicate%, % A_CaretX, % A_CaretY+15
   }
   Else
   {
      GuiControl, Enable, MainGuiOK
      ToolTip
   }

   hs_Store = 1
   GuiControlGet, hs_Selected,, hs_HotstringBox
   GuiControl,, hs_HotstringBox, %hs_HotstringBox%
   GuiControl,Choose,hs_HotstringBox, %hs_Selected%
   hs_Store = 0
   AutoTrim, On
Return

hs_sub_ListBox_remove:
   AutoTrim, Off
   Gosub, hs_sub_Store

   Loop, %hs_Hotstrings%
   {
      If A_Index < %hs_Selected%
         continue
      hs_Index := A_Index + 1
      hs_HotstringName[%A_Index%] := hs_HotstringName[%hs_Index%]
      hs_HotstringText[%A_Index%] := hs_HotstringText[%hs_Index%]
      hs_HotstringOptions[%A_Index%] := hs_HotstringOptions[%hs_Index%]
      hs_HotstringESC[%A_Index%] := hs_HotstringESC[%hs_Index%]
      hs_UndoHotstringName[%A_Index%] := hs_UndoHotstringName[%hs_Index%]
      hs_UndoHotstringText[%A_Index%] := hs_UndoHotstringText[%hs_Index%]
      hs_UndoHotstringOptions[%A_Index%] := hs_UndoHotstringOptions[%hs_Index%]
      hs_UndoHotstringESC[%A_Index%] := hs_UndoHotstringOptionsESC[%hs_Index%]
   }

   hs_Hotstrings--

   If hs_Selected > 1
      hs_Selected--
   GuiControl,Choose,hs_HotstringBox, %hs_Selected%

   If hs_Hotstrings < 1
      hs_Hotstrings = 1

   hs_NoStore = 1
   Gosub, hs_sub_Select
   hs_NoStore = 0
   AutoTrim, On
Return

hs_sub_ListBox_add:
   AutoTrim, Off
   Gosub, hs_sub_Store
   hs_Hotstrings++
   hs_HotstringName[%hs_Hotstrings%] = %lng_hs_New%
   hs_HotstringText[%hs_Hotstrings%] =
   hs_HotstringOptions[%hs_Hotstrings%] =
   hs_HotstringESC[%hs_Hotstrings%] = 0
   hs_NoStore = 1
   GuiControl,,hs_HotstringBox,%lng_hs_New%
   GuiControl,Choose,hs_HotstringBox,%hs_Hotstrings%
   Gosub, hs_sub_Select
   hs_NoStore = 0
   AutoTrim, On
Return

hs_sub_Undo:
   AutoTrim, Off
   hs_HotstringOptions[%hs_Selected%] := hs_UndoHotstringOptions[%hs_Selected%]
   hs_HotstringName[%hs_Selected%] := hs_UndoHotstringName[%hs_Selected%]
   hs_HotstringText[%hs_Selected%] := hs_UndoHotstringText[%hs_Selected%]
   hs_HotstringESC[%hs_Selected%] := hs_UndoHotstringESC[%hs_Selected%]
   hs_NoStore = 1
   Gosub, hs_sub_Select
   hs_NoStore = 0
   AutoTrim, On
Return

SaveSettings_HotStrings:
   AutoTrim, Off
   Loop, %hs_Hotstrings%
   {
      If (hs_HotstringName[%A_Index%] = "" OR hs_HotstringName[%A_Index%] = " ")
         continue
      If (func_StrRight(hs_HotstringText[%A_Index%],1) = " ")
      {
         StringTrimRight, hs_HotstringText[%A_Index%], hs_HotstringText[%A_Index%], 1
         hs_HotstringText[%A_Index%] :=  hs_HotstringText[%A_Index%] "{Space}"
      }
      If hs_HotstringESC[%A_Index%] = 1
         hs_LineESC := " `; don't escape modifiers"
      Else
         hs_LineESC =

      hs_Line :=  ":" hs_HotstringOptions[%A_Index%] ":" hs_HotstringName[%A_Index%] ":`:" hs_HotstringText[%A_Index%] hs_LineESC "`r`n"
      FileAppend, %hs_Line% , %ConfigFile_Hotstrings%.tmp
   }

   FileRead, hs_F1, %ConfigFile_Hotstrings%.disabled
   FileRead, hs_F2, %ConfigFile_Hotstrings%.tmp

   FileMove, %ConfigFile_Hotstrings%.tmp, %ConfigFile_Hotstrings%.disabled, 1
   AutoTrim, On

   If hs_F1 <> %hs_F2%
   {
      Reload = 1
   }
Return

CancelSettings_HotStrings:
   ToolTip
Return

DoEnable_HotStrings:
   IfNotExist, %ConfigFile_Hotstrings%.disabled
      return

   DoReload = 1
   FileMove, %ConfigFile_Hotstrings%.disabled, %ConfigFile_Hotstrings%,1
Return

DoDisable_HotStrings:
   IfNotExist, %ConfigFile_Hotstrings%
      return

   DoReload = 1
   FileMove, %ConfigFile_Hotstrings%, %ConfigFile_Hotstrings%.disabled,1
Return

DefaultSettings_HotStrings:
   FileDelete, %ConfigFile_Hotstrings%
   FileDelete, %ConfigFile_Hotstrings%.disabled
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------


; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------


