; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               ReadingRuler
; -----------------------------------------------------------------------------
; Prefix:             rr_
; Version:            0.3
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_ReadingRuler:
   Prefix = rr
   %Prefix%_ScriptName    = ReadingRuler
   %Prefix%_ScriptVersion = 0.3

   CustomHotkey_ReadingRuler = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_ReadingRuler       = #+  ; Standard-Hotkey
   HotkeyPrefix_ReadingRuler =      ; 'Durchgeschleiftes' Hotkey

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %rr_ScriptName% - Lese-Lineal
      Description                   = Zeigt ein Lese-Lineal oder Fadenkreuz an, welches der Maus folgt. Erleichtert das Lesen am Bildschirm.
      lng_rr_Crosshair              = Fadenkreuz
      lng_rr_Color                  = Linien-Farbe
      lng_rr_Red                    = Rot:
      lng_rr_Green                  = Grn:
      lng_rr_Blue                   = Blau:
   }
   else        ; = other languages (english)
   {
      MenuName                      = %rr_ScriptName% - ruler that helps reading
      Description                   = Shows a horizontal line or a crosshair to help you reading texts on screen
      lng_rr_Crosshair              = Crosshair
      lng_rr_Color                  = ruler-color
      lng_rr_Red                    = Red:
      lng_rr_Green                  = Green:
      lng_rr_Blue                   = Blue:
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, rr_crosshair, %ConfigFile%, %rr_ScriptName%, Crosshair, 0
   IniRead, rr_ColHex, %ConfigFile%, %rr_ScriptName%, CrosshairColor, cc9900
Return

SettingsGui_ReadingRuler:
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged XS+10 Y+5 Checked%rr_crosshair% vrr_Crosshair, %lng_rr_Crosshair%
   rr_0 = 0
   rr_255 = 255
   Gui, Add, GroupBox, y+15 w180 h160, %lng_rr_Color%
   Gui, Add, Text, XS+20 yp+25 w30, %lng_rr_Red%
   Gui, Add, Slider, x+5 yp-5 vrr_ColR Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColR%
   Gui, Add, Text, XS+20 y+3 w30, %lng_rr_Green%
   Gui, Add, Slider, x+5 yp-5 vrr_ColG Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColG%
   Gui, Add, Text, XS+20 y+3 w30, %lng_rr_Blue%
   Gui, Add, Slider, x+5 yp-5 vrr_ColB Range0-255 AltSubmit TickInterval8 ToolTip Line8 Buddy1rr_0 Buddy2rr_255 grr_sub_Color, %rr_ColB%
   Gui, Font,S20, Wingdings
   Gui, Add, Text, xs+60 y+3 vrr_ShowColor, n
   Gui, Font,S8, Courier New
   Gui, Add, Edit, x+5 yp+4 w55 vrr_ColHex Limit6 grr_sub_EditColor, %rr_ColHex%
   Gosub, rr_sub_EditColor
Return

rr_sub_EditColor:
   GuiControlGet, rr_ColHexEdit,,rr_ColHex
   StringMid, rr_ColRHex, rr_ColHexEdit, 1, 2
   StringMid, rr_ColGHex, rr_ColHexEdit, 3, 2
   StringMid, rr_ColBHex, rr_ColHexEdit, 5, 2
   ;SetFormat, Integer, D
   rr_ColRHex = 0x%rr_ColRHex%
   rr_ColGHex = 0x%rr_ColGHex%
   rr_ColBHex = 0x%rr_ColBHex%
   GuiControl,,rr_ColR,%rr_ColRHex%
   GuiControl,,rr_ColG,%rr_ColGHex%
   GuiControl,,rr_ColB,%rr_ColBHex%
   StringReplace, rr_ColRHex, rr_ColRHex, 0x,
   StringReplace, rr_ColGHex, rr_ColGHex, 0x,
   StringReplace, rr_ColBHex, rr_ColBHex, 0x,
   Gui, Font, c%rr_ColRHex%%rr_ColGHex%%rr_ColBHex% S20 , Wingdings
   GuiControl, Font, rr_ShowColor
   If A_IsSuspended <> 1
      func_SettingsChanged( "ReadingRuler" )
Return

rr_sub_Color:
   SetFormat, Integer, H
   GuiControlGet, rr_ColRHex,, rr_ColR
   GuiControlGet, rr_ColGHex,, rr_ColG
   GuiControlGet, rr_ColBHex,, rr_ColB
   StringReplace, rr_ColRHex, rr_ColRHex, 0x, 0
   StringReplace, rr_ColGHex, rr_ColGHex, 0x, 0
   StringReplace, rr_ColBHex, rr_ColBHex, 0x, 0
   StringRight, rr_ColRHex, rr_ColRHex, 2
   StringRight, rr_ColGHex, rr_ColGHex, 2
   StringRight, rr_ColBHex, rr_ColBHex, 2
   GuiControl, , rr_ColHex, %rr_ColRHex%%rr_ColGHex%%rr_ColBHex%
   Gui, Font, c%rr_ColRHex%%rr_ColGHex%%rr_ColBHex% S20 , Wingdings
   GuiControl, Font, rr_ShowColor
   SetFormat, Integer, D
   func_SettingsChanged( "ReadingRuler" )
Return

SaveSettings_ReadingRuler:
   IniWrite, %rr_crosshair%, %ConfigFile%, %rr_ScriptName%, Crosshair
   If rr_Ruler = On
      rr_Ruler =
   If rr_crosshair = 0
      Splashimage,4:Off
   IniWrite, %rr_ColHex%, %ConfigFile%, %rr_ScriptName%, CrosshairColor
Return

CancelSettings_ReadingRuler:
Return

DoEnable_ReadingRuler:
Return

DoDisable_ReadingRuler:
Return

DefaultSettings_ReadingRuler:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_ReadingRuler: ; Feststellen-Taste

   ; Wenn Lineal aus, dann einschalten
   If rr_Ruler <> On
   {
      SetTimer, rr_tim_Ruler, 0
   }
   else ; Sonst wieder ausschalten
   {
      SetTimer,rr_tim_Ruler,Off
      rr_Ruler = Off
      Splashimage,3:Off
      If rr_crosshair = 1
         Splashimage,4:Off
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

rr_tim_Ruler:
   SetWindelay,0
   Process, Priority,,L
   Coordmode, Mouse, Screen    ; Mauskoordinaten beziehen sich auf den gesamten Bildschirm
   MouseGetPos,rr_RulerX, rr_RulerY        ; Y-Koordinate der Maus
   rr_RulerY -= 2                 ; 2 Pixel nach oben schieben
   rr_RulerX -= 2                 ; 2 Pixel nach links schieben
   if rr_Ruler <> on              ; Beim ersten Aufruf
   {
      Splashimage,3:, B H1 W%A_ScreenWidth% X0 Y%rr_RulerY% CW%rr_ColHex%,,,ScreenRulerY
      If rr_crosshair = 1
         Splashimage,4:, B H%A_ScreenHeight% W1 X%rr_RulerX% Y0 CW%rr_ColHex%,,,ScreenRulerX

   }
   else                        ; Linie ist schon an, dann nur verschieben
   {
      WinMove, ScreenRulerY,,, %rr_RulerY%
      If rr_crosshair = 1
         WinMove, ScreenRulerX,, %rr_RulerX%
   }
   rr_Ruler = on                  ; Linie gilt nun als aktiviert
   Process, Priority,,%A_Priority%
return


