#! /usr/bin/perl -wT

# Adressbuch-Anwendung in Perl
# (c) Herbert Braun / Heise Zeitschriften Verlag
# Skript zu "Schnellkurs Web-Datenbank", c't 11/05

# Module laden
use strict;
use warnings;
use DBI;
use HTML::Template;
use CGI;
use CGI::Carp qw(fatalsToBrowser);

# Variablen definieren
# Autovivikation von Variablen (wie in PHP)
# ist durch use strict abgeschaltet
our($q, $dbh, $sth, $tabelle, $template, %felder_werte);
our @aktionen = qw(eingabe schreiben bearbeiten);
our @tabellen = qw(person adresse kontakt gruppe);
our $passwort = 'passwort';
our $htmlpfad = 'test/';

# CGI-Objekt $q erzeugen, alle Parameter
# auf ungueltige Zeichen pruefen
$q = new CGI;
foreach($q->param) {
 die "Ungueltige Zeichen in Feld $_" unless($q->param($_) =~ /^[\w,.& @-]*$/);
}

# Aktion auslesen
# Der parameter aktion muss "ausgabe" lauten
# oder aus je einem der Werte von @aktionen und 
# @tabelle zusammengesetzt sein, zum Beispiel
# "bearbeiten_kontakt"
my $aktion = $q->param('aktion') or die 'Keine Aktion definiert';
if ($aktion eq 'ausgabe') {
 ausgabe();
} else {
 my ($_funktion, $check);
 ($_funktion, $tabelle) = split('_', $aktion, 2);
 die 'Unbekannte Aktion definiert' unless ($_funktion && $tabelle);
 foreach (@tabellen) {$_ eq $tabelle and ++$check and last}
 $check or die "Tabelle $tabelle nicht gefunden";
 $template = new HTML::Template(filename => $htmlpfad . 'adressbuch-' . $tabelle . '.html');
 $check = 0;
 foreach (@aktionen) {$_ eq $_funktion and ++$check and last}
 $check or die "Unbekannte Aktion $aktion definiert";

 # Wert fuer aktion ok ->
 # zur Datenbank verbinden, Funktion aufrufen
 # no strict "refs" hebt kurzzeitig use strict auf
 verbinden();
 {
  no strict "refs";
  &{$_funktion}($tabelle);
 }
}
ende();


sub eingabe {
 # gibt ein leeres Eingabeformular aus.
 # Bei Adressen und Kontakten muss eine Liste
 # aller Personen aus der Datenbank geholt werden,
 # die in einem Auswahlmen erscheinen soll.
 if($tabelle eq 'adresse' || $tabelle eq 'kontakt') {
  my @_pers;
  $sth = $dbh->prepare('SELECT id, vorname, name FROM person ORDER BY name, vorname');
  $sth->execute;
  while(my $_t = $sth->fetchrow_arrayref) {
   push @_pers, {'_personid' => $_t->[0], '_personname' => $_t->[1] . ' ' . $_t->[2]};
  }
  $template->param(allepersonen => \@_pers);
 }
}


sub bearbeiten {
 # holt einen Datensatz und schreibt ihn ins Eingabeformular
 my $id = $q->param('id') or die "Keine Datensatznummer uebergeben";
 my $_treffer = $dbh->selectrow_hashref('SELECT * FROM ' . $tabelle . ' WHERE id = ' . $id) or die "Datensatz $id nicht gefunden";

 if($tabelle eq 'adresse' || $tabelle eq 'kontakt') {
  # Adressen und Kontakte benoetigen Daten
  # der verknuepften Personen
  my @_person = $dbh->selectrow_array('SELECT vorname, name FROM person WHERE id = ' . $_treffer->{'personid'});
  $_treffer->{'personname'} = join(' ', @_person);

 } elsif($tabelle eq 'gruppe') {
  # ruft die Daten aller Personen ab und prueft,
  # ob fuer sie ein Eintrag in person_gruppe vorliegt
  my @_personen;
  $sth = $dbh->prepare('SELECT id, vorname, name FROM person ORDER BY name, vorname');
  $sth->execute;
  while(my $_p = $sth->fetchrow_hashref) {
   my $_person;
   $_person->{'personname'} = $_p->{'vorname'} . ' ' . $_p->{'name'};
   $_person->{'personid'} = $_p->{'id'};
   $_person->{'personcheck'} = $dbh->selectrow_array('SELECT gruppeid FROM person_gruppe WHERE personid = ' . $_p->{'id'} . ' AND gruppeid = ' . $q->param('id'));
   push @_personen, $_person;
  }
  $_treffer->{'allepersonen'} = \@_personen;
 }

 # Ergebnisse an $template uebergeben,
 # eingabe() erledigt den Rest
 foreach(keys %$_treffer) {
  $template->param($_ => $_treffer->{$_});
 }
 eingabe($_[0]);
}


sub schreiben {
 # schreibt Eingaben in die Datenbank und gibt
 # Bestaetigungsseite mit allen Aenderungen aus.
 
 # Passwortpruefung
 $q->param('passwort') and $q->param('passwort') eq $passwort or die "Ungueltiges Passwort -- kein Schreibzugriff";

 if($q->param('loeschen') eq 'ok') {
  # Datensatz loeschen (inklusive verknuepfter Datensaetze)
  if($tabelle eq 'person') {
   foreach(qw(adresse kontakt person_gruppe)) {
    $dbh->do('DELETE FROM ' . $_ . ' WHERE personid = ' . $q->param('id'));
   }
  } elsif($tabelle eq 'gruppe') {
   $dbh->do('DELETE FROM person_gruppe WHERE gruppeid = ' . $q->param('id'));
  }
  $dbh->do('DELETE FROM ' . $tabelle . ' WHERE id = ' . $q->param('id'));
  $felder_werte{'Datensatz_geloescht'} = $q->param('id');
  bestaetigungsseite();
 }

 # lies Spaltennamen (auer "id") aus der Datenbank-$tabelle,
 # schau in $q nach, ob Werte bergeben wurden
 # und schreib beides in %felder_werte
 $sth = $dbh->prepare('SELECT * FROM ' . $tabelle);
 $sth->execute;
 my $_felder = $sth->{NAME};
 foreach (@$_felder) {
  unless ($_ eq 'id') {
   $felder_werte{$_} = $q->param($_)? '"' . $q->param($_) . '"' : 'NULL';
  }
 }

 # wenn eine Datensatznummer vorliegt, fuehre
 # eine UPDATE-Anweisung aus, ansonsten ein INSERT
 my $_sql;
 if($q->param('id')) {
  $q->param('id') =~ /^\d+$/ or die "Ungueltige Datensatznummer";
  $_sql = 'UPDATE ' . $tabelle . ' SET ' . join(', ', map {$_ . ' = ' . $felder_werte{$_}} keys %felder_werte) . ' WHERE id = ' . $q->param('id');
 } else {
  $_sql = 'INSERT ' . $tabelle . ' (' . join(', ', keys %felder_werte) . ') VALUES (' . join(', ', map {$felder_werte{$_}} keys %felder_werte) . ')';
 }
 $dbh->do($_sql);

 if($tabelle eq 'gruppe' && $q->param('id')) {
  # bei geaenderten Gruppen:
  # loesche alle Zuordnungen zur aktuellen Gruppe und
  # setz sie anhand der Felder person1, person2 etc. neu
  $dbh->do('DELETE FROM person_gruppe WHERE gruppeid = ' . $q->param('id'));
  my @_namen;
  foreach($q->param) {
   if(/^person(\d+)/ and my @_name = $dbh->selectrow_array('SELECT vorname, name FROM person WHERE id = ' . $1)) {
    $dbh->do('INSERT person_gruppe (personid, gruppeid) VALUES (?,?)', '', ($1, $q->param('id')));
    push @_namen, join(' ', @_name);
   }
  }
  $felder_werte{'Zuordnung'} = @_namen? join(', ', @_namen) : 'keine';
 }
 bestaetigungsseite();
}


sub ausgabe {
 # gibt das gesamte Adressbuch aus.
 my(@_allepersonen, @_allegruppen);
 verbinden();

 # 1) alle Personen
 $sth = $dbh->prepare('SELECT * FROM person ORDER BY name, vorname');
 $sth->execute;
 while(my $_person = $sth->fetchrow_hashref) {
  my(@_adressen, @_kontakte, @_gruppen) = ();

  my $_sth2 = $dbh->prepare('SELECT id, firma, strasse, plz, ort FROM adresse WHERE personid = ' . $_person->{'id'});
  $_sth2->execute;
  while(my $_adresse = $_sth2->fetchrow_hashref) {
   push @_adressen, $_adresse;
  }
  $_person->{'adressen'} = \@_adressen;

  $_sth2 = $dbh->prepare('SELECT id, nummer, art, bemerkung FROM kontakt WHERE personid = ' . $_person->{'id'});
  $_sth2->execute;
  while(my $_kontakt = $_sth2->fetchrow_hashref) {
   push @_kontakte, $_kontakt;
  }
  $_person->{'kontakte'} = \@_kontakte;

  $_sth2 = $dbh->prepare('SELECT gruppe.name FROM person_gruppe, gruppe WHERE person_gruppe.personid = ' . $_person->{'id'} . ' AND gruppe.id=person_gruppe.gruppeid ORDER BY gruppe.name');
  $_sth2->execute;
  while(my $_gruppe = $_sth2->fetchrow_hashref) {
   push @_gruppen, $_gruppe;
  }
  $_person->{'gruppen'} = \@_gruppen;
  push @_allepersonen, $_person;
 }

 # 2) alle Gruppen
 $sth = $dbh->prepare('SELECT * FROM gruppe ORDER BY name');
 $sth->execute;
 while(my $_gruppe = $sth->fetchrow_hashref) {
  my @_personen = ();
  my $_sth2 = $dbh->prepare('SELECT person.vorname, person.name FROM person, person_gruppe WHERE person_gruppe.gruppeid = ' . $_gruppe->{'id'} . ' AND person.id=person_gruppe.personid ORDER BY person.name, person.vorname');
  $_sth2->execute;
  while(my $_person = $_sth2->fetchrow_hashref) {
   push @_personen, $_person;
  }
  $_gruppe->{'person'} = \@_personen;
  push @_allegruppen, $_gruppe;
 }

 $template = new HTML::Template(filename => $htmlpfad . 'adressbuch-ausgabe.html');
 $template->param(personen => \@_allepersonen, gruppen => \@_allegruppen);
}


sub bestaetigungsseite {
 # gibt nach Schreibvorgang Bestaetigung mit
 # allen Werten aus
 $template = new HTML::Template(filename => $htmlpfad . 'adressbuch-bestaetigung.html');
 my @_felder;
 foreach(keys %felder_werte) {
  push @_felder, {feldname => $_, feldwert => $felder_werte{$_}};
 }
 $template->param('felder' => \@_felder, 'tabelle' => $tabelle);
 ende();
}


sub verbinden {
 # stellt eine Datenbankverbindung her
 # und legt sie in $dbh ab
 # RaiseError lsst das Skript bei SQL-Fehlern abbrechen
 # AutoCommit => 0 ermoeglicht Transaktionen, wenn
 # sie von der Datenbank unterstuetzt werden (z.B. InnoDB)
 $dbh or $dbh = DBI->connect('DBI:mysql:[Datenbankname]:[Datenbankhost]', '[Datenbankbenutzer]', '[Passwort]', {RaiseError => 1, AutoCommit => 0});
}


sub trennen {
 # trennt Datenbankverbindung, fuehrt zuvor
 # eventuell offene Transaktionen aus
 $dbh->commit;
 $sth->finish if $sth;
 $dbh->disconnect;
}


sub ende {
 # gibt HTML-Template aus, beendet Skript
 print $q->header("text/html");
 print $template->output;
 trennen();
 exit;
}
