-- 
-- Tabellenstruktur fr Tabelle person
-- 

DROP TABLE IF EXISTS person;
CREATE TABLE person (
  id int(11) unsigned NOT NULL auto_increment,
  geschlecht enum('Herr','Frau'),
  titel enum('Dr.','Prof. Dr.'),
  vorname varchar(60),
  name varchar(60) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM COMMENT='Adressbuch: Personendaten' ;

-- --------------------------------------------------------

--
-- Tabellenstruktur fr Tabelle adresse
-- 

DROP TABLE IF EXISTS adresse;
CREATE TABLE adresse (
  id int(11) NOT NULL auto_increment,
  personid int(11) NOT NULL,
  firma varchar(60),
  strasse varchar(60),
  plz varchar(10),
  ort varchar(60) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM COMMENT='Adressbuch: Adressdaten' ;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle kontakt
-- 

DROP TABLE IF EXISTS kontakt;
CREATE TABLE kontakt (
  id int(10) unsigned NOT NULL auto_increment,
  personid int(10) unsigned NOT NULL,
  nummer varchar(50) NOT NULL,
  art enum('Telefon','Fax','E-Mail') NOT NULL,
  bemerkung varchar(100),
  PRIMARY KEY  (id),
  FULLTEXT KEY bemerkung (bemerkung)
) TYPE=MyISAM COMMENT='Adressbuch: Kontaktdaten' ;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle gruppe
-- 

DROP TABLE IF EXISTS gruppe;
CREATE TABLE gruppe (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY name (name)
) TYPE=MyISAM COMMENT='Adressbuch: Gruppen' ;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle person_gruppe
-- 

DROP TABLE IF EXISTS person_gruppe;
CREATE TABLE person_gruppe (
  personid int(10) unsigned NOT NULL,
  gruppeid int(10) unsigned NOT NULL,
  PRIMARY KEY  (personid, gruppeid)
) TYPE=MyISAM COMMENT='Adressbuch: Zuordnung Person - Gruppe';


