(define (script-fu-layer-get-pos drawable)
  (let* ((image (car (gimp-drawable-get-image drawable)))
         (layerinfo (gimp-image-get-layers image))
         (num-layers (car layerinfo))
         (layers (cadr layerinfo))
         (i 0))
    
    (if (= 1 (car (gimp-drawable-is-layer drawable)))
        ; search for the layer ID
        (while (and (< i num-layers)
                    (not (= (aref layers (- num-layers i 1)) drawable)))
               (set! i (+ i 1)))
        ; else position = -1
        (set! i -1))
    ; return the position
    i
  )
)

