(define (script-fu-contrast-mask image layer radius opacity)
        (let* ((new-layer 0))
	   (gimp-image-undo-group-start image)

           (set! new-layer (car (gimp-layer-copy layer TRUE)))
	   (gimp-image-add-layer image new-layer -1)
	   (gimp-desaturate new-layer)
	   (gimp-invert new-layer)
	   (plug-in-gauss RUN-NONINTERACTIVE image new-layer radius radius 0)
	   (gimp-layer-set-mode new-layer OVERLAY-MODE)
	   (gimp-layer-set-opacity new-layer opacity)

	   (gimp-image-undo-group-end image)
	   (gimp-displays-flush)
	)
)

(script-fu-register "script-fu-contrast-mask"
                    "Kontrast maskieren..."
		    "Es wird eine Kontrastmaske erzeugt."
		    "Simon Budig"
		    "(c) 2005 c't Magazin"
		    "18. 6. 2005"
		    "RGB* GRAY*"
		    SF-IMAGE      "Eingabebild" 0
		    SF-DRAWABLE   "Aktive Ebene" 0
		    SF-ADJUSTMENT "Radius" '(40 0 4000 1 10 0 1)
		    SF-ADJUSTMENT "Deckkraft" '(50 0 100 1 10 1 1)
)

(script-fu-menu-register "script-fu-contrast-mask"
                         "<Image>/Script-Fu/Alchemy")
