/*
 * Decompiled with CFR 0.152.
 */
package de.ct.wortschatz.gui;

import de.ct.wortschatz.Wortschatz;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Thesaurus {
    public static Display display = null;
    private Shell shell = null;
    private Menu menu = null;
    private MenuItem menuitem_file = null;
    private MenuItem menuitem_help = null;
    private Menu menu_file = null;
    private Menu menu_help = null;
    private MenuItem menuitem_quit = null;
    private MenuItem menuitem_about = null;
    private GridLayout layout_Grid = null;
    private Label label_Word = null;
    private Text text_Word = null;
    private Button button_OK = null;
    private List list = null;
    private Label label_Status = null;
    private Wortschatz ws = null;

    public static void main(String[] stringArray) {
        display = new Display();
        Thesaurus thesaurus = new Thesaurus();
        thesaurus.createShell();
        thesaurus.shell.open();
        thesaurus.setStatusBar("Verbinden an Web-Service ...");
        thesaurus.getWebserviceStatus();
        while (!thesaurus.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void createShell() {
        this.ws = new Wortschatz();
        this.shell = new Shell(display);
        this.shell.setText("Wortschatz-Thesaurus");
        this.shell.setSize(330, 300);
        this.menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(this.menu);
        this.menuitem_file = new MenuItem(this.menu, 64);
        this.menuitem_file.setText("&Datei");
        this.menuitem_file.setAccelerator(65604);
        this.menu_file = new Menu((Decorations)this.shell, 4);
        this.menuitem_file.setMenu(this.menu_file);
        this.menuitem_quit = new MenuItem(this.menu_file, 8);
        this.menuitem_quit.setText("B&eenden");
        this.menuitem_quit.setAccelerator(65605);
        this.menuitem_quit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Thesaurus.this.shell.close();
                Thesaurus.this.shell.dispose();
            }
        });
        this.menuitem_help = new MenuItem(this.menu, 64);
        this.menuitem_help.setText("&Hilfe");
        this.menuitem_help.setAccelerator(65608);
        this.menu_help = new Menu((Decorations)this.shell, 4);
        this.menuitem_help.setMenu(this.menu_help);
        this.menuitem_about = new MenuItem(this.menu_help, 8);
        this.menuitem_about.setText("\u00dc&ber ...");
        this.menuitem_about.setAccelerator(65602);
        this.menuitem_about.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("Action performed!");
            }
        });
        this.label_Word = new Label((Composite)this.shell, 17408);
        this.label_Word.setText("zu suchendes Wort");
        this.text_Word = new Text((Composite)this.shell, 2048);
        this.text_Word.setEditable(true);
        this.text_Word.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    Thesaurus.this.fetchSynonyms(Thesaurus.this.text_Word.getText());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.button_OK = new Button((Composite)this.shell, 8);
        this.button_OK.setText("suchen");
        this.button_OK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Thesaurus.this.fetchSynonyms(Thesaurus.this.text_Word.getText());
            }
        });
        this.list = new List((Composite)this.shell, 2820);
        this.list.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                String string = Thesaurus.this.getSelectedWord();
                if (string != null) {
                    Clipboard clipboard = new Clipboard(display);
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transferArray = new Transfer[]{textTransfer};
                    clipboard.setContents(new Object[]{string}, transferArray);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                String string = Thesaurus.this.getSelectedWord();
                if (string != null) {
                    Thesaurus.this.text_Word.setText(string);
                    Thesaurus.this.fetchSynonyms(string);
                }
            }
        });
        this.label_Status = new Label((Composite)this.shell, 17408);
        this.layout_Grid = new GridLayout();
        this.layout_Grid.numColumns = 2;
        this.shell.setLayout((Layout)this.layout_Grid);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.label_Word.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.text_Word.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.button_OK.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.label_Status.setLayoutData((Object)gridData);
    }

    public void getWebserviceStatus() {
        this.setStatusBar(this.ws.getStatus());
    }

    public void setStatusBar(String string) {
        this.label_Status.setText(string);
    }

    private void fetchSynonyms(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        this.setStatusBar("Suchen nach '" + string + "' ...");
        this.ws.setTerm(string);
        String[] stringArray = this.ws.getSynonyms();
        this.list.removeAll();
        if (stringArray != null) {
            this.list.setItems(stringArray);
        }
        this.setStatusBar("Ausf\u00fchrungszeit: " + this.ws.getExecutionTime());
    }

    private String getSelectedWord() {
        String[] stringArray = this.list.getSelection();
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }
}

