// $Id: DemoClient.java 176 2005-06-16 09:41:58Z olau $

package de.ct.wortschatz.console;

import java.io.IOException;
import java.lang.String;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.FileAppender;
import org.apache.log4j.PatternLayout;

import de.ct.wortschatz.Wortschatz;

public class DemoClient  {

	private Logger logger = Logger.getLogger(DemoClient.class);
	
	public static void main(String[] args) {
		DemoClient cl = new DemoClient();
		if (args.length > 0) {
			System.out.println("Hole Synonyme für '" + args[0] + "' ...");
			cl.callLeipzig(args[0]);
		}
		else {
			System.err.println("Bitte übergeben Sie ein Wort, für das Synonyme gesucht werden sollen");
		}
	}
	
	public void callLeipzig(String word) {
		FileAppender fApp = null;
		PatternLayout pl = new PatternLayout();
		try {
			fApp = new FileAppender(pl, "DemoClient-log.txt", false);
			fApp.setName("DemoClient-Logger");
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
		BasicConfigurator.configure(fApp);
		logger.addAppender(fApp);
		Wortschatz ws = new Wortschatz(word);
		ws.setLogger(logger);
		String[] synonyms = ws.getSynonyms();
		if (synonyms != null) {
			System.out.println(synonyms.length + " Synonyme gefunden.");
			for (int i = 0; i < synonyms.length; i++) {
				System.out.println("- " + synonyms[i]);
			}
		}
		else {
			System.out.println("Keine Synonyme gefunden.");
		}
	}
}
