	/* c't Mikrocontroller-im-LAN Demo Source
	 * Datei: adc.c 
	 * Info: Routinen zum Einlesen der Analogeingnge
	 * Autor: Benjamin Benz (bbe@heise.de)
	 * Datum: 24.06.04
	*/
	
	#include <avr/io.h>
	#include <avr/interrupt.h>
	#include <avr/signal.h>
	
	#include <delay.h>
	#include "adc.h"
	#include "led.h"
	#include "tools.h"
	#include "uart.h"
	#include "math.h"
	
	// Soll der Filter ein oder zweistufig sein? Achtung, die 2. Stufe kann
	// ueberschwingen
	//#define ZWEISTUFIG
	
	
	//Zum Kalibrieren bentigen wir Zwei Sttzstellen. Den Rest macht der Precompiler fr uns :-)
	//Bitte entsprechend eintragen 
	
	
	//Sensor 0
	#define pt100_0_messwert_1 614.00	//Messwert 2
	#define pt100_0_realwert_1 26.50	//passende temperatur in hunderstel Grad
	
	#define pt100_0_messwert_2 458.00	//Messwert 1
	#define pt100_0_realwert_2 12.30	//passende temperatur in hunderstel Grad 
	
	//Sensor 0
	#define pt100_1_messwert_1 740.00	//Messwert 2
	#define pt100_1_realwert_1 31.60	//passende temperatur in hunderstel Grad
	
	#define pt100_1_messwert_2 771.00	//Messwert 1
	#define pt100_1_realwert_2 35.70	//passende temperatur in hunderstel Grad 
	
	
	// Nicht bearbeiten!!!
	#define pt100_0_faktor ((pt100_0_realwert_1-pt100_0_realwert_2)/(pt100_0_messwert_1-pt100_0_messwert_2))
	#define pt100_0_offset (pt100_0_realwert_1- (pt100_0_faktor*pt100_0_messwert_1))
	#define pt100_1_faktor ((pt100_1_realwert_1-pt100_1_realwert_2)/(pt100_1_messwert_1-pt100_1_messwert_2))
	#define pt100_1_offset (pt100_1_realwert_1- (pt100_1_faktor*pt100_1_messwert_1))
	
	const float korr_faktor[] ={pt100_0_faktor,pt100_1_faktor};
	const float korr_offset[] ={pt100_0_offset,pt100_1_offset};
	
	volatile int adc_buffer[ADC_BUFFER];	// Ringpuffer
	volatile char adc_ptr=0;	// Zeiger auf den Ringpuffer
	volatile char adc_channel=0;	// Welchen kanal soll der Interrupt samplen?
					// Das hchste Bit legt fest, ob der 50Hz-Filter
					// verwendet wird: 0= Filter aus, 1= Filter an?
	
	#define GLIEDER 2
	
	static int delay_x[GLIEDER+1];		// Puffer fuer alte Eingabe-Werte
	static float delay_z[GLIEDER+1]; 	// Puffer fuer alte Zwischenergebnisse
	#ifdef ZWEISTUFIG
		static float delay_y[GLIEDER+1];	// Puffer fuer alte Ergebnisse
	#endif
	
	//Filter-Entwurf mit: http://www.nauticom.net/www/jdtaft/babutter.htm
	// Koeffizienten 1. Filter-Stufe
	const float a1[GLIEDER+1] = {0, -1.8445877, 0.9536256};
	const float b[GLIEDER+1] = { 1, 0, -1 };
	// Koeffizienten 2. Filter-Stufe (b-Werte identisch mit denen der 1.Stufe	
	#ifdef ZWEISTUFIG
		const float a2[GLIEDER+1] = {0, -1.8770182, 0.9594707};
	#endif
	
	// Gleitender Mittelwert des Stromfuehlers
	float adc_mean=0;	
	
	//Gewichtungsfaktor fr den gleitenden Mittelwert. 
	//je kleiner FORGET ist, desto mehr werte werden bercksichtigt 
	#define FORGET 0.01
	
	
	// Initialisert den AD-Umsetzer. Fr jeden Kanal, den man nutzen mchte, 
	// muss das entsprechende Bit in channel gesetzt sein:
	// Bit0 = Kanal 0 usw.
	void adc_init(char channel){
		DDRA = DDRA & ~ channel;	// Pin als input
		PORTA = PORTA & ~ channel;	// Alle Pullups aus.
	}
	
	//Liest einen analogen kanal aus blockierend!!!
	//Der Parameter ist die Nummer des Pins (0x00 fr PA0; 0x01 fr PA1, ..)
	//Auslesen ist schnell!! (ca. 60 s fr einen komplette aufruf von adc_read )
	int adc_read(char channel){
		int result = 0x00;
	//	char old_DDRA= DDRA;// Alte Einstellungen sichern
	//	char old_PORTA= PORTA;
		
	//	DDRA = DDRA & ~(1<<channel);		// Pin als input
	//	PORTA = PORTA & ~ (1<<channel);	// Alle Pullups aus.
	
		// interne Refernzspannung, rechts Ausrichtung
		ADMUX=(1<<REFS1)+(1<<REFS0)+(0<<ADLAR);	
	
		ADMUX = ADMUX | channel;		// Und jetzt Kanal whlen
		
		ADCSRA= (1<<ADPS2) + (1<<ADPS1)+	// prescale faktor= 128 ADC luft
			(1<<ADPS0) +			// mit 14,7456MHz/ 128 = 115,2kHz 
			(1 << ADEN)+			// ADC an
			(1 << ADSC);			// Beginne mit der Konvertierung
				
		while ( (ADCSRA & (1<<ADSC)) != 0){} //Warten bis konvertierung beendet
						      // Das sollte 25 ADC-Zyklen dauern!
						      // also 1/4608 s
		result= ADCL; 
		result+=(ADCH <<8);	// Ergebnis zusammenbauen
		
	//	DDRA= old_DDRA;		// wiederherstellen
	//	PORTA= old_PORTA;
		
		return result;
	}
	
	//Liefert die Temperatur der PT100 Sensoren in Hunderstel Grad Celsius zurck 
	int pt100_read(char channel){
		float temp =(float)adc_read(channel);	// Wert auslesen
		temp =((korr_faktor[channel] * temp) + korr_offset[channel]);
		return floor(temp*100);
	}
	
	int filter(int in){ 
		char i;	
		
		for (i=0; i< GLIEDER; i++){	// Delay the data
			delay_x[i]=delay_x[i+1]; // Input-Daten-Delay-Kette	
			delay_z[i]=delay_z[i+1]; // Zwischen-Daten-Delay-Kette
	#ifdef ZWEISTUFIG
			delay_y[i]=delay_y[i+1]; // Output-Daten-Delay-Kette
	#endif
		}	
		
		delay_x[GLIEDER] = in;	// New Input value
		
		// Erste Filterstufe:  Ergebnisse nach delay_z
		delay_z[GLIEDER] =   b[0] * delay_x[GLIEDER-0]
				    + b[1] * delay_x[GLIEDER-1]
				    + b[2] * delay_x[GLIEDER-2]
				    - a1[1] * delay_z[GLIEDER-1]
				    - a1[2] * delay_z[GLIEDER-2];
				
		// Zweite Filterstufe:  Ergebnisse nach delay_y		
	#ifdef ZWEISTUFIG
		delay_y[GLIEDER] =   b[0] * delay_z[GLIEDER-0] 
				    + b[1] * delay_z[GLIEDER-1] 
				    + b[2] * delay_z[GLIEDER-2]
				    - a2[1] * delay_y[GLIEDER-1]
				    - a2[2] * delay_y[GLIEDER-2];
		
		//Gleitenden Mittelwert berechnen			    
		adc_mean=adc_mean * (1- FORGET) + abs(delay_y[GLIEDER])*FORGET; 
				    
		return (int)floor(delay_y[GLIEDER]);	// Ausgabe nach 2. Stufe
	#else
		//Gleitenden Mittelwert berechnen			    
		adc_mean=adc_mean * (1- FORGET) + abs(delay_z[GLIEDER])*FORGET;
		
		return (int)floor(delay_z[GLIEDER]);	// Ausgabe nach 1. Stufe
	#endif
	
	}
	
	/* Wechselt einen ADU-kanal. Dafr muessen auch die Puffer zurckgesetzt werden
	 * Das oberste Bit legt fest, ob der 50 Hz Filter mitlaufen soll, oder nicht
	 * es wird aber erst in der adc_isr() ausgewertet!!!!
	*/
	void adc_select_channel(char channel){
		cli();
		adc_channel=channel;  	
		adc_ptr=0;
		sei();
	}
	
	// Diese Routine wird vom Timer-Interrupt aufgerufen und speichert einen 
	// Messwert. (vorher wendet sie evtl. noch eine Filterfkt an)
	void adc_isr(void){
		int adc=adc_read(adc_channel& 0x7F);	// oberste Bit ist fr den Filter
		int filtered=filter(adc);    // Der Filter muss weiterlaufen
		
		if (adc_ptr < ADC_BUFFER){
			if ((adc_channel & 0x80) > 0) // mit 50 Hz Bandpass
				adc_buffer[adc_ptr++]=filtered;
			else // ohne 50Hz Bandpass
				adc_buffer[adc_ptr++]=adc;
		} 
	}
	
	/* bertrage den Inhalt des ADC-Puffers per uart */
	void adc_transmit(void){
		char i;
		char hex[6];
	
		while (adc_ptr != ADC_BUFFER) {
			asm ("nop\n");
		}	//warten bis Puffer voll
		cli();			// Alle interrupts aus, damit puffer bleibt
		for (i=0; i<64; i++){		
			int_to_str(adc_buffer[i],hex);
			uart_send(hex[0]); uart_send(hex[1]);
			uart_send(hex[2]); uart_send(hex[3]);
			uart_send(hex[4]); uart_send(hex[5]);
			uart_send('\n');
		}
		sei();			// Und weiter gehts
	}
	
	
	void filter_init(void){
		int i;
		for (i=0; i<GLIEDER+1; i++){
			delay_x[i]=0; 
	#ifdef ZWEISTUFIG
			delay_y[i]=0;
	#endif
			delay_z[i]=0;
		}
	}

