/* c't LAN-Schaltsteckdose Demo Source
 * Datei: mcu.c 
 * Info:  Demo-Hauptprogramm
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.05
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>

#include "display.h"
#include "led.h"
#include "key.h"
#include "delay.h"
#include "uart.h"
#include "adc.h"
#include "key.h"
#include "tools.h"
#include "timer.h"
#include "mcu.h"
#include "schalt.h"


#define CMD_LENGTH 5
#define CMD_STARTCODE 0x41
#define CMD_STOPCODE 0x42

#define DEST_XPORT 0
#define DEST_COM 1
#define DEST_PASSTHROUGH 2

#define COMMAND_LEDS	0x30
#define LAUFLICHT	0x31
#define SWITCH_DEST 	0x50
#define READKEY		0x60
#define READADC		0x70
// Reads 64 ADV Values
#define READADC_64	0x43	 

#define SETRELAIS	0x80
#define READRELAIS	0x81


char ticks;           //          123456789 123456789 123456789 123456789 123456789 
char TICKER_TEXT[TICKER_LENGTH] ="c't Projekt: c't-Netz-Schalter ";
char * ticker = TICKER_TEXT;
char command[CMD_LENGTH];		// Puffer fr Kommando von/an PC

//Der Mikrocontroller braucht ein paar Einstellungen, bevor wir loslegen knnen.
void init(void){
	
	PORTA=0; DDRA=0;		//Alles Eingang alles Null
	PORTB=0; DDRB=0;
	PORTC=0; DDRC=0;
	PORTD=0; DDRD=0;

	schalt_init();
	LED_init();
	
	uart_init();

	TCCR1A=0x00; // Timer 1 auf Normalbetrieb
	TCCR1B=5; // Clksoure = Quarz / 1024
	
	TCNT1H=0 ;	TCNT1L=0 ;// Timer auf 0 setzen

	display_init();
	
	timer_0_init();
	timer_1_init();
	
	// dreh_init();
	
	adc_init(0x03);	// Kanal 0 und 1 als AD-Wandler betreiben!
	uart_dest(DEST_XPORT);
}

// Liest ein Kommando von der seriellen Schnittstelle
void read_command(void){
	int i=1;
	
	command[0]=0x00;
	
	// Lesen bis Startcode kommt
	while (command[0] != CMD_STARTCODE){	
		command[0] = uart_read();
	}
	
	// Lesen bis Stopcode oder Puffer voll
	while ((i < CMD_LENGTH) && (command[i-1] != CMD_STOPCODE)){	
		command[i++] = uart_read();
	}
}

//Wertet das Kommando im Puffer aus
void evaluate_command(void){
	int adc=0;
		// hier knnte man das Kommado verifizieren!

	command[3]=0x00;	// hat nur historische Grnde. spter mal aufrumen.
	switch (command[1]) {
		case COMMAND_LEDS:	// LED Steuerung
			LED_set(command[2]);
			break;
		case SWITCH_DEST:
			uart_dest(command[2]);
			break;
		case LAUFLICHT:
			lauflicht(command[2]);
			break;
		case READKEY:
			command[2]=key_read(command[2]);
			break;
		case READADC:
			adc=adc_read(command[2]);
			command[2]= (char) (adc && 0xFF);
			command[3]= (char) ((adc >> 8) && 0xFF);
			break;
		case READADC_64:
			adc_select_channel(command[2]);			
			adc_transmit();
			break;
		case SETRELAIS:
			Relais_set(command[2]);
			break;
		case READRELAIS:
			command[2]= Relais_get();
			break;
		default:
			break;
	}
	
	//Antwort vorbereiten:
	char answer[5] = { CMD_STARTCODE, command[1], command[2], command[3], CMD_STOPCODE};
	
	uart_dest(DEST_XPORT);	// Antwort geht immer an den XPORT
	for (int i=0; i< CMD_LENGTH; i++) {
		uart_send(answer[i]);
	}
	uart_dest(DEST_OLD);	// Alte serielle Konfiguration wieder herstellen.
}


//Zeigt ein Kommando auf dem Display an
void display_command(void){
	char i=0;
	char hex[3];
	
	display_cursor(4,1);
	display_string("0x");
	to_hex(command[i],hex);
	display_string(hex);
	display_string(" ");
	i++;

	while ( (i<CMD_LENGTH) && (command[i] != CMD_STOPCODE)){
		to_hex(command[i],hex);
		display_string(hex);
		i++;
	}

	display_string(" ");
	to_hex(command[i],hex);
	display_string(hex);
}


//Liest einen Port-Pin aus. Wartet bis zu timeout und kehrt dann auch zurck 
//wenn keine nderung erfolgt ist.
char pin_read(char pin){
	char old_DDR= DDRC;	// Alte Einstellungen sichern
	char old_PORT= PORTC;
	
	char data;
	
	DDRC &= ~ (1<<pin);	// Pin as Input	
	PORTC |= (1<<pin);	// Pullup an.

	data = PINC;		//  Einlesen 
	data = (data>> pin) &1;	// und maskieren
		
	DDRC= old_DDR;		// wiederherstellen
	PORTC= old_PORT;
	
	return data;
}

int main (void){
//	int adc=0x0000;
	char hex[10];
	char Relais=0;
	char Relais_old=0;
	char key=0;	
	
	char channel=0;
	
	init();		
	
	beep();		// Hallo sagen
	lauflicht(2);

	sei();	// Aktiviere alle Interrupts 
	display_update=1;
	
	for(;;){
		Relais=Relais_get();			// Relais Ist-Zustand
		
		key= (~key_read(10)) &KEY_ALL;	// Tasten lesen und
						// aufbereiten
		if ((key & KEY_GRUEN) >0)	//Grne Taste?
			channel--;			// einen Kanal runter
		if ((key & KEY_GELB) >0)	//Gelbe Taste?
			channel++;			// einen Kanal hoch
		channel &= 0x07;			// berlufe verhindern				
		
		LED_off(LED_ALL);
		// Kanal-Anzeigen 
		if ((channel & 0x01) > 0)			// Bit 0
			LED_on(LED_GRUEN);
		if ((channel & 0x02) > 0)			// Bit 1
			LED_on(LED_GELB);
		if ((channel & 0x04) > 0)			// Bit 2
			LED_on(LED_ORANGE);
		
		if ((Relais & (1<<channel)) > 0)	// Kanal-Wert Anzeigen
			LED_on(LED_ROT);
		
		if ((key & KEY_ROT) > 0)	//Rote Taste?
			Relais=Relais ^ (1<<channel);		// Kanal togglen
		
		Relais_set(Relais);			// Relais setzen
		if (Relais_old != Relais) { 
			display_update =1;
			Relais_old=Relais;
		}

/*		adc=adc_read(1);
		display_cursor(3,1);
		display_string("A0=0x");
		to_hex((char)(adc>>8),hex);
		display_string(hex);
		to_hex((char)(adc & 0xFF),hex);
		display_string(hex);

		adc=(int)adc_mean;
		display_cursor(3,11);
		display_string("A1=0x");
		to_hex((char)(adc>>8),hex);
		display_string(hex);
		to_hex((char)(adc & 0xFF),hex);
		display_string(hex);
*/

		if (display_update >0){
			display_cursor(1,1);
			display_string(ticker);
			display_cursor(2,1);
			display_string("Relais=");
			to_hex(Relais,hex);
			display_string(hex);

			display_cursor(2,11);
			display_string("Ch=");
			to_hex(channel,hex);
			display_string(hex);			
			
			display_cursor(3,1);
			display_string("key=");
			to_hex(key,hex);
			display_string(hex);			

		}
		
		
		//Read command
		if (uart_data_available() ==1){
			read_command();
			display_command();
			evaluate_command();		
		}
		
	}
	
	return 1;
}
