/*
 * Created on 04.10.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author bbe
 *
 * Container for an Event
 */

public class TimerEvent {
	
	private int special;		// Special Event oder nicht?
	private int channel;		// Maske für die betroffenen Kanäle
	private int data;			// Werte für die betroffenen Kanäle
	
	private int second;		// Zeitpunkt des Ereignisses
	private int minute;		// wird ein Feld nicht benutzt, steht es 
	private int hour;			// auf DONTCARE
	private int day;
	private int month;
	private int year;		// Achtung das Jahr 255 bedeutet DONTCARE
	private int weekday;
	
	public static int DONTCARE	= 255;
	public static int SIZE = 10;
	
	/**
	 * 
	 */
	public TimerEvent() {
		super();
	}
	/* Create an Event from serial Data */
	public TimerEvent(int[] newData){
		super();
		timerFromSerial(newData);
	}
	
	/* Initializes an event from a serial data Stream */
	public void timerFromSerial(int[] newData){
		int i=0;
		
		second= newData[i++];
		minute= newData[i++]; 
		hour=   newData[i++];
		day=    newData[i++];
		month=  newData[i++];
		year=   newData[i++] +  newData[i++]*256;
		weekday=newData[i++];
		
		special= (newData[i]>>7) & 1;
		channel=  newData[i++] & 0x7F;
		data=  newData[i++];

	}
	
	public String toString(){
		String str = "";
		
		if (day==DONTCARE) str+="XX."; else str+=day+".";
		if (month==DONTCARE) str+="XX."; else str+=month+".";
		if (year==DONTCARE) str+="XXXX "; else str+=year+" ";

		str+=weekday+" ";
		
		if (hour==DONTCARE) str+="XX:"; else str+=day+":";
		if (minute==DONTCARE) str+="XX:"; else str+=minute+":";
		if (second==DONTCARE) str+="XXXX "; else str+=second+" ";

		str+="Type: "+special+" Ch: "+channel+" Value: "+data;
		return str;
	}
	
	public int[] getSerial(){
		int[] serial = new int[SIZE];
		
		int i=0;
				
		serial[i++]= second;		// Zeitpunkt des Ereignisses
		serial[i++]= minute;		// wird ein Feld nicht benutzt, steht es 
		serial[i++]= hour;			// auf DONTCARE
		serial[i++]= day;
		serial[i++]= month;
		serial[i++]= year & 0xFF;		// Achtung das Jahr 255 bedeutet DONTCARE
		serial[i++]= (year /256) &0xFF;		// Achtung das Jahr 255 bedeutet DONTCARE
		
		serial[i++]=weekday;
		
		serial[i++]= (channel & 0x7F) | ((special << 7) & 0x80);		// Maske für die betroffenen Kanäle
		serial[i++]= data;			// Werte für die betroffenen Kanäle

		
		return serial;
	}
	/**
	 * @return Returns the channel.
	 */
	public int getChannel() {
		return channel;
	}
	/**
	 * @param channel The channel to set.
	 */
	public void setChannel(int channel) {
		this.channel = channel;
	}
	/**
	 * @return Returns the data.
	 */
	public int getData() {
		return data;
	}
	/**
	 * @param data The data to set.
	 */
	public void setData(int data) {
		this.data = data;
	}
	/**
	 * @return Returns the day.
	 */
	public int getDay() {
		return day;
	}
	/**
	 * @param day The day to set.
	 */
	public void setDay(int day) {
		this.day = day;
	}
	/**
	 * @return Returns the hour.
	 */
	public int getHour() {
		return hour;
	}
	/**
	 * @param hour The hour to set.
	 */
	public void setHour(int hour) {
		this.hour = hour;
	}
	/**
	 * @return Returns the minute.
	 */
	public int getMinute() {
		return minute;
	}
	/**
	 * @param minute The minute to set.
	 */
	public void setMinute(int minute) {
		this.minute = minute;
	}
	/**
	 * @return Returns the month.
	 */
	public int getMonth() {
		return month;
	}
	/**
	 * @param month The month to set.
	 */
	public void setMonth(int month) {
		this.month = month;
	}
	/**
	 * @return Returns the second.
	 */
	public int getSecond() {
		return second;
	}
	/**
	 * @param second The second to set.
	 */
	public void setSecond(int second) {
		this.second = second;
	}
	/**
	 * @return Returns the year.
	 */
	public int getYear() {
		return year;
	}
	/**
	 * @param year The year to set.
	 */
	public void setYear(int year) {
		this.year = year;
	}
	/**
	 * @return Returns the weekday.
	 */
	public int getWeekday() {
		return weekday;
	}
	/**
	 * @param weekday The weekday to set.
	 */
	public void setWeekday(int weekday) {
		this.weekday = weekday;
	}
	/**
	 * @return Returns the special.
	 */
	public boolean getSpecial() {
		if (special==0) 
			return false;
		else
			return true;
	}
	/**
	 * @param special The special to set.
	 */
	public void setSpecial(boolean special) {
		if (special==true)
			this.special = 1;
		else 
			this.special = 0;
	}
}
