/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: display.c 
 * Info: Routinen zur Displaysteuerung
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/


#include <avr/io.h>
#include <avr/delay.h>
#include "../mcu.h"


#include "display.h"
#include "led.h"
#include "delay.h"

#ifdef DISPLAY_AVAILABLE
volatile char display_update=0;


#define DISPLAY_CLEAR 0x01
#define DISPLAY_CURSORHOME 0x02

#define DISPLAY_OUT 0x07

#define DPC (PORTC & ~DISPLAY_OUT)
//#define DRC (DDRC & ~DISPLAY_PINS)

void wait_busy(void){ //warten bis Busy-Flag vom Display aus
	char data=0x08;

	while (data==0x08){
		
		PORTC= DPC | 0x02; // RS=0, RW=1, E=0
		
		asm("nop");  asm("nop");
		PORTC= DPC | 0x06 ;  // RS=0, RW=1, E=1
		asm("nop"); asm("nop"); asm("nop"); asm("nop"); asm("nop"); //warten bis Busy-Flag bereit
		data= (PINC && 0x08);	// Flag lesen
		asm("nop"); asm("nop");	
		PORTC= DPC | 0x02; // E zuruecksetzen
	}	
}


void display_cmd(char cmd){		//ein Kommando cmd an das Display senden
	int i;
	PORTC =DPC |0;
	
	for (i=8; i>0; i--){
		PORTC = DPC |(cmd >> 7);      // Das oberste Bit von cmd auf PC0
		asm("nop");
		PORTC |= DPC | 0x02;	  		  // und PC1 takten
		asm("nop");
		cmd= cmd << 1;		      // cmd links schieben
		asm("nop"); asm("nop");
		PORTC= DPC | 0x00;
	}
	for (i=0; i<100; i++){
		asm("nop"); 
	}
	asm("nop"); asm("nop"); asm("nop"); asm("nop");
	PORTC=DPC | 0x04; // RS=0, RW=0, E setzen, damit wird gleichzeitig Inhalt 
				// des Schieberegisters auf dieparallelen Displayleitungen gegeben
				// das Display ist LAHM, daher warten
	
	for (i=0; i<2500; i++){
		asm("nop"); 
	}
	
	PORTC=DPC |0x00;
	
	wait_busy();
}

void display_clear(void){
	 display_cmd(DISPLAY_CLEAR); // Display lschen, Cursor Home
}


/*
** LCD_Cursor: Position the LCD cursor at "row", "column".
*/
void display_cursor (int row, int column) {
   switch (row) {
    case 1:
		display_cmd (0x80 + column - 1);
		break;
    case 2:
		display_cmd (0xc0 + column - 1);
		break;
    case 3:
		display_cmd (0x94 + column - 1);
		break;
    case 4:
		display_cmd (0xd4 + column - 1);
		break;
    default: break;
   }
}

void display_data(char data){ //ein Zeichen aus data in den Displayspeicher schreiben
	int i;
	PORTC=DPC | 0;
	for (i=8; i>0; i--){
		PORTC = DPC | (data >> 7);    // Das oberste Bit von cmd auf PC0
		asm("nop");
		PORTC |= 0x02;	  		  // und PC1 takten
		asm("nop");
		data= data << 1;		      // cmd links schieben
		asm("nop"); asm("nop");
		PORTC=DPC | 0x00;
	}
	PORTC= DPC | 5 ; //nur mit RS=1 statt RS=0
	for (i=0; i<2500; i++){
		asm("nop"); 
	}
	PORTC=DPC |0x01;
	wait_busy();	
}


void display_init(void){
	DDRC= (DDRC &~DISPLAY_OUT) | 0x07; 		// Display Ports PC0-2
							//PC3 Eingang
	display_cmd(0x38);  		//Display auf 8 Bit Betrieb
	display_cmd(0x0f);  		//Display On, Cursor On, Cursor Blink
	
	display_cmd(DISPLAY_CLEAR); // Display lschen, Cursor Home
	display_data('i'); 			// ein i zur Begruessung ausgeben
}

int display_string(char data[20]){
	int i=0;
	
	while ((i<20) && (data[i] != 0x00)){ 	// Abbruch, sobald ein Nullstring erreicht wird
						// oder 20 Zeichen gesendet sind
		display_data(data[i++]);	// einzelnes Zeichen schicken
	}
	
	// return -1 falls string zuende, 0 falls zeile (20 zeichen) zuende
	if (data[i]==0x00)	return -1;	else return 0;
}
/*
int display_line(char line, char data[20]) {
	display_cursor(line,1);		// position Cursor	
	return display_string(data);	
}


void display_screen(char data[80]){	// lscht das Display und schreibt bis zu 80 Zeichen
	display_cmd(DISPLAY_CLEAR);
	for (int i=1; i<5; i++){
		if (display_line(i, data + (i-1)*20) == -1)
			break;
	}
}
*/

/*
void display_cursor_test(void) {		// Test-Methode zur Display-Steuerung
	display_cursor(1,1);
	display_data('1'); display_data(':'); display_data('1');

	display_cursor(2,1);
	display_data('2'); display_data(':'); display_data('1');

	display_cursor(3,1);
	display_data('3'); display_data(':'); display_data('1');

	display_cursor(4,1);
	display_data('4'); display_data(':'); display_data('1');

	display_cursor(1,10);
	display_data('1'); display_data(':'); display_data('1'); display_data('0');

	display_cursor(2,10);
	display_data('2'); display_data(':'); display_data('1'); display_data('0');

	display_cursor(3,10);
	display_data('3'); display_data(':'); display_data('1'); display_data('0');

	display_cursor(4,10);
	display_data('4'); display_data(':'); display_data('1'); display_data('0');
}
*/
#endif