/* c't-Netz-Schalter Demo Source
 * Datei: event.h
 * Info: Routinen fr die Zeitschaltuhr
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 29.09.05
*/
#include "mcu.h"

#define EVENT_SPECIAL  1
#define EVENT_GETTIME	0x0	
			

typedef struct {
   unsigned char channel:7;   // 7 Bit fr die Kanalmaske
   unsigned char special:1;   // 0 ==> Relais-Event 1 ==> anderes Event 
   unsigned char data:8; 	// 1 Byte fr die Daten
} action_t;

typedef struct {
	char second;		// Zeitpunkt des Ereignisses
	char minute;		// wird ein Feld nicht benutzt, steht es 
	char hour;		// auf DONTCARE
	#ifdef RTC_FULL_AVAILABLE
		char day;
		char month;
		int year __attribute__ ((packed));	// Achtung das Jahr 255 bedeutet DONTCARE
	#endif
	char weekday;		// Bitfeld fr die Wochentage Bit0 = Sonntag

	// Steht in channel der Wert EVENT_SPECIAL, steht in data ein EVENT_xxx-
	// Kommando, sonst geht es um die Relais. 
	// Da wir nur 7 Relais haben ist das kein Problem	

	action_t action;		// Was soll geschehen?
//	char channel;		// Maske fr die betroffenen Kanle
//	char data;		// Werte fr die betroffenen Kanle
} event_t;

extern event_t event;	// Ein Event im RAM um damit zu arbeiten
extern char events;

/* sichert das Arbeitsevent event an die Stelle des eventEEPROMPtr im EEPROM*/
void event_ToEEPROM(unsigned char eventPtr);

/* ldt das Arbeitsevent event von der Stelle des eventEEPROMPtr des EEPROMs*/
void event_FromEEPROM(unsigned char eventPtr);

void event_cron(void	);

void event_init(void);

/* Transmit one event via uart */ 
void event_transmit(char ev);
/* Receive one event from uart */ 
char event_receive(char ev);

/* Delete Event ev from EEPROM */
void event_delete(char ev);

void event_test(void);


