/* c't LAN-Schaltsteckdose Demo Source
 * Datei: mcu.c 
 * Info:  Demo-Hauptprogramm
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.05
*/
#include "mcu.h"

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>

#include <string.h>
#include <stdio.h>

#include "lib/display.h"
#include "lib/led.h"
#include "lib/key.h"
#include "lib/delay.h"
#include "lib/uart.h"
#include "lib/adc.h"
#include "lib/key.h"
#include "lib/tools.h"
#include "timer.h"

#include "schalt.h"
#include "lib/rtc.h"
#include "lib/event.h"
#include "lib/command.h"

#include "lib/command.h"
#include "lib/ir.h"
#include "lib/rc5.h"
	
#ifdef TICKER_AVAILABLE
	#define TICKER_LENGTH 32	

	char ticks;           //          123456789 123456789 123456789 12345 
	char TICKER_TEXT[TICKER_LENGTH] =" c't-Projekt: c't-Netz-Schalter ";
	char * ticker = TICKER_TEXT;
	char ticker_dir=0;
#endif


char Relais=0;


//Der Mikrocontroller braucht ein paar Einstellungen, bevor wir loslegen knnen.
void init(void){
	
	PORTA=0; DDRA=0;		//Alles Eingang alles Null
	PORTB=0; DDRB=0;
	PORTC=0; DDRC=0;
	PORTD=0; DDRD=0;

	schalt_init();
	#ifdef LED_AVAILABLE
		LED_init();
	#endif

	#ifdef UART_AVAILABLE	
		uart_init();
	#endif

	#ifdef DISPLAY_AVAILABLE
		display_init();
	#endif
	
	timer_0_init();
	timer_1_init();
	timer_2_init();
	
	// dreh_init();
	#ifdef RC5_AVAILABLE
		ir_init();
	#endif
	
	#ifdef ADC_AVAILABLE
		adc_init(0x0F);	// Kanal 0,1,2,3 als AD-Wandler betreiben!
	#endif

	#ifdef UART_AVAILABLE	
		uart_dest(DEST_XPORT);
	#endif
	
	#ifdef EVENT_AVAILABLE
		event_init();
	#endif
}

#ifdef DISPLAY_AVAILABLE
	void display(void){
		unsigned char hex[20];
		if (display_update >0){
			#ifdef TICKER_AVAILABLE
				display_cursor(1,1);
				display_string(ticker);
			#endif

			display_cursor(2,1);
			display_string("Re=");
			to_hex(Relais,hex);
			display_string(hex);

/*			display_cursor(2,11);
			display_string("Ch=");
			to_hex(channel,hex);
			display_string(hex);			

			display_cursor(2,11);
			display_string("Ev=");
			to_hex(events,hex);
			display_string(hex);
*/			
			#ifdef RC5_AVAILABLE
				display_string(" RC=");
				to_hex((char)(RC5_Code>>8),hex);
				display_string(hex);
				to_hex((char)(RC5_Code & 0xFF),hex);
				display_string(hex);
			#endif
			
			#ifdef RTC_AVAILABLE
				display_cursor(3,1);
				#ifdef RTC_FULL_AVAILABLE
					sprintf(hex,"%2d.%2d.%2d %1d %2d:%2d:%2d ", rtc_day,rtc_month,rtc_year % 100,rtc_weekday,rtc_hour, rtc_minute, rtc_second);
				#else
					sprintf(hex,"%1d %2d:%2d:%2d ", rtc_weekday,rtc_hour, rtc_minute, rtc_second);
				#endif
				display_string(hex);
			#endif

		}
	}
#endif
	
int main (void){
	#ifdef DISPLAY_AVAILABLE
		char Relais_old=0;	
	#endif
	#ifdef KEY_AVAILABLE
		char key=0;	
		char channel=0;
	#endif
	#ifndef RTC_AVAILABLE
		int delay_loop=0;
	#endif
	
	init();		
		
	#ifdef DISPLAY_AVAILABLE
		display_update=1;
	#endif
	
	#ifdef WELCOME_AVAILABLE
		display_cursor(1,1);
		display_string("c't-Netz-Schalter");
		beep();		// Hallo sagen
	#endif
	
	for(;;){	

		Relais=Relais_get();			// Relais Ist-Zustand
		
		#ifdef KEY_AVAILABLE
			key= key_read();	// Tasten lesen 
							
			if ((key & KEY_GRUEN) >0)	//Grne Taste?
				channel--;			// einen Kanal runter
			if ((key & KEY_GELB) >0)	//Gelbe Taste?
				channel++;			// einen Kanal hoch
			channel &= 0x07;		// berlufe verhindern				
	
			if ((key & KEY_ROT) > 0)	//Rote Taste?
				Relais=Relais ^ (1<<channel);		// Kanal togglen

			#ifdef RTC_HTTPTIME_AVAILABLE
				if ((key & KEY_ORANGE) > 0)	//Orange Taste?
					rtc_get_httptime();
			#endif
			
			#ifdef LED_AVAILABLE
				LED_off(LED_ALL);		// Kanal-Anzeigen 
				if ((channel & 0x01) > 0)	// Bit 0
					LED_on(LED_GRUEN);
				if ((channel & 0x02) > 0)	// Bit 1
					LED_on(LED_GELB);
				if ((channel & 0x04) > 0)	// Bit 2
					LED_on(LED_ORANGE);
				
				if ((Relais & (1<<channel)) > 0)// Kanal-Wert
					LED_on(LED_ROT);
			#endif	
			
		#endif

		Relais_set(Relais);			// Relais setzen
		#ifdef DISPLAY_AVAILABLE
			if (Relais_old != Relais) { 
					display_update =1;
				Relais_old=Relais;
			}		
		#endif
			
			
		#ifdef COMMAND_AVAILABLE		
			//Read command
			if (uart_data_available() ==1)
				if (read_command()==1){
					#ifdef DISPLAY_AVAILABLE
						display_command();
					#endif
					evaluate_command();		
				}
		#endif
		
		// Some Stuff only todo once a second
		#ifdef RTC_AVAILABLE
			if (rtc_new_second ==1) {
				rtc_new_second=0;
		#else
			delay_loop++;
			if (delay_loop==20) {
			delay_loop=0;	
		#endif

				#ifdef RC5_AVAILABLE
					rc5_control();
				#endif
				#ifdef EVENT_AVAILABLE
					event_cron();
				#endif		
		
				#ifdef TICKER_AVAILABLE							
					if (ticker_dir ==0)
						ticks++;
					else 
						ticks--;
					
					if (ticks == TICKER_LENGTH-20)
						ticker_dir=1;
					if (ticks == 0)
						ticker_dir=0;
					
					ticker = TICKER_TEXT + ticks;					
				#endif
				
				#ifdef DISPLAY_AVAILABLE
					display_update=1;
				#endif
			}
			
		#ifdef DISPLAY_AVAILABLE
			display();
		#endif

	}
	
	return 1;
}
